package com.java110.front.components.activities;


import com.java110.core.context.IPageData;
import com.java110.front.smo.common.ICommonGetSMO;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;


/**
 * 应用组件管理类
 * <p>
 * add by wuxw
 * <p>
 * 2019-06-29
 */
@Component("chooseActivities")
public class ChooseActivitiesComponent {

    @Autowired
    private ICommonGetSMO commonGetSMOImpl;

    /**
     * 查询应用列表
     *
     * @param pd 页面数据封装
     * @return 返回 ResponseEntity 对象
     */
    public ResponseEntity<String> list(IPageData pd) {
        pd.setApiUrl("/api/activities.listActivitiess");
        return commonGetSMOImpl.doService(pd);
    }


}
