package com.java110.store.listener.smallWeChat;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.java110.po.wechatMenu.WechatMenuPo;
import com.java110.utils.constant.BusinessTypeConstant;
import com.java110.utils.constant.ResponseConstant;
import com.java110.utils.constant.StatusConstant;
import com.java110.utils.exception.ListenerExecuteException;
import com.java110.utils.util.Assert;
import com.java110.core.annotation.Java110Listener;
import com.java110.core.context.DataFlowContext;
import com.java110.entity.center.Business;
import com.java110.store.dao.IWechatMenuServiceDao;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 删除公众号菜单信息 侦听
 *
 * 处理节点
 * 1、businessWechatMenu:{} 公众号菜单基本信息节点
 * 2、businessWechatMenuAttr:[{}] 公众号菜单属性信息节点
 * 3、businessWechatMenuPhoto:[{}] 公众号菜单照片信息节点
 * 4、businessWechatMenuCerdentials:[{}] 公众号菜单证件信息节点
 * 协议地址 ：https://github.com/java110/MicroCommunity/wiki/%E5%88%A0%E9%99%A4%E5%95%86%E6%88%B7%E4%BF%A1%E6%81%AF-%E5%8D%8F%E8%AE%AE
 * Created by wuxw on 2018/5/18.
 */
@Java110Listener("deleteWechatMenuInfoListener")
@Transactional
public class DeleteWechatMenuInfoListener extends AbstractWechatMenuBusinessServiceDataFlowListener {

    private final static Logger logger = LoggerFactory.getLogger(DeleteWechatMenuInfoListener.class);
    @Autowired
    IWechatMenuServiceDao wechatMenuServiceDaoImpl;

    @Override
    public int getOrder() {
        return 3;
    }

    @Override
    public String getBusinessTypeCd() {
        return BusinessTypeConstant.BUSINESS_TYPE_DELETE_WECHAT_MENU;
    }

    /**
     * 根据删除信息 查出Instance表中数据 保存至business表 （状态写DEL） 方便撤单时直接更新回去
     * @param dataFlowContext 数据对象
     * @param business 当前业务对象
     */
    @Override
    protected void doSaveBusiness(DataFlowContext dataFlowContext, Business business) {
        JSONObject data = business.getDatas();

        Assert.notEmpty(data,"没有datas 节点，或没有子节点需要处理");

            //处理 businessWechatMenu 节点
            if(data.containsKey(WechatMenuPo.class.getSimpleName())){
                Object _obj = data.get(WechatMenuPo.class.getSimpleName());
                JSONArray businessWechatMenus = null;
                if(_obj instanceof JSONObject){
                    businessWechatMenus = new JSONArray();
                    businessWechatMenus.add(_obj);
                }else {
                    businessWechatMenus = (JSONArray)_obj;
                }
                //JSONObject businessWechatMenu = data.getJSONObject(WechatMenuPo.class.getSimpleName());
                for (int _wechatMenuIndex = 0; _wechatMenuIndex < businessWechatMenus.size();_wechatMenuIndex++) {
                    JSONObject businessWechatMenu = businessWechatMenus.getJSONObject(_wechatMenuIndex);
                    doBusinessWechatMenu(business, businessWechatMenu);
                    if(_obj instanceof JSONObject) {
                        dataFlowContext.addParamOut("wechatMenuId", businessWechatMenu.getString("wechatMenuId"));
                    }
                }

        }


    }

    /**
     * 删除 instance数据
     * @param dataFlowContext 数据对象
     * @param business 当前业务对象
     */
    @Override
    protected void doBusinessToInstance(DataFlowContext dataFlowContext, Business business) {
        String bId = business.getbId();
        //Assert.hasLength(bId,"请求报文中没有包含 bId");

        //公众号菜单信息
        Map info = new HashMap();
        info.put("bId",business.getbId());
        info.put("operate",StatusConstant.OPERATE_DEL);

        //公众号菜单信息
        List<Map> businessWechatMenuInfos = wechatMenuServiceDaoImpl.getBusinessWechatMenuInfo(info);
        if( businessWechatMenuInfos != null && businessWechatMenuInfos.size() >0) {
            for (int _wechatMenuIndex = 0; _wechatMenuIndex < businessWechatMenuInfos.size();_wechatMenuIndex++) {
                Map businessWechatMenuInfo = businessWechatMenuInfos.get(_wechatMenuIndex);
                flushBusinessWechatMenuInfo(businessWechatMenuInfo,StatusConstant.STATUS_CD_INVALID);
                wechatMenuServiceDaoImpl.updateWechatMenuInfoInstance(businessWechatMenuInfo);
                dataFlowContext.addParamOut("wechatMenuId",businessWechatMenuInfo.get("wechat_menu_id"));
            }
        }

    }

    /**
     * 撤单
     * 从business表中查询到DEL的数据 将instance中的数据更新回来
     * @param dataFlowContext 数据对象
     * @param business 当前业务对象
     */
    @Override
    protected void doRecover(DataFlowContext dataFlowContext, Business business) {
        String bId = business.getbId();
        //Assert.hasLength(bId,"请求报文中没有包含 bId");
        Map info = new HashMap();
        info.put("bId",bId);
        info.put("statusCd",StatusConstant.STATUS_CD_INVALID);

        Map delInfo = new HashMap();
        delInfo.put("bId",business.getbId());
        delInfo.put("operate",StatusConstant.OPERATE_DEL);
        //公众号菜单信息
        List<Map> wechatMenuInfo = wechatMenuServiceDaoImpl.getWechatMenuInfo(info);
        if(wechatMenuInfo != null && wechatMenuInfo.size() > 0){

            //公众号菜单信息
            List<Map> businessWechatMenuInfos = wechatMenuServiceDaoImpl.getBusinessWechatMenuInfo(delInfo);
            //除非程序出错了，这里不会为空
            if(businessWechatMenuInfos == null ||  businessWechatMenuInfos.size() == 0){
                throw new ListenerExecuteException(ResponseConstant.RESULT_CODE_INNER_ERROR,"撤单失败（wechatMenu），程序内部异常,请检查！ "+delInfo);
            }
            for (int _wechatMenuIndex = 0; _wechatMenuIndex < businessWechatMenuInfos.size();_wechatMenuIndex++) {
                Map businessWechatMenuInfo = businessWechatMenuInfos.get(_wechatMenuIndex);
                flushBusinessWechatMenuInfo(businessWechatMenuInfo,StatusConstant.STATUS_CD_VALID);
                wechatMenuServiceDaoImpl.updateWechatMenuInfoInstance(businessWechatMenuInfo);
            }
        }
    }



    /**
     * 处理 businessWechatMenu 节点
     * @param business 总的数据节点
     * @param businessWechatMenu 公众号菜单节点
     */
    private void doBusinessWechatMenu(Business business,JSONObject businessWechatMenu){

        Assert.jsonObjectHaveKey(businessWechatMenu,"wechatMenuId","businessWechatMenu 节点下没有包含 wechatMenuId 节点");

        if(businessWechatMenu.getString("wechatMenuId").startsWith("-")){
            throw new ListenerExecuteException(ResponseConstant.RESULT_PARAM_ERROR,"wechatMenuId 错误，不能自动生成（必须已经存在的wechatMenuId）"+businessWechatMenu);
        }
        //自动插入DEL
        autoSaveDelBusinessWechatMenu(business,businessWechatMenu);
    }
    @Override
    public IWechatMenuServiceDao getWechatMenuServiceDaoImpl() {
        return wechatMenuServiceDaoImpl;
    }

    public void setWechatMenuServiceDaoImpl(IWechatMenuServiceDao wechatMenuServiceDaoImpl) {
        this.wechatMenuServiceDaoImpl = wechatMenuServiceDaoImpl;
    }
}
