
local mine_mosquito_test_fn = function(dude, inst) return dude.components.combat and not (dude.components.health and dude.components.health:IsDead() and dude.components.combat:CanBeAttacked(inst)) end
local mine_mosquito_test_tags = {"mosquito", "bloodsucker"}

local function mine_mosquitoTest(inst)
    local mine_mosquito = inst.components.mine_mosquito
    local notags = {"monster", "character", "animal"}
    if mine_mosquito.alignment then
	table.insert(notags, mine_mosquito.alignment)
end
    if mine_mosquito and mine_mosquito.radius then
    local target = FindEntity(inst, mine_mosquito.radius, mine_mosquito_test_fn, nil, notags, mine_mosquito_test_tags)
    if target then
    mine_mosquito:Explode(target)
        end
    end
end

local mine_mosquito = Class(function(self, inst)
    self.inst = inst
    self.radius = nil
    self.onexplode = nil
    self.onreset = nil
    self.onsetsprung = nil
    self.target = nil
    self.issprung = false
	self.inactive = true
	self.alignment = "player"
    self.inst:ListenForEvent("onputininventory", function(inst) self:Deactivate()
    end)
end)

function mine_mosquito:SetRadius(radius)
    self.radius = radius
end

function mine_mosquito:SetOnExplodeFn(fn)
    self.onexplode = fn
end

function mine_mosquito:SetOnSprungFn(fn)
    self.onsetsprung = fn
end

function mine_mosquito:SetOnResetFn(fn)
    self.onreset = fn
end

function mine_mosquito:SetOnDeactivateFn(fn)
    self.ondeactivate = fn
end

function mine_mosquito:SetAlignment(alignment)
	self.alignment = alignment
end

function mine_mosquito:SetReusable(reusable)
    self.canreset = reusable
end

function mine_mosquito:Reset()
    self:StopTesting()
    self.target = nil
    self.issprung = false
    self.inactive = false
    if self.onreset then
    self.onreset(self.inst)
end
    self:StartTesting()
end

function mine_mosquito:StartTesting()
    self:StopTesting()
    self.testtask = self.inst:DoPeriodicTask(1, mine_mosquitoTest)
end

function mine_mosquito:StopTesting()
    if self.testtask then
    self.testtask:Cancel()
    self.testtask = nil
    end
end

function mine_mosquito:CollectSceneActions(doer, actions, right)
    if right and self.issprung then
    table.insert(actions, ACTIONS.RESETMINE)
    end
end

function mine_mosquito:Deactivate()
    self:StopTesting()
    self.issprung = false
	self.inactive = true    
    if self.ondeactivate then
    self.ondeactivate(self.inst)
    end
end

function mine_mosquito:GetTarget()
    return self.target
end

function mine_mosquito:Explode(target)
    self:StopTesting()
    self.target = target
    self.issprung = true
	self.inactive = false    
    ProfileStatsAdd("trap_sprung_" .. target.prefab)
    if self.onexplode then
    self.onexplode(self.inst, target)
    end
end

function mine_mosquito:OnSave()
    if self.issprung then
    return {sprung = true}
    elseif self.inactive then
	return {inactive = true}
    end
end

function mine_mosquito:OnLoad(data)
    if data.sprung then
	self.inactive = false
    self.issprung = true
    self:StopTesting()
    if self.onsetsprung then
    self.onsetsprung(self.inst)
end
    elseif data.inactive then
	self:Deactivate()
    else
	self:Reset()
    end
end

function mine_mosquito:OnRemoveEntity()
    self:StopTesting()
end

return mine_mosquito
