
local assets =
{
    Asset("ANIM", "anim/zapper.zip"),
    Asset("ATLAS", "images/inventoryimages/zapper.xml"),
    Asset( "ATLAS", "minimap/zapper.xml" ),
}

local function turnon(inst)
    inst.AnimState:PlayAnimation("idle_hit")
    inst.AnimState:PushAnimation("idle", true)
    inst.components.mine_mosquito:Reset()
    inst.Light:Enable(true)
    inst:AddComponent("edible")
    inst.components.edible.foodtype = "ZAPPER"
    inst.components.machine.ison = true
    inst.components.mine_mosquito.inactive = false
    if IsDLCEnabled(REIGN_OF_GIANTS)
    or 
    IsDLCEnabled(CAPY_DLC) 
    then
    GetPlayer().sg:GoToState("electrocute")
    GetPlayer().components.playercontroller:ShakeCamera(inst, "FULL", 0.7, 0.02, .5, 40)
    inst:DoTaskInTime(1, function() GetPlayer().AnimState:ClearBloomEffectHandle()
    GetPlayer().Light:Enable(false)
end)
    else
    GetPlayer().components.playercontroller:ShakeCamera(inst, "FULL", 0.7, 0.02, .5, 40)
    end
end

local function turnoff(inst)
    inst.AnimState:PushAnimation("idle_off", true)
    inst.Light:Enable(false)
    inst:RemoveComponent("edible")
    inst.components.mine_mosquito.inactive = true
    inst.components.machine.ison = false
end

local function onhit(inst, worker)
    inst.SoundEmitter:PlaySound("dontstarve/common/lightningrod")        
    inst.AnimState:PlayAnimation("idle_hit")
    inst.AnimState:PushAnimation("idle", true)
    local zap = SpawnPrefab("lightning_rod_fx")
    local x,y,z = inst.Transform:GetWorldPosition()
    y = y - 2
    zap.Transform:SetPosition(x,y,z)
    if inst.components.machine and inst.components.machine.ison then
    turnon(inst)
    else
    turnoff(inst)
    end
end

local function onhammered(inst, worker)
    SpawnPrefab("collapse_small").Transform:SetPosition(inst.Transform:GetWorldPosition())
    inst.AnimState:PlayAnimation("idle_finished")
    inst:DoTaskInTime(.8, function(inst)
    inst.components.lootdropper:DropLoot()
    inst:Remove()
    inst.persists = false
    end)
end

local function onfinished(inst)
    SpawnPrefab("collapse_small").Transform:SetPosition(inst.Transform:GetWorldPosition())
    inst.AnimState:PlayAnimation("idle_finished")
    inst:DoTaskInTime(.8, function(inst)
    inst:Remove()
    inst.persists = false
    end)
end

local function onbuilt(inst)
    if inst.components.machine
    then 
    turnon(inst)
    end
end

local function onexplode(inst, target)
    local zap = SpawnPrefab("lightning_rod_fx")
    local puff = SpawnPrefab("maxwell_smoke")
    local x,y,z = inst.Transform:GetWorldPosition()
    y = y - 2
    local px,py,pz = inst.Transform:GetWorldPosition()
    py = py + 1
    zap.Transform:SetPosition(x,y,z)
    puff.Transform:SetPosition(px,py,pz)
    puff.Transform:SetScale(.2, .2, .2)
    inst.SoundEmitter:PlaySound("dontstarve/common/lightningrod")
    inst.AnimState:PlayAnimation("idle_hit")
    if target then
    target.components.combat:GetAttacked(inst, 60)
    if METRICS_ENABLED then
    FightStat_TrapSprung(inst, target, 60)
    if FireBug then if target.components.burnable 
    then
    if math.random() < .3 then
    target.components.burnable:Ignite()
                end    
            end
        end
    end
end
    inst:DoTaskInTime(.5, function(inst)  
    inst.components.mine_mosquito:Reset()
end) 
    inst.components.finiteuses:Use(.5)
end

local function onreset(inst)
    local zap = SpawnPrefab("lightning_rod_fx")
    local puff = SpawnPrefab("maxwell_smoke")
    local x,y,z = inst.Transform:GetWorldPosition()
    y = y - 2
    local px,py,pz = inst.Transform:GetWorldPosition()
    py = py + 1
    zap.Transform:SetPosition(x,y,z)
    puff.Transform:SetPosition(px,py,pz)
    puff.Transform:SetScale(.3, .3, .3)
    inst.SoundEmitter:PlaySound("dontstarve/common/lightningrod")
    inst.AnimState:PlayAnimation("idle_hit")
    inst.AnimState:PushAnimation("idle", true)
    inst.components.machine.ison = true
end

local function ondropped(inst)
    inst.AnimState:PlayAnimation("idle")
    inst.AnimState:PushAnimation("idle", true)
    inst.components.mine_mosquito:Reset()
end

local function onsprung(inst)
    inst.AnimState:PlayAnimation("idle")
end

local function ondeploy(inst, pt, deployer)
    inst.AnimState:PlayAnimation("idle")
    inst.AnimState:PushAnimation("idle", true)
    inst.components.mine_mosquito:Reset()
    inst.Physics:Teleport(pt:Get())
end

local function onload(inst, data)
    if inst.components.machine and inst.components.machine.ison then
    turnon(inst)
    else
    turnoff(inst)
    end
end

local function fn(Sim)
    local inst = CreateEntity()
    local trans = inst.entity:AddTransform()
    local anim = inst.entity:AddAnimState()

    inst.entity:AddSoundEmitter()
    anim:SetBank("zapper")
    anim:SetBuild("zapper")
    anim:PlayAnimation("idle")
    inst.AnimState:PushAnimation("idle", true)

    local s = 1.5
    inst.Transform:SetScale(s, s, s)

    MakeInventoryPhysics(inst)
    
    local minimap = inst.entity:AddMiniMapEntity()
    minimap:SetIcon("zapper.tex")
   
    inst.entity:AddLight()
    inst.Light:Enable(false)
    inst.Light:SetRadius(1.5)
    inst.Light:SetFalloff(1)
    inst.Light:SetIntensity(.8)
    inst.Light:SetColour(0,0/255,255/255,255)

    inst:AddTag("trap")
    inst:AddTag("zapper")    
   
    inst:AddComponent("lootdropper")

    inst:AddComponent("workable")
    inst.components.workable:SetWorkAction(ACTIONS.HAMMER)
    inst.components.workable:SetWorkLeft(2)
    inst.components.workable:SetOnFinishCallback(onhammered)
    inst.components.workable:SetOnWorkCallback(onhit)     

    inst:AddComponent("inspectable")
       
    MakeObstaclePhysics(inst, .5)

    inst:AddComponent("machine")
    inst.components.machine.turnonfn = turnon
    inst.components.machine.turnofffn = turnoff
    inst.components.machine.cooldowntime = 0
    inst.components.machine.caninteract = true

    inst:AddComponent("finiteuses")
    inst.components.finiteuses:SetMaxUses(ZAPPER_KILLS)
    inst.components.finiteuses:SetUses(ZAPPER_KILLS)
    inst.components.finiteuses:SetOnFinished(onfinished)

    inst:AddComponent("mine_mosquito")
    inst.components.mine_mosquito:SetRadius(TUNING.TRAP_TEETH_RADIUS)
    inst.components.mine_mosquito:SetAlignment("player")
    inst.components.mine_mosquito:SetOnExplodeFn(onexplode)
    inst.components.mine_mosquito:SetOnResetFn(onreset)
    inst.components.mine_mosquito:SetOnSprungFn(onsprung)
    inst.components.mine_mosquito:StartTesting()

    inst:AddComponent("deployable")
    inst.components.deployable.ondeploy = ondeploy
    inst.components.deployable.min_spacing = .75

    inst:ListenForEvent( "onbuilt", onbuilt)
   
    inst.OnLoad = onload

    return inst
end

return Prefab( "common/inventory/zapper", fn, assets),
        MakePlacer("common/zapper_placer", "zapper", "zapper", "idle")
