local assets=
{
	Asset("ANIM", "anim/firefighter_placement.zip")    
}

local function fn(Sim)
	local inst = CreateEntity()
	local trans = inst.entity:AddTransform()
	local anim = inst.entity:AddAnimState()
    trans:SetScale(1.55,1.55,1.55)
	
    anim:SetBank("firefighter_placement")
    anim:SetBuild("firefighter_placement")
    anim:PlayAnimation("idle")
    
	anim:SetOrientation( ANIM_ORIENTATION.OnGround )
    anim:SetLayer( LAYER_BACKGROUND )
    anim:SetSortOrder( 3 )
	
	inst.persists = false
    inst:AddTag("fx")
	inst:AddTag("range_indicator")
    
	inst:DoTaskInTime(10, function() inst:Remove() end)
	
    return inst
end

return Prefab( "common/range_indicator", fn, assets) 