// Copyright (C) 2019-2020 Zilliz. All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except in compliance
// with the License. You may obtain a copy of the License at
//
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software distributed under the License
// is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
// or implied. See the License for the specific language governing permissions and limitations under the License

#pragma once

#include <memory>

#include "knowhere/index/vector_index/IndexType.h"
#include "knowhere/index/vector_index/VecIndex.h"

namespace milvus {
namespace knowhere {

class VecIndexFactory {
 private:
    VecIndexFactory() = default;
    VecIndexFactory(const VecIndexFactory&) = delete;
    VecIndexFactory
    operator=(const VecIndexFactory&) = delete;

 public:
    static VecIndexFactory&
    GetInstance() {
        static VecIndexFactory inst;
        return inst;
    }

    knowhere::VecIndexPtr
    CreateVecIndex(const IndexType& type, const IndexMode mode = IndexMode::MODE_CPU);
};

}  // namespace knowhere
}  // namespace milvus
