/*
 * Decompiled with CFR 0.152.
 */
package com.porpit.minecamera.block;

import com.google.common.base.Predicate;
import com.porpit.minecamera.creativetab.CreativeTabsLoader;
import com.porpit.minecamera.item.ItemLoader;
import com.porpit.minecamera.tileentity.TileEntityPictureFrame;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockPictureFrame
extends BlockContainer {
    public static final PropertyDirection FACING = PropertyDirection.func_177712_a((String)"facing", (Predicate)EnumFacing.Plane.HORIZONTAL);
    public static final PropertyEnum<EnumStateType> STATETYPE = PropertyEnum.func_177709_a((String)"statetype", EnumStateType.class);
    public AxisAlignedBB FACING_NORTH = new AxisAlignedBB(0.0, 0.1, 0.95, 1.0, 0.9, 1.0);

    public BlockPictureFrame() {
        super(Material.field_151578_c);
        this.func_149663_c("pictureframe");
        this.func_149711_c(0.5f);
        this.func_149672_a(SoundType.field_185848_a);
        this.func_149647_a(CreativeTabsLoader.tabMineCamera);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH).func_177226_a(STATETYPE, (Comparable)((Object)EnumStateType.STANDING)));
    }

    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        if (!worldIn.field_72995_K) {
            TileEntityPictureFrame te = (TileEntityPictureFrame)worldIn.func_175625_s(pos);
            if (!te.imagename.equals("")) {
                ItemStack picture = new ItemStack(ItemLoader.itemPicture);
                NBTTagCompound nbt = new NBTTagCompound();
                nbt.func_74778_a("pid", te.imagename);
                picture.func_77982_d(nbt);
                Block.func_180635_a((World)worldIn, (BlockPos)pos, (ItemStack)picture);
            }
        }
        super.func_180663_b(worldIn, pos, state);
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        if (((EnumStateType)((Object)state.func_177229_b(STATETYPE))).equals((Object)EnumStateType.HANDGING)) {
            switch (((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176745_a()) {
                case 2: {
                    return new AxisAlignedBB(0.0, 0.1, 0.95, 1.0, 0.9, 1.0);
                }
                case 3: {
                    return new AxisAlignedBB(0.0, 0.1, 0.0, 1.0, 0.9, 0.05);
                }
                case 4: {
                    return new AxisAlignedBB(0.95, 0.1, 0.0, 1.0, 0.9, 1.0);
                }
                case 5: {
                    return new AxisAlignedBB(0.0, 0.1, 0.0, 0.05, 0.9, 1.0);
                }
            }
            return new AxisAlignedBB(0.0, 0.1, 0.95, 1.0, 0.9, 1.0);
        }
        switch (((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176745_a()) {
            case 2: {
                return new AxisAlignedBB(0.0, 0.0, 0.35, 1.0, 0.75, 0.8);
            }
            case 3: {
                return new AxisAlignedBB(0.0, 0.0, 0.2, 1.0, 0.75, 0.65);
            }
            case 4: {
                return new AxisAlignedBB(0.35, 0.0, 0.0, 0.8, 0.75, 1.0);
            }
            case 5: {
                return new AxisAlignedBB(0.2, 0.0, 0.0, 0.65, 0.75, 1.0);
            }
        }
        return new AxisAlignedBB(0.0, 0.0, 0.35, 1.0, 0.75, 0.8);
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING, STATETYPE});
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        return new TileEntityPictureFrame();
    }

    public boolean func_176196_c(World worldIn, BlockPos pos) {
        return true;
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack heldItem = playerIn.func_184586_b(hand);
        if (!(worldIn.func_175625_s(pos) instanceof TileEntityPictureFrame)) {
            return true;
        }
        TileEntityPictureFrame te = (TileEntityPictureFrame)worldIn.func_175625_s(pos);
        if (heldItem != null && heldItem.func_77973_b().equals(ItemLoader.itemPicture) && heldItem.func_77942_o() && heldItem.func_77978_p().func_74764_b("pid")) {
            String imagename = heldItem.func_77978_p().func_74779_i("pid");
            if (!worldIn.field_72995_K && !te.imagename.equals("")) {
                ItemStack picture = new ItemStack(ItemLoader.itemPicture);
                NBTTagCompound nbt = new NBTTagCompound();
                nbt.func_74778_a("pid", te.imagename);
                picture.func_77982_d(nbt);
                Block.func_180635_a((World)worldIn, (BlockPos)pos, (ItemStack)picture);
            }
            te.imagename = imagename;
            te.updateBlock();
            heldItem.func_190918_g(1);
        }
        if (!worldIn.field_72995_K && heldItem == null && !te.imagename.equals("")) {
            ItemStack picture = new ItemStack(ItemLoader.itemPicture);
            NBTTagCompound nbt = new NBTTagCompound();
            nbt.func_74778_a("pid", te.imagename);
            picture.func_77982_d(nbt);
            Block.func_180635_a((World)worldIn, (BlockPos)pos, (ItemStack)picture);
            te.imagename = "";
            te.updateBlock();
        }
        return true;
    }

    public IBlockState func_176203_a(int meta) {
        EnumFacing facing = EnumFacing.func_176731_b((int)(meta & 3));
        EnumStateType statetype = EnumStateType.values()[meta >> 2];
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)facing).func_177226_a(STATETYPE, (Comparable)((Object)statetype));
    }

    public int func_176201_c(IBlockState state) {
        int facing = ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176736_b();
        int statetype = ((EnumStateType)((Object)state.func_177229_b(STATETYPE))).ordinal() << 2;
        return facing | statetype;
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        IBlockState origin = super.getStateForPlacement(world, pos, facing, hitX, hitY, hitZ, meta, placer, hand);
        EnumStateType enumState = (double)hitY == 1.0 ? EnumStateType.STANDING : EnumStateType.HANDGING;
        return origin.func_177226_a((IProperty)FACING, (Comparable)placer.func_174811_aO().func_176734_d()).func_177226_a(STATETYPE, (Comparable)((Object)enumState));
    }

    @SideOnly(value=Side.CLIENT)
    public void func_190948_a(ItemStack stack, @Nullable World player, List<String> tooltip, ITooltipFlag advanced) {
        tooltip.add(TextFormatting.BLUE + I18n.func_135052_a((String)"lore.pictureframe.info", (Object[])new Object[0]));
    }

    public static enum EnumStateType implements IStringSerializable
    {
        HANDGING("hanging"),
        STANDING("standing");

        private String name;

        private EnumStateType(String material) {
            this.name = material;
        }

        public String func_176610_l() {
            return this.name;
        }

        public String toString() {
            return this.name;
        }
    }
}

