/*
 * Decompiled with CFR 0.152.
 */
package com.porpit.minecamera.client.gui;

import com.porpit.minecamera.inventory.ContainerPhotoProcessor;
import com.porpit.minecamera.network.MessagePhotoProcessorStart;
import com.porpit.minecamera.network.NetworkLoader;
import com.porpit.minecamera.tileentity.TileEntityPhotoProcessor;
import com.porpit.minecamera.util.EnumFailLoadImage;
import com.porpit.minecamera.util.LoadImageFileThread;
import com.porpit.minecamera.util.PictureFactory;
import java.io.IOException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.inventory.Container;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class GuiPhotoProcessor
extends GuiContainer {
    private static final int BUTTON_START = 0;
    private static final String TEXTURE_PATH = "minecamera:textures/gui/container/gui_photoprocessor.png";
    private static final ResourceLocation TEXTURE = new ResourceLocation("minecamera:textures/gui/container/gui_photoprocessor.png");
    private float imageRelativeX;
    private float imageRelativeY;
    private float imageW;
    private float imageH;
    private String info = I18n.func_135052_a((String)"container.photoprocessor.text.default", (Object[])new Object[0]);
    private boolean infolock = false;
    private ContainerPhotoProcessor container;

    public GuiPhotoProcessor(ContainerPhotoProcessor inventorySlotsIn) {
        super((Container)inventorySlotsIn);
        this.container = inventorySlotsIn;
        this.field_146999_f = 176;
        this.field_147000_g = 206;
        this.imageW = 129.0f;
        this.imageH = 73.0f;
        this.imageRelativeX = 33.0f;
        this.imageRelativeY = 16.0f;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        FontRenderer fr = this.field_146289_q;
        int offsetX = (this.field_146294_l - this.field_146999_f) / 2;
        int offsetY = (this.field_146295_m - this.field_147000_g) / 2;
        this.field_146292_n.add(new GuiButton(0, offsetX + 11, offsetY + 101, 25, 16, ""){

            public void func_191745_a(Minecraft mc, int mouseX, int mouseY, float partialTicks) {
                if (this.field_146125_m) {
                    GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
                    mc.func_110434_K().func_110577_a(TEXTURE);
                    int x = mouseX - this.field_146128_h;
                    int y = mouseY - this.field_146129_i;
                    if (x >= 0 && y >= 0 && x < this.field_146120_f && y < this.field_146121_g) {
                        this.func_73729_b(this.field_146128_h, this.field_146129_i, 50, 206, this.field_146120_f, this.field_146121_g);
                    } else {
                        this.func_73729_b(this.field_146128_h, this.field_146129_i, 24, 206, this.field_146120_f, this.field_146121_g);
                    }
                }
            }

            public void func_146118_a(int mouseX, int mouseY) {
                GuiPhotoProcessor.this.infolock = true;
                int lightlevel = GuiPhotoProcessor.this.container.getTileEntity().func_145831_w().func_175699_k(GuiPhotoProcessor.this.container.getTileEntity().func_174877_v());
                if (!GuiPhotoProcessor.this.container.func_75139_a(0).func_75216_d()) {
                    GuiPhotoProcessor.this.info = TextFormatting.RED + I18n.func_135052_a((String)"container.photoprocessor.text.nonectl", (Object[])new Object[0]);
                    return;
                }
                if (!GuiPhotoProcessor.this.container.func_75139_a(1).func_75216_d()) {
                    GuiPhotoProcessor.this.info = TextFormatting.RED + I18n.func_135052_a((String)"container.photoprocessor.text.noneda", (Object[])new Object[0]);
                    return;
                }
                if (!GuiPhotoProcessor.this.container.func_75139_a(2).func_75216_d()) {
                    GuiPhotoProcessor.this.info = TextFormatting.RED + I18n.func_135052_a((String)"container.photoprocessor.text.nonefilm", (Object[])new Object[0]);
                    return;
                }
                if (!GuiPhotoProcessor.this.container.func_75139_a(3).func_75216_d()) {
                    GuiPhotoProcessor.this.info = TextFormatting.RED + I18n.func_135052_a((String)"container.photoprocessor.text.nonepaper", (Object[])new Object[0]);
                    return;
                }
                if (GuiPhotoProcessor.this.container.func_75139_a(4).func_75216_d()) {
                    GuiPhotoProcessor.this.info = TextFormatting.RED + I18n.func_135052_a((String)"container.photoprocessor.text.hasphotoout", (Object[])new Object[0]);
                    return;
                }
                int n = GuiPhotoProcessor.this.container.getBurnTime();
                GuiPhotoProcessor.this.container;
                if (n != ContainerPhotoProcessor.totalBurnTime) {
                    return;
                }
                if (lightlevel > 5) {
                    GuiPhotoProcessor.this.info = TextFormatting.RED + I18n.func_135052_a((String)"container.photoprocessor.text.lightleveltoohigh", (Object[])new Object[0]);
                    return;
                }
                if (GuiPhotoProcessor.this.container.func_75139_a(2).func_75211_c().func_77942_o() && GuiPhotoProcessor.this.container.func_75139_a(2).func_75211_c().func_77978_p().func_74764_b("pid")) {
                    String imagename = GuiPhotoProcessor.this.container.func_75139_a(2).func_75211_c().func_77978_p().func_74779_i("pid");
                    EnumFailLoadImage flag = PictureFactory.isFailedToLoad(imagename);
                    if (flag != null) {
                        GuiPhotoProcessor.this.info = TextFormatting.RED + I18n.func_135052_a((String)("container.photoprocessor.text.failed." + flag.toString()), (Object[])new Object[0]);
                        return;
                    }
                    MessagePhotoProcessorStart message = new MessagePhotoProcessorStart();
                    NetworkLoader.instance.sendToServer((IMessage)message);
                }
            }
        });
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        super.func_73864_a(mouseX, mouseY, mouseButton);
        if (this.getSlotUnderMouse() != null && (this.getSlotUnderMouse().getSlotIndex() == 2 || this.getSlotUnderMouse().getSlotIndex() == 4)) {
            this.infolock = false;
        }
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(TEXTURE);
        int offsetX = (this.field_146294_l - this.field_146999_f) / 2;
        int offsetY = (this.field_146295_m - this.field_147000_g) / 2;
        this.func_73729_b(offsetX, offsetY, 0, 0, this.field_146999_f, this.field_147000_g);
        PictureFactory.drawDonateImage(this, mouseX, mouseY);
        this.field_146289_q.func_78276_b(this.info, offsetX + 31, offsetY + 4, 0xD3D3D3);
        this.field_146289_q.func_78276_b(I18n.func_135052_a((String)"container.photoprocessor.text.lightlevel", (Object[])new Object[0]), offsetX + 7, offsetY + 7, 6591981);
        int lightlevel = this.container.getTileEntity().func_145831_w().func_175699_k(this.container.getTileEntity().func_174877_v());
        this.field_146289_q.func_78276_b(I18n.func_135052_a((String)(lightlevel + ""), (Object[])new Object[0]), offsetX + 12, offsetY + 15, 6591981);
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        this.field_146297_k.func_110434_K().func_110577_a(TEXTURE);
        String button = I18n.func_135052_a((String)"container.photoprocessor.button.start", (Object[])new Object[0]);
        int offsetX = (this.field_146294_l - this.field_146999_f) / 2;
        int offsetY = (this.field_146295_m - this.field_147000_g) / 2;
        this.field_146289_q.func_78276_b(button, 15, 105, 0xD3D3D3);
        int burnTime = this.container.getBurnTime();
        if (burnTime >= TileEntityPhotoProcessor.totalburnTime) {
            boolean textureWidth = false;
        } else {
            this.info = TextFormatting.GREEN + I18n.func_135052_a((String)"container.photoprocessor.text.outing", (Object[])new Object[0]);
            int textureWidth = (int)(25.0 * (double)burnTime / (double)TileEntityPhotoProcessor.totalburnTime);
            Minecraft.func_71410_x().func_110434_K().func_110577_a(TEXTURE);
            this.func_73729_b(114, 101, 0, 206, textureWidth, 15);
            if (textureWidth == 24) {
                this.info = TextFormatting.GREEN + I18n.func_135052_a((String)"container.photoprocessor.text.success", (Object[])new Object[0]);
            }
        }
        float speedFloat = 100.0f / (float)Minecraft.func_175610_ah();
        if (mouseX > offsetX + 33 && mouseX < offsetX + 33 + 129 && mouseY > offsetY + 16 && mouseY < offsetY + 16 + 73) {
            if ((double)this.imageRelativeX > (double)PictureFactory.getMcScaledWidth() * 0.15 - (double)offsetX) {
                this.imageRelativeX -= 8.0f * speedFloat;
                if ((double)this.imageRelativeX <= (double)PictureFactory.getMcScaledWidth() * 0.15 - (double)offsetX) {
                    this.imageRelativeX = (float)((double)PictureFactory.getMcScaledWidth() * 0.15 - (double)offsetX);
                }
            }
            if ((double)this.imageRelativeY > (double)PictureFactory.getMcScaledHeight() * 0.1 - (double)offsetY) {
                this.imageRelativeY -= 2.0f * speedFloat;
                if ((double)this.imageRelativeY <= (double)PictureFactory.getMcScaledHeight() * 0.1 - (double)offsetY) {
                    this.imageRelativeY = (float)((double)PictureFactory.getMcScaledHeight() * 0.1 - (double)offsetY);
                }
            }
            if ((double)this.imageW < (double)PictureFactory.getMcScaledWidth() * 0.7) {
                this.imageW += 12.0f * speedFloat;
                if ((double)this.imageW >= (double)PictureFactory.getMcScaledWidth() * 0.7) {
                    this.imageW = (float)((double)PictureFactory.getMcScaledWidth() * 0.7);
                }
            }
            this.imageH = this.imageW * 0.6f;
        } else {
            if (this.imageRelativeX < 33.0f) {
                this.imageRelativeX += 8.0f * speedFloat;
                if (this.imageRelativeX >= 33.0f) {
                    this.imageRelativeX = 33.0f;
                }
            }
            if (this.imageRelativeY < 16.0f) {
                this.imageRelativeY += 2.0f * speedFloat;
                if (this.imageRelativeY >= 16.0f) {
                    this.imageRelativeY = 16.0f;
                }
            }
            if (this.imageW > 129.0f) {
                this.imageW -= 12.0f * speedFloat;
                if (this.imageW <= 129.0f) {
                    this.imageW = 129.0f;
                }
            }
            this.imageH = this.imageW * 73.0f / 129.0f;
        }
        int imageX = (int)this.imageRelativeX;
        int imageY = (int)this.imageRelativeY;
        if (this.container.func_75139_a(2).func_75211_c() != null) {
            if (!this.container.func_75139_a(2).func_75211_c().func_77942_o() || !this.container.func_75139_a(2).func_75211_c().func_77978_p().func_74764_b("pid")) {
                return;
            }
            String imagename = this.container.func_75139_a(2).func_75211_c().func_77978_p().func_74779_i("pid");
            if (PictureFactory.loadedPicture.containsKey(imagename)) {
                GlStateManager.func_179144_i((int)PictureFactory.loadedPicture.get(imagename));
                if (imagename.split("%_%").length == 2) {
                    GlStateManager.func_179097_i();
                    GuiPhotoProcessor.func_146110_a((int)imageX, (int)imageY, (float)0.0f, (float)0.0f, (int)((int)this.imageW), (int)((int)this.imageH), (float)this.imageW, (float)this.imageH);
                    GlStateManager.func_179126_j();
                    if (!this.infolock) {
                        this.info = TextFormatting.GREEN + I18n.func_135052_a((String)"container.photoprocessor.text.readsuccess", (Object[])new Object[0]) + imagename.split("%_%")[0];
                    }
                }
            } else if (!PictureFactory.fildToLoadPicture.containsKey(imagename)) {
                Minecraft.func_71410_x().func_110434_K().func_110577_a(PictureFactory.LODINGIMAGE);
                GlStateManager.func_179097_i();
                GuiPhotoProcessor.func_146110_a((int)imageX, (int)imageY, (float)0.0f, (float)0.0f, (int)((int)this.imageW), (int)((int)this.imageH), (float)this.imageW, (float)this.imageH);
                GlStateManager.func_179126_j();
                if (!this.infolock) {
                    this.info = TextFormatting.GREEN + I18n.func_135052_a((String)"container.photoprocessor.text.lodingfilm", (Object[])new Object[0]) + imagename.split("%_%")[0];
                }
                if (!PictureFactory.lodingPicture.contains(imagename)) {
                    PictureFactory.lodingPicture.add(imagename);
                    LoadImageFileThread thread = new LoadImageFileThread(imagename);
                    thread.start();
                }
            } else {
                Minecraft.func_71410_x().func_110434_K().func_110577_a(PictureFactory.FailToLoadImage);
                GlStateManager.func_179097_i();
                GuiPhotoProcessor.func_146110_a((int)imageX, (int)imageY, (float)0.0f, (float)0.0f, (int)((int)this.imageW), (int)((int)this.imageH), (float)this.imageW, (float)this.imageH);
                GlStateManager.func_179126_j();
                if (!this.infolock) {
                    this.info = TextFormatting.RED + I18n.func_135052_a((String)("text.info." + PictureFactory.fildToLoadPicture.get(imagename).toString()), (Object[])new Object[0]);
                }
            }
        } else {
            this.info = I18n.func_135052_a((String)"container.photoprocessor.text.default", (Object[])new Object[0]);
        }
    }
}

