/*
 * Decompiled with CFR 0.152.
 */
package com.porpit.minecamera.network;

import com.porpit.minecamera.MineCamera;
import com.porpit.minecamera.util.PictureFactory;
import io.netty.buffer.ByteBuf;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.imageio.ImageIO;
import net.minecraft.client.Minecraft;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;

public class MessageImage
implements IMessage {
    private static Map<String, byte[]> imagecatchdata = new HashMap<String, byte[]>();
    boolean flag = true;
    public BufferedImage image;
    public byte[] imageData;
    public int packMax = 1;
    public int packIndex = 1;
    public String imageName;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fromBytes(ByteBuf buf) {
        int namelength = buf.readInt();
        byte[] namebyte = new byte[namelength];
        buf.readBytes(namebyte);
        this.imageName = new String(namebyte);
        this.packMax = buf.readInt();
        this.packIndex = buf.readInt();
        if (this.packMax == 1) {
            int imagelength = buf.readInt();
            byte[] imagebyte = new byte[imagelength];
            buf.readBytes(imagebyte);
            ByteArrayInputStream in = new ByteArrayInputStream(imagebyte);
            try {
                this.image = ImageIO.read(in);
            }
            catch (IOException e) {
                this.flag = false;
                e.printStackTrace();
            }
        } else if (this.packMax > this.packIndex) {
            int imagedatalength = buf.readInt();
            this.imageData = new byte[imagedatalength];
            buf.readBytes(this.imageData);
            if (!imagecatchdata.containsKey(this.imageName)) {
                imagecatchdata.put(this.imageName, this.imageData);
            } else {
                byte[] temp = imagecatchdata.get(this.imageName);
                imagecatchdata.put(this.imageName, PictureFactory.byteMerger(temp, this.imageData));
            }
        } else {
            int imagedatalength = buf.readInt();
            this.imageData = new byte[imagedatalength];
            buf.readBytes(this.imageData);
            byte[] temp = imagecatchdata.get(this.imageName);
            byte[] fulldata = PictureFactory.byteMerger(temp, this.imageData);
            ByteArrayInputStream in = new ByteArrayInputStream(fulldata);
            try {
                this.image = ImageIO.read(in);
            }
            catch (IOException e) {
                this.flag = false;
                e.printStackTrace();
            }
            finally {
                imagecatchdata.remove(this.imageName);
            }
        }
    }

    public void toBytes(ByteBuf buf) {
        if (this.packMax == 1) {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            try {
                ImageIO.write((RenderedImage)this.image, "jpg", out);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            buf.writeInt(this.imageName.getBytes().length);
            buf.writeBytes(this.imageName.getBytes());
            buf.writeInt(this.packMax);
            buf.writeInt(this.packIndex);
            buf.writeInt(out.toByteArray().length);
            buf.writeBytes(out.toByteArray());
        } else {
            buf.writeInt(this.imageName.getBytes().length);
            buf.writeBytes(this.imageName.getBytes());
            buf.writeInt(this.packMax);
            buf.writeInt(this.packIndex);
            buf.writeInt(this.imageData.length);
            buf.writeBytes(this.imageData);
        }
    }

    public static class Handler
    implements IMessageHandler<MessageImage, IMessage> {
        public IMessage onMessage(MessageImage message, MessageContext ctx) {
            if (ctx.side == Side.CLIENT) {
                final BufferedImage image = message.image;
                final String name = message.imageName;
                try {
                    File file = new File(MineCamera.ClientCatchFile + message.imageName + ".jpeg");
                    if (!file.getParentFile().exists()) {
                        file.getParentFile().mkdirs();
                    }
                    if (!file.exists()) {
                        file.createNewFile();
                    }
                    ImageIO.write((RenderedImage)image, "jpg", file);
                    Minecraft.func_71410_x().func_152344_a(new Runnable(){

                        @Override
                        public void run() {
                            int textureId = PictureFactory.loadTexture(name, image);
                            PictureFactory.loadedPicture.put(name, textureId);
                            PictureFactory.lodingPicture.remove(name);
                        }
                    });
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            } else if (message.packMax == message.packIndex) {
                BufferedImage image = message.image;
                File fileclient = new File(MineCamera.ClientCatchFile);
                if (fileclient.exists()) {
                    return null;
                }
                File file = new File(MineCamera.ServerCatchFile + message.imageName + ".jpeg");
                try {
                    if (!file.getParentFile().exists()) {
                        file.getParentFile().mkdirs();
                    }
                    if (!file.exists()) {
                        file.createNewFile();
                    }
                    ImageIO.write((RenderedImage)image, "jpg", file);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            return null;
        }
    }
}

