/*
 * Decompiled with CFR 0.152.
 */
package com.porpit.minecamera.network;

import com.porpit.minecamera.MineCamera;
import com.porpit.minecamera.network.MessageFailLoadImage;
import com.porpit.minecamera.network.MessageImage;
import com.porpit.minecamera.util.EnumFailLoadImage;
import io.netty.buffer.ByteBuf;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;

public class MessageImageRequest
implements IMessage {
    public String filename;

    public void fromBytes(ByteBuf buf) {
        int filenamelength = buf.readInt();
        byte[] filenamebyte = new byte[filenamelength];
        buf.readBytes(filenamebyte);
        this.filename = new String(filenamebyte);
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.filename.getBytes().length);
        buf.writeBytes(this.filename.getBytes());
    }

    public static class Handler
    implements IMessageHandler<MessageImageRequest, IMessage> {
        public IMessage onMessage(MessageImageRequest message, MessageContext ctx) {
            if (ctx.side == Side.SERVER) {
                File file = new File(MineCamera.ServerCatchFile + message.filename + ".jpeg");
                if (file.exists()) {
                    try {
                        BufferedImage image = ImageIO.read(file);
                        MessageImage messageimage = new MessageImage();
                        messageimage.image = image;
                        messageimage.imageName = message.filename;
                        return messageimage;
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        MessageFailLoadImage messagefail = new MessageFailLoadImage();
                        messagefail.imagename = message.filename;
                        messagefail.type = EnumFailLoadImage.ErrorToLoadFile;
                        return messagefail;
                    }
                }
                System.out.println("\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\u037c\u01ac\ufffd\ufffd\ufffd\ufffd\ufffd\u06a3\ufffd\ufffd\ufffd\ufffd\ufffd\u02a7\ufffd\ufffd!");
                MessageFailLoadImage messagefail = new MessageFailLoadImage();
                messagefail.imagename = message.filename;
                messagefail.type = EnumFailLoadImage.FileNoFound;
                return messagefail;
            }
            return null;
        }
    }
}

