/*
 * Decompiled with CFR 0.152.
 */
package com.porpit.minecamera.transform;

import com.porpit.minecamera.transform.Transformer;
import java.util.ArrayList;
import net.minecraft.launchwrapper.IClassTransformer;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;

public class CamTransformer
implements IClassTransformer {
    private final ArrayList<Transformer> transformers = new ArrayList();

    public CamTransformer() {
        this.initTransformers();
    }

    protected void initTransformers() {
        this.addTransformer(new Transformer("net.minecraft.client.entity.EntityPlayerSP"){

            @Override
            public void transform(ClassNode node) {
                MethodNode m = this.findMethod(node, "isCurrentViewEntity", "()Z");
                m.instructions.clear();
                m.instructions.add((AbstractInsnNode)new MethodInsnNode(184, "com/porpit/minecamera/transform/CamEventHandler", "shouldPlayerTakeInput", "()Z", false));
                m.instructions.add((AbstractInsnNode)new InsnNode(172));
            }
        });
        this.addTransformer(new Transformer("net.minecraft.client.renderer.EntityRenderer"){

            @Override
            public void transform(ClassNode node) {
                MethodNode m = this.findMethod(node, "getMouseOver", "(F)V");
                m.instructions.insert((AbstractInsnNode)new MethodInsnNode(184, "com/porpit/minecamera/transform/CamEventHandler", "setupMouseHandlerBefore", "()V", false));
                AbstractInsnNode currentNode2 = null;
                for (AbstractInsnNode currentNode2 : m.instructions) {
                    if (!(currentNode2 instanceof InsnNode) || ((InsnNode)currentNode2).getOpcode() != 177) continue;
                    m.instructions.insertBefore(currentNode2, (AbstractInsnNode)new MethodInsnNode(184, "com/porpit/minecamera/transform/CamEventHandler", "setupMouseHandlerAfter", "()V", false));
                }
            }
        });
    }

    protected void addTransformer(Transformer transformer) {
        this.transformers.add(transformer);
    }

    public byte[] transform(String name, String transformedName, byte[] basicClass) {
        if (name.contains("com.porpit")) {
            return basicClass;
        }
        return this.transform(transformedName, basicClass);
    }

    public byte[] transform(String name, byte[] basicClass) {
        int i = 0;
        while (i < this.transformers.size()) {
            if (this.transformers.get(i).is(name)) {
                ClassNode classNode = new ClassNode();
                ClassReader classReader = new ClassReader(basicClass);
                classReader.accept((ClassVisitor)classNode, 0);
                this.transformers.get(i).transform(classNode);
                ClassWriter writer = new ClassWriter(3);
                classNode.accept((ClassVisitor)writer);
                basicClass = writer.toByteArray();
                System.out.println("[minecamera] Patched " + this.transformers.get((int)i).className + " ...");
                this.transformers.get(i).done();
                ++i;
                continue;
            }
            ++i;
        }
        return basicClass;
    }
}

