/*
 * Decompiled with CFR 0.152.
 */
package com.porpit.minecamera.util;

import com.porpit.minecamera.MineCamera;
import com.porpit.minecamera.network.MessageImageRequest;
import com.porpit.minecamera.network.NetworkLoader;
import com.porpit.minecamera.util.EnumFailLoadImage;
import com.porpit.minecamera.util.PictureFactory;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import net.minecraft.client.Minecraft;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class LoadImageFileThread
extends Thread {
    private String imagename;

    public LoadImageFileThread(String imagename) {
        this.imagename = imagename;
    }

    @Override
    public void run() {
        BufferedImage image = null;
        File file = new File(MineCamera.ClientCatchFile + this.imagename + ".jpeg");
        if (file.exists()) {
            try {
                image = ImageIO.read(file);
            }
            catch (IOException e) {
                PictureFactory.fildToLoadPicture.put("imagename", EnumFailLoadImage.ErrorToLoadLocalFile);
                file.delete();
                e.printStackTrace();
            }
            if (image != null) {
                final BufferedImage imageIn = image;
                Minecraft.func_71410_x().func_152344_a(new Runnable(){

                    @Override
                    public void run() {
                        int textureId = PictureFactory.loadTexture(LoadImageFileThread.this.imagename, imageIn);
                        PictureFactory.loadedPicture.put(LoadImageFileThread.this.imagename, textureId);
                        PictureFactory.lodingPicture.remove(LoadImageFileThread.this.imagename);
                    }
                });
            }
        } else {
            MessageImageRequest message = new MessageImageRequest();
            message.filename = this.imagename;
            NetworkLoader.instance.sendToServer((IMessage)message);
        }
    }
}

