/*
 * Decompiled with CFR 0.152.
 */
package com.porpit.minecamera.util;

import com.porpit.minecamera.network.MessageImage;
import com.porpit.minecamera.network.NetworkLoader;
import com.porpit.minecamera.util.EnumFailLoadImage;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.imageio.ImageIO;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.shader.Framebuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.ScreenShotHelper;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;

public final class PictureFactory {
    public static final ResourceLocation FailToLoadImage = new ResourceLocation("minecamera:textures/gui/image/failtoload.png");
    public static final ResourceLocation LODINGIMAGE = new ResourceLocation("minecamera:textures/gui/image/loding.png");
    public static final ResourceLocation DONATEIMAGE = new ResourceLocation("minecamera:textures/gui/image/donate.png");
    public static Map<String, Integer> loadedPicture = new HashMap<String, Integer>();
    public static Map<String, EnumFailLoadImage> fildToLoadPicture = new HashMap<String, EnumFailLoadImage>();
    public static Set<String> lodingPicture = new HashSet<String>();
    private static int mcScaledWidth = 0;
    private static int mcScaledHeight = 0;
    private static int lastFrameIndex = 0;

    private PictureFactory() {
    }

    public static BufferedImage FormattingPicture(BufferedImage imageIn) {
        BufferedImage image = new BufferedImage(854, 480, 4);
        Graphics2D g = (Graphics2D)image.getGraphics();
        g.drawImage(imageIn, 0, 0, 854, 480, null);
        return image;
    }

    @SideOnly(value=Side.CLIENT)
    public static int getMcScaledWidth() {
        PictureFactory.updateMinecraftScaledSize(Minecraft.func_71410_x());
        return mcScaledWidth;
    }

    @SideOnly(value=Side.CLIENT)
    public static int getMcScaledHeight() {
        PictureFactory.updateMinecraftScaledSize(Minecraft.func_71410_x());
        return mcScaledHeight;
    }

    @SideOnly(value=Side.CLIENT)
    public static void updateMinecraftScaledSize(Minecraft mc) {
        if (mc.field_181542_y.func_181749_a() == lastFrameIndex) {
            return;
        }
        lastFrameIndex = mc.field_181542_y.func_181749_a();
        mcScaledWidth = mc.field_71443_c;
        mcScaledHeight = mc.field_71440_d;
        int scaleFactor = 1;
        boolean flag = mc.func_152349_b();
        int i = mc.field_71474_y.field_74335_Z;
        if (i == 0) {
            i = 1000;
        }
        while (scaleFactor < i && mcScaledWidth / (scaleFactor + 1) >= 320 && mcScaledHeight / (scaleFactor + 1) >= 240) {
            ++scaleFactor;
        }
        if (flag && scaleFactor % 2 != 0 && scaleFactor != 1) {
            --scaleFactor;
        }
        mcScaledWidth = PictureFactory.ceiling_double_int((double)mcScaledWidth / (double)scaleFactor);
        mcScaledHeight = PictureFactory.ceiling_double_int((double)mcScaledHeight / (double)scaleFactor);
    }

    @SideOnly(value=Side.CLIENT)
    public static BufferedImage getScreenshot() {
        BufferedImage image = ScreenShotHelper.func_186719_a((int)Minecraft.func_71410_x().field_71443_c, (int)Minecraft.func_71410_x().field_71440_d, (Framebuffer)Minecraft.func_71410_x().func_147110_a());
        return image;
    }

    @SideOnly(value=Side.CLIENT)
    public static BufferedImage getFormattingScreenshot() {
        BufferedImage image = ScreenShotHelper.func_186719_a((int)Minecraft.func_71410_x().field_71443_c, (int)Minecraft.func_71410_x().field_71440_d, (Framebuffer)Minecraft.func_71410_x().func_147110_a());
        return PictureFactory.FormattingPicture(image);
    }

    public static EnumFailLoadImage isFailedToLoad(String imagename) {
        if (fildToLoadPicture.containsKey(imagename)) {
            return fildToLoadPicture.get(imagename);
        }
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public static int loadTexture(String imagename, BufferedImage image) {
        int BYTES_PER_PIXEL = 4;
        int[] pixels = new int[image.getWidth() * image.getHeight()];
        image.getRGB(0, 0, image.getWidth(), image.getHeight(), pixels, 0, image.getWidth());
        ByteBuffer buffer = BufferUtils.createByteBuffer((int)(image.getWidth() * image.getHeight() * BYTES_PER_PIXEL));
        for (int y = 0; y < image.getHeight(); ++y) {
            for (int x = 0; x < image.getWidth(); ++x) {
                int pixel = pixels[y * image.getWidth() + x];
                buffer.put((byte)(pixel >> 16 & 0xFF));
                buffer.put((byte)(pixel >> 8 & 0xFF));
                buffer.put((byte)(pixel & 0xFF));
                buffer.put((byte)(pixel >> 24 & 0xFF));
            }
        }
        buffer.flip();
        int textureID = GL11.glGenTextures();
        GL11.glBindTexture((int)3553, (int)textureID);
        GL11.glTexParameteri((int)3553, (int)10242, (int)33071);
        GL11.glTexParameteri((int)3553, (int)10243, (int)33071);
        GL11.glTexParameteri((int)3553, (int)10241, (int)9729);
        GL11.glTexParameteri((int)3553, (int)10240, (int)9729);
        GL11.glTexImage2D((int)3553, (int)0, (int)32856, (int)image.getWidth(), (int)image.getHeight(), (int)0, (int)6408, (int)5121, (ByteBuffer)buffer);
        loadedPicture.put(imagename, textureID);
        return textureID;
    }

    @SideOnly(value=Side.CLIENT)
    public static void SendImageToServer(BufferedImage image, String filename) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            ImageIO.write((RenderedImage)image, "jpg", out);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        System.out.println("\ufffd\ufffd\u01ac\ufffd\ufffd\ufffd\u0223\ufffd" + out.toByteArray().length);
        if (out.toByteArray().length <= 30000) {
            MessageImage message = new MessageImage();
            message.image = image;
            message.imageName = filename;
            NetworkLoader.instance.sendToServer((IMessage)message);
        } else {
            int packMax = out.toByteArray().length / 30000 + 1;
            System.out.println("\ufffd\ufffd\ufffd\u03aa\ufffd\ufffd" + packMax + "\ufffd\ufffd\ufffd\ufffd");
            byte[][] splited = PictureFactory.split_bytes(out.toByteArray(), 30000);
            for (int i = 1; i <= packMax; ++i) {
                MessageImage message = new MessageImage();
                message.packMax = packMax;
                message.packIndex = i;
                message.imageName = filename;
                message.imageData = splited[i - 1];
                NetworkLoader.instance.sendToServer((IMessage)message);
            }
        }
    }

    public static byte[] byteMerger(byte[] bt1, byte[] bt2) {
        byte bt;
        int n;
        byte[] bt3 = new byte[bt1.length + bt2.length];
        int i = 0;
        byte[] byArray = bt1;
        int n2 = byArray.length;
        for (n = 0; n < n2; ++n) {
            bt3[i] = bt = byArray[n];
            ++i;
        }
        byArray = bt2;
        n2 = byArray.length;
        for (n = 0; n < n2; ++n) {
            bt3[i] = bt = byArray[n];
            ++i;
        }
        return bt3;
    }

    public static byte[][] split_bytes(byte[] bytes, int copies) {
        double split_length = Double.parseDouble(copies + "");
        int array_length = (int)Math.ceil((double)bytes.length / split_length);
        byte[][] result = new byte[array_length][];
        for (int i = 0; i < array_length; ++i) {
            int from = (int)((double)i * split_length);
            int to = (int)((double)from + split_length);
            if (to > bytes.length) {
                to = bytes.length;
            }
            result[i] = Arrays.copyOfRange(bytes, from, to);
        }
        return result;
    }

    @SideOnly(value=Side.CLIENT)
    public static void drawDonateImage(GuiContainer gui, int mouseX, int mouseY) {
        Minecraft.func_71410_x().func_110434_K().func_110577_a(DONATEIMAGE);
        float donateHeight = PictureFactory.getMcScaledHeight() / 3;
        if (mouseX > 0 && (float)mouseX < 0.75f * donateHeight && mouseY > PictureFactory.getMcScaledHeight() / 2 - (int)donateHeight / 2 && (float)mouseY < (float)(PictureFactory.getMcScaledHeight() / 2 - (int)donateHeight / 2) + donateHeight) {
            donateHeight = (float)((double)donateHeight * 1.7);
        }
        float donateWidth = 0.75f * donateHeight;
        int displayY = PictureFactory.getMcScaledHeight() / 2 - (int)donateHeight / 2;
        GuiContainer.func_146110_a((int)0, (int)displayY, (float)0.0f, (float)0.0f, (int)((int)donateWidth), (int)((int)donateHeight), (float)donateWidth, (float)donateHeight);
    }

    public static int ceiling_double_int(double value) {
        int i = (int)value;
        return value > (double)i ? i + 1 : i;
    }
}

