/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.biomes;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFlower;
import net.minecraft.entity.Entity;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.monster.EntitySlime;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.stats.Achievement;
import net.minecraft.util.DamageSource;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.gen.feature.WorldGenAbstractTree;
import net.minecraft.world.gen.feature.WorldGenBlockBlob;
import net.minecraft.world.gen.feature.WorldGenMegaPineTree;
import net.minecraft.world.gen.feature.WorldGenTaiga1;
import net.minecraft.world.gen.feature.WorldGenTaiga2;
import net.minecraft.world.gen.feature.WorldGenTallGrass;
import net.minecraft.world.gen.feature.WorldGenerator;
import twilightforest.TFAchievementPage;
import twilightforest.biomes.TFBiomeBase;
import twilightforest.biomes.TFBiomeDecorator;
import twilightforest.block.TFBlocks;
import twilightforest.entity.EntityTFTroll;
import twilightforest.world.TFGenTrollRoots;

public class TFBiomeHighlands
extends TFBiomeBase {
    private static final WorldGenTaiga1 taigaGen1 = new WorldGenTaiga1();
    private static final WorldGenTaiga2 taigaGen2 = new WorldGenTaiga2(false);
    private static final WorldGenMegaPineTree megaPineGen1 = new WorldGenMegaPineTree(false, false);
    private static final WorldGenMegaPineTree megaPineGen2 = new WorldGenMegaPineTree(false, true);
    private static final WorldGenBlockBlob genBoulder = new WorldGenBlockBlob(Blocks.field_150341_Y, 0);
    private static final TFGenTrollRoots genTrollRoots = new TFGenTrollRoots();
    private static final WorldGenTallGrass worldGenMushgloom = new WorldGenTallGrass(TFBlocks.plant, 9);

    public TFBiomeHighlands(int i) {
        super(i);
        this.field_76750_F = 0.4f;
        this.field_76751_G = 0.7f;
        ((TFBiomeDecorator)this.field_76760_I).canopyPerChunk = -999.0f;
        this.field_76760_I.field_76803_B = 7;
        this.field_76760_I.field_76804_C = 1;
        this.field_76760_I.field_76808_K = false;
        this.undergroundMonsterList.clear();
        this.undergroundMonsterList.add(new BiomeGenBase.SpawnListEntry(EntitySkeleton.class, 10, 4, 4));
        this.undergroundMonsterList.add(new BiomeGenBase.SpawnListEntry(EntityCreeper.class, 1, 4, 4));
        this.undergroundMonsterList.add(new BiomeGenBase.SpawnListEntry(EntitySlime.class, 10, 4, 4));
        this.undergroundMonsterList.add(new BiomeGenBase.SpawnListEntry(EntityTFTroll.class, 10, 4, 4));
    }

    @Override
    public WorldGenAbstractTree func_150567_a(Random random) {
        if (random.nextInt(4) == 0) {
            return taigaGen1;
        }
        if (random.nextInt(10) == 0) {
            return taigaGen2;
        }
        if (random.nextInt(3) == 0) {
            return megaPineGen1;
        }
        if (random.nextInt(13) == 0) {
            return megaPineGen2;
        }
        return this.birchGen;
    }

    @Override
    public WorldGenerator func_76730_b(Random par1Random) {
        return par1Random.nextInt(5) > 0 ? new WorldGenTallGrass((Block)Blocks.field_150329_H, 2) : new WorldGenTallGrass((Block)Blocks.field_150329_H, 1);
    }

    @Override
    public void func_150573_a(World world, Random rand, Block[] blockStorage, byte[] metaStorage, int x, int z, double noiseVal) {
        this.field_76752_A = Blocks.field_150349_c;
        this.field_150604_aj = 0;
        this.field_76753_B = Blocks.field_150346_d;
        if (noiseVal > 1.75) {
            this.field_76752_A = Blocks.field_150346_d;
            this.field_150604_aj = 1;
        } else if (noiseVal > -0.95) {
            this.field_76752_A = Blocks.field_150346_d;
            this.field_150604_aj = 2;
        }
        this.genTwilightBiomeTerrain(world, rand, blockStorage, metaStorage, x, z, noiseVal);
    }

    public void func_76728_a(World par1World, Random par2Random, int mapX, int mapZ) {
        int rx;
        int dy;
        int dz;
        int dx;
        int i;
        int maxBoulders = par2Random.nextInt(2);
        for (i = 0; i < maxBoulders; ++i) {
            dx = mapX + par2Random.nextInt(16) + 8;
            dz = mapZ + par2Random.nextInt(16) + 8;
            dy = par1World.func_72976_f(dx, dz);
            genBoulder.func_76484_a(par1World, par2Random, dx, dy, dz);
        }
        field_150610_ae.func_150548_a(3);
        for (i = 0; i < 7; ++i) {
            dx = mapX + par2Random.nextInt(16) + 8;
            dz = mapZ + par2Random.nextInt(16) + 8;
            dy = par2Random.nextInt(par1World.func_72976_f(dx, dz) + 32);
            field_150610_ae.func_76484_a(par1World, par2Random, dx, dy, dz);
        }
        for (i = 0; i < 1; ++i) {
            rx = mapX + par2Random.nextInt(16) + 8;
            int rz = mapZ + par2Random.nextInt(16) + 8;
            int ry = par2Random.nextInt(64);
            worldGenMushgloom.func_76484_a(par1World, par2Random, rx, ry, rz);
        }
        for (i = 0; i < 24; ++i) {
            rx = mapX + par2Random.nextInt(16) + 8;
            int ry = 64;
            int rz = mapZ + par2Random.nextInt(16) + 8;
            genTrollRoots.func_76484_a(par1World, par2Random, rx, ry, rz);
        }
        super.func_76728_a(par1World, par2Random, mapX, mapZ);
    }

    public String func_150572_a(Random rand, int x, int y, int z) {
        return rand.nextBoolean() ? BlockFlower.field_149858_b[0] : BlockFlower.field_149859_a[8];
    }

    @Override
    protected Achievement getRequiredAchievement() {
        return TFAchievementPage.twilightProgressGlacier;
    }

    @Override
    public void enforceProgession(EntityPlayer player, World world) {
        if (!world.field_72995_K && world.func_72820_D() % 5L == 0L) {
            player.func_70097_a(DamageSource.field_76376_m, 0.5f);
            world.func_72956_a((Entity)player, "random.fizz", 1.0f, 1.0f);
        }
    }
}

