//-----------------------------------------------------------
// Used by the visualizer system to control a Visualization Actor
//-----------------------------------------------------------
class X2Action_ApplyWeaponDamageToUnit_HITCHANCE extends X2Action_ApplyWeaponDamageToUnit;

simulated state Executing
{
	// Hit Chance mod change
	simulated function ShowHPDamageMessage(string UIMessage, optional string CritMessage)
	{
		local XComUIBroadcastWorldMessage kBroadcastWorldMessage;
		// Hit Chance mod change
		UIMessage = UIMessage $ GetChanceString();
		//
		kBroadcastWorldMessage = class'UIWorldMessageMgr'.static.DamageDisplay(m_vHitLocation, Unit.GetVisualizedStateReference(), UIMessage, UnitPawn.m_eTeamVisibilityFlags, class'XComUIBroadcastWorldMessage_DamageDisplay', m_iDamage, 0, CritMessage, DamageTypeName == 'Psi'? eWDT_Psi : -1);
		if(kBroadcastWorldMessage != none)
		{
			XComUIBroadcastWorldMessage_DamageDisplay(kBroadcastWorldMessage).Init_DisplayDamage(eUIBWMDamageDisplayType_Hit, m_vHitLocation, Unit.GetVisualizedStateReference(), m_iDamage, UnitPawn.m_eTeamVisibilityFlags);
		}
	}
	// End change
	// Hit Chance mod change
	simulated function ShowMissMessage()
	{
		if (m_iDamage > 0)
			class'UIWorldMessageMgr'.static.DamageDisplay(m_vHitLocation, Unit.GetVisualizedStateReference(), (class'XLocalizedData'.default.MissedMessage $ GetChanceString()), UnitPawn.m_eTeamVisibilityFlags, class'XComUIBroadcastWorldMessage_DamageDisplay', m_iDamage);
		else if (!OriginatingEffect.IsA('X2Effect_Persistent')) //Persistent effects that are failing to cause damage are not noteworthy.
			class'UIWorldMessageMgr'.static.DamageDisplay(m_vHitLocation, Unit.GetVisualizedStateReference(), (class'XLocalizedData'.default.MissedMessage $ GetChanceString()));
	}
	
	simulated function ShowCounterattackMessage()
	{
		class'UIWorldMessageMgr'.static.DamageDisplay(m_vHitLocation, Unit.GetVisualizedStateReference(), (class'XLocalizedData'.default.CounterattackMessage $ GetChanceString()));
	}

	simulated function ShowLightningReflexesMessage()
	{
		class'UIWorldMessageMgr'.static.DamageDisplay(m_vHitLocation, Unit.GetVisualizedStateReference(), (class'XLocalizedData'.default.LightningReflexesMessage $ GetChanceString()));
	}

	simulated function ShowUntouchableMessage()
	{
		class'UIWorldMessageMgr'.static.DamageDisplay(m_vHitLocation, Unit.GetVisualizedStateReference(), (class'XLocalizedData'.default.UntouchableMessage $ GetChanceString()));
	}

	simulated function ShowFreeKillMessage()
	{
		class'UIWorldMessageMgr'.static.DamageDisplay(m_vHitLocation, Unit.GetVisualizedStateReference(), (class'XLocalizedData'.default.FreeKillMessage $ GetChanceString()), , , , , , eWDT_Repeater);
	}
	// Hit Chance mod change
	function string GetChanceString()
	{
		local int chanceToPrint;
		// change to config later
		local bool HIT_CHANCE_MOD_ENABLED;

		HIT_CHANCE_MOD_ENABLED = true;
		chanceToPrint = XComGameStateContext_Ability(StateChangeContext).ResultContext.CalculatedHitChance;
		if ( HIT_CHANCE_MOD_ENABLED )
		{
			if ( !CheckPersistentDamage() && !CheckGuaranteedHit() )
			{
				return " - HIT CHANCE: " $ Clamp(chanceToPrint, 0, 100) $ "%";
			}
			else if ( CheckPersistentDamage() )
			{
				return "";
			}
			else if ( CheckGuaranteedHit() )
			{
				return " - GUARANTEED HIT";
			}
		}
		else
		{
			return "";
		}
	}

	simulated function bool CheckPersistentDamage()
	{
		if (X2Effect_Persistent(DamageEffect) != none)
			return true;

		if (X2Effect_Persistent(OriginatingEffect) != None)
			return true;

		if (X2Effect_Persistent(AncestorEffect) != None)
			return true;

		return false;
	}

	simulated function bool CheckGuaranteedHit()
	{
		if ( X2AbilityToHitCalc_DeadEye(AbilityTemplate.AbilityToHitCalc) != None)	return true;
		
		return false;
	}
	// End Hit Chance changes
}