local Level = Class( function ( self, inst )
	self.inst = inst

	self.maxlevel = 1
	self.currentlevel = self.maxlevel
	self.levelupexpstate = {}
	self.levelupexp = 1
	self.currentexp = 0

	self.skillpoints = self.currentlevel
	self.currentskillpoints = self.skillpoints
	self.skilledpoints = 0

	self.ismaxlevle = true
	self.hasskillpoints = false
	self.levelupfn = nil
	self.maxlevelfn = nil
end)

function Level:SetMaxLevel( level )
    self.maxlevel = level
    if self.currentlevel < self.maxlevel then
        self.ismaxlevle = false
    end
end

function Level:OnRemoveFromEntity() --从实体删除
    -- body
end

function Level:GetSkillPoints(  )
	self.skillpoints = self.currentlevel
end

function Level:SetLevelUpExp( exp )
	if self.levelupexpstate and self.levelupexpstate[self.currentlevel] then
		self.levelupexp = self.levelupexpstate[self.currentlevel]
	elseif exp then
		self.levelupexp = exp
	end
end

function Level:SetLevelUpFn( fn )
	self.levelupfn = fn
end

function Level:SetMaxLevelFn( fn )
	self.maxlevelfn = fn
end

function Level:OnSave(  )
	return
	{
		maxlevel = self.maxlevel ,
		currentlevel = self.currentlevel ,
		exp = self.currentexp ,
		currentskillpoints = self.currentskillpoints
	}
end

function Level:OnLoad( data )
	if data.maxlevel then
		self:SetMaxLevel(data.maxlevel)
	end
	if data.currentlevel then
		self.currentlevel = data.currentlevel
	end
	if data.exp then
		self.currentexp = data.exp
	end
	if data.currentskillpoints then
		self.currentskillpoints = data.currentskillpoints
	end
	self:ExpDoDelta(0)
end

function Level:ExpDoDelta( amount )
	if not self.ismaxlevle then
		self.currentexp = math.max(self.currentexp + amount , 0)
		if not self.ismaxlevle and self.currentexp >= self.levelupexp then -- self.levelupexp and 
			self:LevelUp()
		end
		--self.inst.currentexp:set(self.currentexp)
	end
end

function Level:LevelUp(  )
	if self.levelupexp and self.currentexp and self.currentexp >= self.levelupexp then
		local exp = self.levelupexp
		self.currentlevel = math.min(self.currentlevel + 1 , self.maxlevel)
		self.currentskillpoints = self.currentskillpoints + 1
		self.inst:PushEvent("levelup",self.inst)
		if self.levelupfn then
			self.levelupfn(self.inst)
		end
		if self.currentlevel == self.maxlevel then
			self.ismaxlevle = true
			self.currentexp = 0
			self.levelupexp = 0
			if self.maxlevelfn then
				self.maxlevelfn(self.inst)
			end
			self.inst:PushEvent("maxlevel",self.inst)
		end
		self:ExpDoDelta(-exp)
	end
end

return Level 