local function oncurrent(self,current)
    self.inst.currentmana:set(current)
end

local Mana = Class(function ( self , inst )
	self.inst = inst
	
	self.maxmana = 100
	self.currentmana = self.maxmana / 2 --当前法力值
	--inst.managrowth = 0 --法术力增长
	self.manarecovery = .1 	--法力值恢复
	--inst.manarecoverygrowth = .01 --魔法恢复增长
	self.recoverytime = 1

	self:StartManaRecovery()

end,
nil,
{
	currentmana = oncurrent
	--skilllevel = initskilllevel,
})

function Mana:DoDelta(amount)
	--if amount ~= nil then
		--self.currentmana = self.currentmana + amount
	self.currentmana = math.clamp(self.currentmana + amount , 0 , self.maxmana)
    return self.currentmana
	--end
end

function Mana:OnSave(  )
	return 
	{
		currentmana = self.currentmana
	--	currentlevel = self.currentlevel,
	--	exp = self.currentexp
	}
end

function Mana:OnLoad( data )
	if data.currentmana then
		self.currentmana = data.currentmana
		self.inst.currentmana:set(self.currentmana)
	end
	--if data.currentlevel then
	--	self.currentlevel = data.currentlevel
	--end
	--if data.exp then
	--	self.currentexp = data.exp
	--end
	self.inst.maxmana:set(self.maxmana)
end

function Mana:SetMaxMana( max )
	self.maxmana = max
	self.inst.maxmana:set(self.maxmana)
end

local function DoRecovery(inst, self)
	self.currentmana = math.min(self.maxmana, self.currentmana + self.manarecovery)
	self.inst.currentmana:set(self.currentmana)
	--print("self.currentmana:",self.currentmana)
end

function Mana:StartManaRecovery(  )
	if self.regen == nil then
        self.regen = {}
    end
    self.regen.amount = self.manarecovery
    self.regen.period = self.recoverytime

    if self.regen.task == nil then -- and not self.inst:HasTag("playerghost") not self.inst.components.health:IsDead()
        self.regen.task = self.inst:DoPeriodicTask(self.regen.period, DoRecovery, nil, self)
    end
end

function Mana:StopManaRecovery()
    if self.regen ~= nil then
        if self.regen.task ~= nil then
            self.regen.task:Cancel()
            self.regen.task = nil
        end
        self.regen = nil
    end
end

function Mana:GetPercent()
    return self.currentmana / self.maxmana
end

function Mana:SetPercent(percent)
    self.currentmana = self.maxmana * percent
end

return Mana