local assets =
{
    Asset("ANIM", "anim/blow_dart.zip"),
    --Asset("ANIM", "anim/swap_blowdart.zip"),
    --Asset("ANIM", "anim/swap_blowdart_pipe.zip"),
}

local prefabs =
{
--    "impact", -- 碰撞
}

local function onhit(inst, attacker, target)
    local impactfx = SpawnPrefab("impact")
    if impactfx ~= nil then
        local follower = impactfx.entity:AddFollower() --跟随
        follower:FollowSymbol(target.GUID, target.components.combat.hiteffectsymbol, 0, 0, 0) -- hiteffectsymbol 打击效果符号
        if attacker ~= nil then
            impactfx:FacePoint(attacker.Transform:GetWorldPosition())
        end
    end
    inst:Remove()
end

local function onthrown(inst, data)
    inst.AnimState:SetOrientation(ANIM_ORIENTATION.OnGround) -- 设置方向(动画方向.在地上)
end

local function pipethrown(inst)
    inst.AnimState:PlayAnimation("dart_pipe")
    inst:AddTag("NOCLICK") -- 不点击
    inst.persists = false --仍然存在 
end

local function onbuilt( inst , data )
    --print("onbuilt",inst,data,data.builder)
    local builder = data.builder
    -- builder.inventoryimages
    -- Inventory:GetItemByName(item, amount) -- 按名称获取项目
    --if builder.components.inventory:GetItemByName("tomoemamiguns",1) then
    --    print("onbuilt",#builder.components.inventory:GetItemByName("tomoemamiguns",1),GetTime())
    --end
    local item = builder.components.inventory.itemslots
    if item ~= nil then
    print(item,#item,"0000000000000",GetTime())
        for k,v in pairs(item) do
            print(k,v)
            if v.prefab == "tomoemamiguns" then -- 
                print("+++++++++++++++++",v.prefab,GetTime())
                v.components.finiteuses:Use(-10)
                break
            end
        end
        if builder.components.inventory:GetEquippedItem(EQUIPSLOTS.HANDS) and builder.components.inventory:GetEquippedItem(EQUIPSLOTS.HANDS).prefab == "tomoemamiguns" then
            print("EQUIPSLOTS.HANDS",GetTime())
            builder.components.inventory:GetEquippedItem(EQUIPSLOTS.HANDS).components.finiteuses:Use(-10)
        end
    end
end

local function fn()
    local inst = CreateEntity()

    inst.entity:AddTransform()
    inst.entity:AddAnimState()
    inst.entity:AddNetwork()

    MakeInventoryPhysics(inst)

    inst.AnimState:SetBank("blow_dart")
    inst.AnimState:SetBuild("blow_dart")
    --inst.AnimState:PlayAnimation(anim)
    inst.AnimState:PlayAnimation("idle_pipe")

    --inst:AddTag("blowdart")
    inst:AddTag("tomoemamiammunition")

    --projectile (from projectile component) added to pristine state for optimization
    --inst:AddTag("projectile")

    inst.entity:SetPristine()

    if not TheWorld.ismastersim then
        return inst
    end

    inst:AddComponent("projectile")
    inst.components.projectile:SetSpeed(60)
    inst.components.projectile:SetOnHitFn(onhit)
    inst.components.projectile:SetOnThrownFn(pipethrown)    
    --inst.components.projectile:SetOnHitFn(inst.Remove)
    --inst.components.projectile:SetOnMissFn(inst.Remove)
    inst:ListenForEvent("onthrown", onthrown)

    inst:AddComponent("inventoryitem")

    inst:AddComponent("stackable")

    --inst:ListenForEvent("onbuilt", onbuilt)

    return inst
end

return Prefab("mamiammunition", fn, assets, prefabs)
