local assets =
{
    Asset("ANIM", "anim/whip.zip"),
    Asset("ANIM", "anim/swap_whip.zip"),

    Asset( "IMAGE", "images/inventoryimages/inv_bandage.tex" ),
    Asset( "ATLAS", "images/inventoryimages/inv_bandage.xml" ),
}

local prefabs =
{
--    "impact", -- 碰撞
}

local function onkilled( inst , date )
    local target = date.victim
    local exp = 0.01
    --print(target,data.victim)
    local weapon = inst.components.combat:GetWeapon()
    if target and target.components.health then -- target.components.combat
        print("onkilled",weapon.damage)
        --exp = exp + target.components.health.maxhealth / inst.components.health.maxhealth / (1 - inst.components.health.penalty)
        if weapon.damage > target.components.health.maxhealth then
            weapon.damage = weapon.damage - target.components.health.maxhealth
            exp = exp + target.components.health.maxhealth / weapon.components.weapon.damage
        else
            exp = exp + weapon.damage / weapon.components.weapon.damage
            weapon.damage = 0
        end
    end -- inst.components.combat:GetWeapon() and 
    weapon.components.level:ExpDoDelta(exp)
    --print("exp",exp,inst,inst.components.combat:GetWeapon() ,inst.components.level.currentlevel,inst.components.level.currentexp,inst.components.level.levelupexp,inst.components.level.ismaxlevle)
end

local function unequiptask( inst )
    inst.components.inventoryitem.owner.components.inventory:GiveItem(inst)
end

local function bonusdamagefn(  )
    --local old_bonusdamagefn = inst.components.combat.bonusdamagefn
    return function ( attacker, target, damage, weapon )
        weapon.damage = weapon.damage + damage
        damage = weapon.components.weapon.damage
        if target.components.inventory ~= nil then 
            damage = target.components.inventory:ApplyDamage(damage * .25 , attacker , weapon)
        else
            damage = damage * .25
        end
        weapon.damage = weapon.damage + damage
        --print("bonusdamagefn",target.damage,damage)
        return weapon.old_bonusdamagefn and weapon.old_bonusdamagefn(attacker, target, damage, weapon) + damage or damage
    end
end

local function redirectdamagefn( inst, attacker, damage, weapon, stimuli )
    --print("redirectdamagefn",inst, attacker, damage, weapon, stimuli)
    if attacker == nil and stimuli == "darkness" then
        attacker = CreateEntity()
        attacker:AddComponent("combat")
        inst.components.talker:Say("You can not catch me , Charlie!",nil,nil,true)
        inst.components.combat:GetWeapon().components.finiteuses:Use(20)
        return attacker
    end
    return nil
end

local function unequiptask( inst , owner )
    owner.components.inventory:DropItem(inst,true,true)
    inst.components.talker:Say("This is Mami's Mami Bandage !")
end

local function onequip(inst, owner)
    if not inst.components.customize:IsCustomize(owner.name,owner.prefab) then
        inst:DoTaskInTime(0 , unequiptask , owner)
        return
    end 
    owner.AnimState:OverrideSymbol("swap_object", "swap_whip", "swap_whip")
    owner.AnimState:OverrideSymbol("whipline", "swap_whip", "whipline")
    owner.AnimState:Show("ARM_carry")
    owner.AnimState:Hide("ARM_normal")
    owner.components.combat.redirectdamagefn = redirectdamagefn
    inst.old_bonusdamagefn = owner.components.combat.bonusdamagefn
    owner.components.combat.bonusdamagefn = bonusdamagefn()
    inst:ListenForEvent("killed", onkilled , owner)
    if inst.components.finiteuses:GetPercent() <= 0 then
        inst:DoTaskInTime(0 , unequiptask)
        return
    end
    inst.components.talker:Say(string.format("level : %d\nexp : %d / %d",inst.components.level.currentlevel , inst.components.level.currentexp , inst.components.level.levelupexp ) )
end

local function onunequip(inst, owner)
    owner.AnimState:Hide("ARM_carry")
    owner.AnimState:Show("ARM_normal")
    owner.components.combat.redirectdamagefn = nil
    owner.components.combat.bonusdamagefn = inst.old_bonusdamagefn
    inst:RemoveEventCallback("killed", onkilled , owner)
end

local function onpickup( inst , owner )
    print("onpickup",inst,owner,owner.name,owner.prefab)
    if not inst.components.customize:IsCustomize(owner.name,owner.prefab) then
        owner.components.inventory:DropItem(inst,true,true)
        inst.components.talker:Say("This is Mami's Mami Bandage !")
        return true
    end
    return false
end

local function onlevelup( inst )
    --inst.components.level:SetLevelUpExp(inst.components.level.currentlevel * 5)
    inst.components.level:SetLevelUpExp(math.ceil((1 + math.sin(math.rad(3 * (inst.components.level.currentlevel + 1) - 90))) * 1000))
    local dam = 34 + inst.components.level.currentlevel * .3
    inst.components.weapon:SetDamage(dam)
    inst.components.talker:Say(string.format("level : %d\nexp : %d / %d",inst.components.level.currentlevel , inst.components.level.currentexp - math.ceil((1 + math.sin(math.rad(3 * inst.components.level.currentlevel - 90))) * 1000) , inst.components.level.levelupexp ) )

    --inst.components.weapon:SetDamage(43 + .25 * inst.components.level.currentlevel)
    --inst.multdamage = 43 * ( .1 + inst.components.level.currentlevel * .005)
    --inst.targetnum = math.floor(1 + inst.components.level.currentlevel * .2)
    --inst.heal = 2 + inst.components.level.currentlevel * .1
    --print("onlevelup",inst.components.level.currentexp,inst.components.level.levelupexp,GetTime())
end

local function test( inst , item , giver) -- item
    --print("test",inst,item,item.name,item.prefab) -- ,giver -- reviver -- 复活之心 -- lifeinjector -- VGA针剂
    if item and (item.prefab == "reviver" or item.prefab == "lifeinjector" or item.prefab == "livinglog") and inst.components.finiteuses:GetUses() <= inst.components.finiteuses.total -10 then
        return true
    else
        return false
    end
end

local function onaccept( inst , item , giver )
    --print("onaccept",inst,item,giver)
    if not inst.components.level.ismaxlevle then
        inst.components.level:ExpDoDelta(5)
        inst.components.finiteuses:Use(-15)
    else
        inst.components.finiteuses:Use(-20)
    end
    inst.components.talker:Say(string.format("level : %d\nexp : %d / %d",inst.components.level.currentlevel , inst.components.level.currentexp , inst.components.level.levelupexp ) )
end

local function percentusedchange( inst ,data )
    local percent = data.percent
    if percent <= 0 and inst.components.inventoryitem.owner then
       inst.components.inventoryitem.owner.components.inventory:GiveItem(inst)
    end
    if inst.components.finiteuses:GetUses() <= inst.components.finiteuses.total -15 and (not inst:HasTag("trader") or not inst:HasTag("alltrader")) then
        inst:AddTag("trader")
        inst:AddTag("alltrader")
    elseif inst.components.finiteuses:GetUses() > inst.components.finiteuses.total -15 then
        inst:RemoveTag("trader")
        inst:RemoveTag("alltrader")
    end
end

local function onhauntfn( inst, haunter )
    if inst.components.finiteuses:GetUses() >= 40 and haunter.components.health:GetPenaltyPercent() <= .5 then
        inst.components.finiteuses:Use(40)
        haunter.components.health:DeltaPenalty(.25)
        return true
    else
        return false
    end
end

local function onbuilt( inst , builder )
    if builder then
        inst.components.customize:SetCustomize(builder.prefab,builder.name)
    end
end

local function onload( inst , data )
    onlevelup( inst )
    if inst.components.finiteuses:GetUses() <= inst.components.finiteuses.total -15 and (not inst:HasTag("trader") or not inst:HasTag("alltrader")) then
        inst:AddTag("trader")
        inst:AddTag("alltrader")
    elseif inst.components.finiteuses:GetUses() > inst.components.finiteuses.total -15 then
        inst:RemoveTag("trader")
        inst:RemoveTag("alltrader")
    end
end

local function onattack( inst, owner , target , projectile )

end

local function fn()
    local inst = CreateEntity()

    inst.entity:AddTransform()
    inst.entity:AddAnimState()
    inst.entity:AddNetwork()

    MakeInventoryPhysics(inst)

    inst.AnimState:SetBank("whip")
    inst.AnimState:SetBuild("whip")
    inst.AnimState:PlayAnimation("idle")

    inst:AddTag("whip")

    inst:AddTag("mamibandage")

    inst:AddComponent("talker")
    inst.components.talker.fontsize = 25
    inst.components.talker.font = TALKINGFONT
    inst.components.talker.colour = Vector3(1, 0.25, 1, 1)
    inst.components.talker.offset = Vector3(200,0,0)
    -- Say(script, time, noanim, force, nobroadcast, color) -- 脚本，时间，无动画，强制，无广播，颜色

    inst.entity:SetPristine()

    if not TheWorld.ismastersim then
        return inst
    end

    inst:AddComponent("weapon")
    inst.components.weapon:SetDamage(34)
    inst.components.weapon:SetRange(2,3)
    inst.components.weapon:SetOnAttack(onattack)

    inst:AddComponent("level")
    inst.components.level:SetMaxLevel(30)
    inst.components.level:SetLevelUpExp(5)
    inst.components.level:SetLevelUpFn(onlevelup)

    inst:AddComponent("customize")

    inst:AddComponent("inspectable") -- 视察

    inst:AddComponent("inventoryitem")
    inst.components.inventoryitem:SetOnPickupFn(onpickup)
    inst.components.inventoryitem.atlasname = "images/inventoryimages/inv_bandage.xml"
    inst.components.inventoryitem.imagename = "inv_bandage"

    inst:AddComponent("equippable")
    inst.components.equippable:SetOnEquip(onequip)
    inst.components.equippable:SetOnUnequip(onunequip)

    inst:AddComponent("finiteuses")     --finiteuses --有限元
    inst.components.finiteuses:SetMaxUses(86)        --最大使用
    inst.components.finiteuses:SetUses(86)       --使用
    --inst.components.finiteuses:SetOnFinished(onfinished)
    inst:ListenForEvent("percentusedchange", percentusedchange)

    inst:AddComponent("trader")
    inst.components.trader:SetAcceptTest(test)
    inst.components.trader.onaccept = onaccept

    inst:AddComponent("hauntable")
    inst.components.hauntable:SetOnHauntFn(onhauntfn)
    inst.components.hauntable:SetHauntValue(TUNING.HAUNT_INSTANT_REZ)

    inst.damage = 0
    inst.lastattacttime = 0

    inst.OnBuilt = onbuilt
    inst.OnLoad = onload

    return inst

   -- MakeHauntableLaunch(inst)
end

return Prefab("common/inventory/mamibandage", fn, assets, prefabs)