local assets =
{
    Asset("ANIM", "anim/blow_dart.zip"),
    --Asset("ANIM", "anim/swap_blowdart.zip"),
    --Asset("ANIM", "anim/swap_blowdart_pipe.zip"),
}

local prefabs =
{
    "impact", -- 碰撞
}

local function onkilled( inst , date )
    local target = date.victim
    local exp = 0.01
    --print(target,data.victim)
    if target and target.components.combat then 
        --exp = exp + target.components.health.maxhealth / inst.components.health.maxhealth / (1 - inst.components.health.penalty)
        exp = exp + target.components.combat.defaultdamage
    end -- inst.components.combat:GetWeapon() and 
    inst.components.combat:GetWeapon().components.level:ExpDoDelta(exp)
    --print("exp",exp,inst,inst.components.combat:GetWeapon() ,inst.components.level.currentlevel,inst.components.level.currentexp,inst.components.level.levelupexp,inst.components.level.ismaxlevle)
end

local function bonusdamagefn( attacker, inst, damage, weapon )
    if inst.components.inventory ~= nil then
        return inst.components.inventory:ApplyDamage(damage * .25 , attacker , weapon)
    end
    return damage * .25
end

local function unequiptask( inst )
    inst.components.inventoryitem.owner.components.inventory:GiveItem(inst)
end

local function onequip(inst, owner)
    --owner.AnimState:OverrideSymbol("swap_object", "swap_blowdart", "swap_blowdart")
    owner.AnimState:Show("ARM_carry")
    owner.AnimState:Hide("ARM_normal")
    owner.components.combat.bonusdamagefn = bonusdamagefn
    inst:ListenForEvent("killed", onkilled , owner)
    if inst.components.finiteuses:GetPercent() <= 0 then
        inst:DoTaskInTime(0 , unequiptask)
        return
    end
    owner.components.talker:Say(string.format("level:%d",inst.components.level.currentlevel ) )
end

local function onunequip(inst, owner)
    --owner.AnimState:ClearOverrideSymbol("swap_object")
    owner.AnimState:Hide("ARM_carry")
    owner.AnimState:Show("ARM_normal")
    --owner.components.combat.onhitotherfn = nil
    owner.components.combat.bonusdamagefn = nil
    inst:RemoveEventCallback("killed", onkilled , owner)
end

local function onthrown(inst, data)
    inst.AnimState:SetOrientation(ANIM_ORIENTATION.OnGround) -- 设置方向(动画方向.在地上)
end

local function onfinished( inst )
    -- body
end

local function onlevelup( inst )
    inst.components.level:SetLevelUpExp(inst.components.level.currentlevel * 5)
    local dam = 34 + inst.components.level.currentlevel * .3
    inst.components.weapon:SetDamage(dam)
    --inst.components.weapon:SetDamage(43 + .25 * inst.components.level.currentlevel)
    --inst.multdamage = 43 * ( .1 + inst.components.level.currentlevel * .005)
    --inst.targetnum = math.floor(1 + inst.components.level.currentlevel * .2)
    --inst.heal = 2 + inst.components.level.currentlevel * .1
    --print("onlevelup",inst.components.level.currentexp,inst.components.level.levelupexp,GetTime())
end

local function test( inst , item , giver) -- item
    --print("test",inst,item,item.name,item.prefab) -- ,giver -- reviver -- 复活之心 -- lifeinjector -- VGA针剂
    --if item and (item.prefab == "reviver" or item.prefab == "lifeinjector") and inst.components.finiteuses:GetUses() < inst.components.finiteuses.total then
    if item and item.prefab == "tomoemamiammunition" and inst.components.finiteuses:GetUses() < inst.components.finiteuses.total - 10 then    
        --print("item.name",item.name)
        return true
    else
        return false
    end
end

local function onaccept( inst , item , giver )
    --print("onaccept",inst,item,giver)
    if not inst.components.level.ismaxlevle then
        inst.components.level:ExpDoDelta(5)
        inst.components.finiteuses:Use(-5)
    else
        inst.components.finiteuses:Use(-10)
    end
end

local function percentusedchange( inst ,data )
    local percent = data.percent
    if percent <= 0 then
        inst.components.inventoryitem.owner.components.inventory:GiveItem(inst)
    end
end

local function fn()
    local inst = CreateEntity()

    inst.entity:AddTransform()
    inst.entity:AddAnimState()
    inst.entity:AddNetwork()

    MakeInventoryPhysics(inst)

    inst.AnimState:SetBank("blow_dart")
    inst.AnimState:SetBuild("blow_dart")
    --inst.AnimState:PlayAnimation(anim)
    inst.AnimState:PlayAnimation("idle_pipe")

    --inst:AddTag("blowdart")
    inst:AddTag("tomoemamiguns")
    inst:AddTag("sharp")

    --projectile (from projectile component) added to pristine state for optimization
    inst:AddTag("projectile")

    inst.entity:SetPristine()

    if not TheWorld.ismastersim then
        return inst
    end

    inst:AddComponent("weapon")
    inst.components.weapon:SetDamage(34)
    --inst.components.weapon:SetDamage(TUNING.PIPE_DART_DAMAGE)
    inst.components.weapon:SetRange(8, 10)
    inst.components.weapon:SetProjectile("tomoemamiammunition")

    inst:AddComponent("level")
    inst.components.level:SetMaxLevel(30)
    inst.components.level:SetLevelUpExp(5)
    inst.components.level:SetLevelUpFn(onlevelup)

    inst:AddComponent("inspectable") -- 视察

    inst:AddComponent("inventoryitem")
    --inst:AddComponent("stackable") -- 可堆叠

    inst:AddComponent("equippable")
    inst.components.equippable:SetOnEquip(onequip)
    --inst.components.equippable:SetOnEquip(pipeequip)
    inst.components.equippable:SetOnUnequip(onunequip)
    --inst.components.equippable.equipstack = true -- 装备堆

    inst:AddComponent("finiteuses")     --finiteuses --有限元
    inst.components.finiteuses:SetMaxUses(86)        --最大使用
    inst.components.finiteuses:SetUses(86)       --使用
    inst.components.finiteuses:SetOnFinished(onfinished)

    inst:AddComponent("trader")
    inst.components.trader:SetAcceptTest(test)
    inst.components.trader.onaccept = onaccept
    inst:AddTag("trader")
    inst:AddTag("alltrader")

    inst:ListenForEvent("percentusedchange", percentusedchange)

    return inst

   -- MakeHauntableLaunch(inst)
end

return Prefab("mamiguns", fn, assets, prefabs)