local MakePlayerCharacter = require "prefabs/player_common"

--local maths = require "components/maths"

local assets = {
    Asset("SCRIPT", "scripts/prefabs/player_common.lua"),
    --Asset( "ANIM", "anim/tomoemami.zip" ),
}
local prefabs = {

}

-- Custom starting items
local start_inv = {
	"reviver",
	"lifeinjector",
	"lifeinjector",
	"lifeinjector",
	"lifeinjector",
	"lifeinjector",
}

local function healthdelta( inst , data )
	-- data = {oldpercent = old_percent, newpercent = self:GetPercent(), overtime = overtime, cause = cause, afflicter = afflicter, amount = amount }
	if data.newpercent < .5 then 
		inst.components.sanity.rate_modifier = .55 - inst.components.level.currentlevel * .01
		inst.components.hunger:SetRate(TUNING.WILSON_HUNGER_RATE * (.55 - inst.components.level.currentlevel * .01))
	end
end

local function custom_rate_fn( inst )
	local x, y, z = inst.Transform:GetWorldPosition()
    local ents = TheSim:FindEntities(x, y, z, TUNING.SANITY_EFFECT_RANGE, nil, { "FX", "NOCLICK", "DECOR","INLIMBO" }, { "epic","player"})
	for i, v in ipairs(ents) do 
        if v ~= inst and v:HasTag("player") then
        	return 0
        end
    end
    if #ents > 1 then
    	--print("",#ents)
		return inst.components.sanity.rate * (3 - inst.components.level.currentlevel * .02)
	end
	return 0
end

local function OnLevelUp( inst )
	inst.components.level:SetLevelUpExp(math.pow(inst.components.level.currentlevel , 2) + inst.components.level.currentlevel * 4 + math.floor(math.ceil(inst.components.level.currentlevel / 2) * inst.components.level.currentlevel / 10)) -- + inst.components.level.currentexp)
	inst.components.mana:SetMaxMana(100 + inst.components.level.currentlevel * 2 / 3)
	inst.components.mana.manarecovery = inst.components.mana.manarecovery + inst.components.level.currentlevel * .01
	inst.components.health.maxhealth = 101 + inst.components.level.currentlevel * .8
	inst.components.sanity.max = 150 + inst.components.level.currentlevel * 1
	inst.components.hunger.max = 120 + inst.components.level.currentlevel * 1

	inst.components.sanity.custom_rate_fn = custom_rate_fn
	inst.components.sanity.night_drain_mult = 1.35 - inst.components.level.currentlevel * .001
	inst.components.hunger:SetRate(TUNING.WILSON_HUNGER_RATE * (.55 - inst.components.level.currentlevel * .01))
	--print("OnLevelUp",inst.components.sanity.night_drain_mult,inst.components.sanity.custom_rate_fn,inst.components.sanity.rate_modifier )
	inst.currentlevel:set(inst.components.level.currentlevel)
	inst.levelupexp:set(inst.components.level.levelupexp)
	inst.currentexp:set(inst.components.level.currentexp)
	--print("OnLevelUp",inst.components.level.currentlevel,inst.components.level.currentexp,inst.components.level.levelupexp)
end

local function bonusdamagefn(inst)
	local old_bonusdamagefn = inst.components.combat.bonusdamagefn
	return function ( inst, target, damage, weapon )
		inst.damage = inst.damage + damage
		--print("bonusdamagefn",inst.damage,damage)
		return old_bonusdamagefn and old_bonusdamagefn(inst, target, damage, weapon) or 0
	end
end

local function getexptask( inst , target )
	local exp = 0.01
	if target then 
		--exp = (target.components.combat.defaultdamage + target.components.health.maxhealth ) / (inst.components.health.currenthealth + target.components.health.maxhealth + 1 ) / (1 - inst.components.health.penalty)
		--exp = target.components.health.maxhealth / (inst.act + inst.components.health:GetPercent()) / (1 - inst.components.health.penalty)
		--exp = inst.dmg / target.components.health.maxhealth / (1 - inst.components.health.penalty)
		exp = exp + target.components.health.maxhealth / inst.components.health.maxhealth / (1 - inst.components.health.penalty)
		--exp = exp + math.min(inst.damage,target.components.health.maxhealth) / inst.components.health.maxhealth / (1 - inst.components.health.penalty)
	end
	inst.components.level:ExpDoDelta(exp)
	inst.currentexp:set(inst.components.level.currentexp)
end

local function stopattacttask( inst )
    if inst.attacktask ~= nil then
        inst.attacktask:Cancel()
        inst.attacktask = nil
    end
end

local function attacktask( inst )
	for k,v in pairs(inst.targets) do
		print(k,v)
		if v.components.health and v.components.health:IsDead() then
			getexptask(inst,v)
			table.remove(inst.targets,k)
		end
	end
	if #inst.targets <= 0 then
		stopattacttask(inst)
	end
	if GetTime() - inst.lastattacttime > 5 then
		stopattacttask(inst)
	end
end

local function onattackother( inst , data )
	-- data = { target = targ, weapon = weapon, projectile = projectile, stimuli = stimuli }
	inst.lastattacttime = GetTime()
	local target = data.target
	if inst.attacktask ~= nil then
		inst:DoPeriodicTask(1, attacktask)
	end
	local keeptarget = true
	if target ~= nil then
		for k,v in pairs(inst.targets) do
			print(k,v)
			if v == target then
				keeptarget = false
				break
			end
		end
		if keeptarget then
			table.insert(inst.targets,target)
		end
	end
end

local function OnKilled( inst , data )
	local target = data.victim
	if target then -- and inst.act and inst.dmg 
		attacktask( inst )
	end
end

local function GetDamage(inst)
	if inst.components.combat:GetWeapon() then
		return inst.components.combat:GetWeapon().components.weapon.damage
	else
		return inst.components.combat.defaultdamage
	end
end

local function onGotNewItem( inst )
	inst.attack:set(inst.components.combat:GetWeapon() and inst.components.combat:GetWeapon().components.weapon.damage or inst.components.combat.defaultdamage)
end

local function OnEquip(  inst , data )
	inst.attack:set(inst.components.combat:GetWeapon() and inst.components.combat:GetWeapon().components.weapon.damage or inst.components.combat.defaultdamage)
end

local function onsave(inst, data)

end

-- When the character is revived from human --复活
--当角色从人类复活
local function onbecamehuman(inst)
	-- Set speed when loading or reviving from ghost (optional)
	--从ghost加载或恢复时设置速度（可选）
	inst.components.locomotor.walkspeed = 6
	inst.components.locomotor.runspeed = 8

	OnLevelUp(inst)
	inst.attack:set(inst.components.combat:GetWeapon() and inst.components.combat:GetWeapon().components.weapon.damage or inst.components.combat.defaultdamage)
	inst.components.combat.damagemultiplier = 0.75 + inst.components.health:GetPenaltyPercent()
end

-- When loading or spawning the character --加载
--当加载或产卵的字符
local function onload(inst,data )
    inst:ListenForEvent("ms_respawnedfromghost", onbecamehuman)

    if not inst:HasTag("playerghost") then
        onbecamehuman(inst)
    end
end

local function onNewSpawn( inst )
	onbecamehuman(inst)
	local item = SpawnPrefab("mamibandage")
	if item ~= nil then
		if item.components.customize then
			item.components.customize:SetCustomize(inst.prefab,inst.name)
		end
		inst.components.inventory:GiveItem(item)
	end
end

-- This initializes for both the server and client. Tags can be added here.
--这将初始化为服务器和客户端。 标签可以在这里添加。
local common_postinit = function(inst) 
	-- Minimap icon
	--Minimap图标
	inst.MiniMapEntity:SetIcon( "tomoemami.tex" )
	inst:AddTag("tomoemami")
	inst:AddTag("magicgirl")
	--inst:AddComponent("sanityaura") --理智光环
	--inst.components.sanityaura.aura = TUNING.SANITYAURA_MED --光环

	--能量
	inst.currentmana = net_byte(inst.GUID,"currentmana","currentmana_dirty")-- 
	inst.maxmana = net_byte(inst.GUID,"maxmana","maxmana_dirty")-- 
	inst.currentlevel = net_byte(inst.GUID,"currentlevel","currentlevel_dirty")-- 
	inst.currentexp = net_shortint(inst.GUID,"currentexp","currentexp_dirty")-- 
	inst.levelupexp = net_shortint(inst.GUID,"levelupexp","levelupexp_dirty")-- 
	inst.attack = net_byte(inst.GUID,"attack","attack_dirty")-- 
	inst.cooldownR = net_byte(inst.GUID,"cooldownR","cooldownR_dirty")-- 
	inst.currentlevelR = net_byte(inst.GUID,"currentlevelR")
	inst.lastreleasetimeR = net_byte(inst.GUID,"lastreleasetimeR")
	inst.cooldownT = net_byte(inst.GUID,"cooldownT")
	inst.uncooldownT = net_byte(inst.GUID,"uncooldownT","cooldownT_dirty") -- 
	inst.lastreleasetimeT = net_byte(inst.GUID,"lastreleasetimeT")
	inst.isactivationT = net_bool(inst.GUID,"isactivationT")
	inst.currentlevelT = net_byte(inst.GUID,"currentlevelT")
	--inst.damagemultiplier = net_byte(inst.GUID,"damagemultiplier")

	if not TheWorld.ismastersim then
        inst:ListenForEvent("currentmana_dirty", function(inst) --只在客户端监听a_dirty事件
            --    inst.currentmana = inst.currentmana:value()         -- 把ThePlayer.net_a的值（注意，需要用value()
                                                    -- 函数获取）赋值给ThePlayer.a 
                                                    --当然，这里你愿意写点别的什么也可以
            end)
    end

end

local function OnDeath(inst)

end

-- This initializes for the server only. Components are added here.
--这仅为服务器初始化。 在这里添加组件。
local master_postinit = function(inst)
	
	inst:AddComponent("reader")

	-- choose which sounds this character will play
	--选择这个角色将播放的声音
	inst.soundsname = "willow"
	
	-- Uncomment if "wathgrithr"(Wigfrid) or "webber" voice is used
    -- 如果使用“wathgrithr”（Wigfrid）或“webber”语音，则取消注释
    --inst.talker_path_override = "dontstarve_DLC001/characters/"
	
	-- Stats	 --统计
	inst.components.health:SetMaxHealth(101)
	inst.components.hunger:SetMax(121)
	inst.components.sanity:SetMax(121)

	inst:AddComponent("mana")
	inst.components.mana.maxmana = 101

	inst:AddComponent("level")
	inst.components.level:SetMaxLevel(30)
	inst.components.level:SetLevelUpFn(OnLevelUp)

	--inst:ListenForEvent("equip", OnEquip)
	--inst:ListenForEvent("gotnewitem", onGotNewItem)
	
	inst.components.locomotor.walkspeed = 6
	inst.components.locomotor.runspeed = 8

	--inst.components.combat:SetAttackPeriod(20)
	inst.components.combat:SetAttackPeriod(TUNING.WILSON_ATTACK_PERIOD)
	
	--inst:ListenForEvent("death", OnDeath)

	inst:ListenForEvent("killed", OnKilled)
	inst:ListenForEvent("onattackother", onattackother)
	--inst:ListenForEvent("blocked", OnDeath) --被攻击
	
	-- Damage multiplier (optional) --伤害乘数（可选）
    --inst.components.combat.damagemultiplier = 0.75 + inst.components.health.Percent
	
	-- Hunger rate (optional) --饥饿率（可选）
	inst.components.hunger.hungerrate = 1 * TUNING.WILSON_HUNGER_RATE
	
	inst.Transform:SetFourFaced() --设置四个面对
	inst.Transform:SetScale(0.8, 0.8, 0.8) --设置比例

	--inst.components.combat.redirectdamagefn = escapecharlie -- function(inst, attacker, damage, weapon, stimuli) print("redirectdamagefn",inst, attacker, damage, weapon, stimuli) return attacker end
	--inst.components.combat.bonusdamagefn = bonusdamagefn(inst)

	inst:ListenForEvent("healthdelta", healthdelta)

	inst.damage = 0
	inst.lastattacttime = 0
	inst.targets = {}

	inst.OnSave = onsave
	inst.OnLoad = onload
    inst.OnNewSpawn = onNewSpawn --新产卵
end 
	
--AddModRPCHandler("TomoeMami", "KeyDownR", UseSkillR)
--AddModRPCHandler("TomoeMami", "KeyDownF1", SkillUpF1)
--AddModRPCHandler("TomoeMami", "KeyDownT", UseSkillT)
--AddModRPCHandler("TomoeMami", "KeyDownF2", SkillUpF2)

--TheInput:AddKeyUpHandler(KEY_R,KeyDownR)
--TheInput:AddKeyUpHandler(KEY_F1,KeyDownF1)
--TheInput:AddKeyUpHandler(KEY_T,KeyDownT)
--TheInput:AddKeyUpHandler(KEY_F2,KeyDownF2)

return MakePlayerCharacter("tomoemami", prefabs, assets, common_postinit, master_postinit, start_inv)
