const { execFile } = require('child_process');
const { app, BrowserWindow, ipcMain, Menu, globalShortcut, clipboard } = require('electron');

let screen = null;

function createWindow() {

    // 创建窗口
    let win = new BrowserWindow({
        width: 1000,
        height: 600,
        maxHeight: 600,
        maxWidth: 1000,
        frame: true,
        maximizable: false,
        webPreferences: {
            nodeIntegration: true,
            webviewTag: true,
        }
    });
    win.webContents.openDevTools()
    // 主线程监听开始截图
    ipcMain.on('start-capture', (event, arg) => {

        // 开始截图
        startCapture(win);
    });

    // 主线程监听窗体主动显示
    ipcMain.on('win-show', () => {

        // 如果剪贴板中有图片
        if (!clipboard.readImage().isEmpty()) {

            // 聚焦窗体
            win.focus();

            // 置顶窗体
            win.setAlwaysOnTop(true, 1);

            // 延迟100ms取消窗体置顶
            setTimeout(() => {
                win.setAlwaysOnTop(false);
            }, 100);
        }
    });

    // 移除窗体菜单
    Menu.setApplicationMenu(null);

    // 打开调试
    // win.webContents.openDevTools()

    // 加载index.html文件
    win.loadFile('index.html');

    // 注册全局截图快捷键
    globalShortcut.register('alt+d', function () {

        // 清空下剪贴板, 防止第一次打开剪贴板中存在图片, 然后会自动识别..
        clipboard.clear();

        // 开始截图
        startCapture(win);
    });

}

/**
 * 开始截图函数
 * 
 * @param {*} win 窗体 
 */
function startCapture(win) {
    
    // 最小化窗体
    win.minimize();

    // 启动截图工具
    screen = execFile(__dirname + '/exe/capture.exe');

    // 监听截图工具退出
    screen.on('exit', () => {

        // 如果剪贴板中有图片
        if (!clipboard.readImage().isEmpty()) {
            // 向渲染进程发送截图成功
            win.webContents.send('capture-success');
        }
    });
}

app.on('ready', createWindow);