PrefabFiles = {
	"mira",
	"mira_none",
	"mirasword",
}

Assets = {
    Asset( "IMAGE", "images/saveslot_portraits/mira.tex" ),
    Asset( "ATLAS", "images/saveslot_portraits/mira.xml" ),

    Asset( "IMAGE", "images/selectscreen_portraits/mira.tex" ),
    Asset( "ATLAS", "images/selectscreen_portraits/mira.xml" ),
	
    Asset( "IMAGE", "images/selectscreen_portraits/mira_silho.tex" ),
    Asset( "ATLAS", "images/selectscreen_portraits/mira_silho.xml" ),

    Asset( "IMAGE", "bigportraits/mira.tex" ),
    Asset( "ATLAS", "bigportraits/mira.xml" ),
	
	Asset( "IMAGE", "images/map_icons/mira.tex" ),
	Asset( "ATLAS", "images/map_icons/mira.xml" ),
	
	Asset( "IMAGE", "images/avatars/avatar_mira.tex" ),
    Asset( "ATLAS", "images/avatars/avatar_mira.xml" ),
	
	Asset( "IMAGE", "images/avatars/avatar_ghost_mira.tex" ),
    Asset( "ATLAS", "images/avatars/avatar_ghost_mira.xml" ),
	
	Asset( "IMAGE", "images/avatars/self_inspect_mira.tex" ),
    Asset( "ATLAS", "images/avatars/self_inspect_mira.xml" ),
	
	Asset( "IMAGE", "images/names_mira.tex" ),
    Asset( "ATLAS", "images/names_mira.xml" ),
	
    Asset( "IMAGE", "bigportraits/mira_none.tex" ),
    Asset( "ATLAS", "bigportraits/mira_none.xml" ),
	
	Asset( "IMAGE", "images/inventoryimages/mirasword.tex"),
	Asset( "ATLAS", "images/inventoryimages/mirasword.xml"),
	



}

local require = GLOBAL.require
local STRINGS = GLOBAL.STRINGS

local interaction_list = {

	"pighouse",
	"skeleton",
	"skeleton_player",

}

for k, v in pairs(interaction_list) do
	AddPrefabPostInit(v,function(inst)
		if GLOBAL.TheWorld.ismastersim then
			inst:AddComponent("interactions")
		end
	end)
end

AddPlayerPostInit(function(inst)
	if GLOBAL.TheWorld.ismastersim then
		inst:AddComponent("interactions")
		inst:DoPeriodicTask(0.25,function()
			if inst.Transform and inst.Transform.GetRotation then
				inst.old_rotation = inst.Transform:GetRotation()
			end
		end)
	end
end)

AddAction("LOOT", "loot (-2)", function(act)
	if act.doer ~= nil and act.target ~= nil and act.doer:HasTag('mirathief') and act.target.components.interactions and act.target.prefab and ((act.target.prefab == "pighouse" and GLOBAL.TheWorld.state.isday) or act.target.prefab == "skeleton" or act.target.prefab == "skeleton_player") then
		act.target.components.interactions:Loot(act.doer)
		return true
	else
		return false
	end
end)

AddComponentAction("SCENE", "interactions", function(inst, doer, actions, right)
	if right then
		if inst.prefab and ((inst.prefab == "pighouse" and GLOBAL.TheWorld.state.isday) or inst.prefab == "skeleton" or inst.prefab == "skeleton_player") then
			table.insert(actions, GLOBAL.ACTIONS.LOOT)
		end
	end
end)

AddStategraphActionHandler("wilson", GLOBAL.ActionHandler(GLOBAL.ACTIONS.LOOT, "dolongaction"))
AddStategraphActionHandler("wilson_client", GLOBAL.ActionHandler(GLOBAL.ACTIONS.LOOT, "dolongaction"))

-- The character select screen lines
STRINGS.CHARACTER_TITLES.mira = "The Mischevious Thief"
STRINGS.CHARACTER_NAMES.mira = "Mira"
STRINGS.CHARACTER_DESCRIPTIONS.mira = "*Perk 1\n*Perk 2\n*Perk 3"
STRINGS.CHARACTER_QUOTES.mira = "\"Quote\""

-- Custom speech strings
STRINGS.CHARACTERS.MIRA = require "speech_mira"

-- The character's name as appears in-game 
STRINGS.NAMES.MIRA = "Mira"

AddMinimapAtlas("images/map_icons/mira.xml")

-- Add mod character to mod character list. Also specify a gender. Possible genders are MALE, FEMALE, ROBOT, NEUTRAL, and PLURAL.
AddModCharacter("mira", "FEMALE")

