local Interactions = Class(function(self, inst)
    self.inst = inst
end)

local loot_chance = 0.25

local loot_cost = 8		
		
	function Interactions:Loot(searcher)
	local islootdropper = self.inst.components.lootdropper
	local isworkable = self.inst.components.workable
	local isspawner = self.inst.components.spawner
	local searchable = islootdropper ~= nil and isworkable ~= nil
	
	if searchable and searcher and searcher:HasTag('mirathief') then
		if self.inst.prefab and self.inst.prefab == "pighouse" and searcher.components.hunger then
			searcher.components.hunger:DoDelta(-loot_cost*loot_chance, nil, false)
		elseif searcher.components.sanity then
			searcher.components.sanity:DoDelta(-loot_cost*loot_chance)
		end
		
		if math.random() < loot_chance then
			if isspawner and isspawner.child ~= nil then
				isspawner.child.needs_home_time = GetTime()
				if isspawner:IsOccupied() then
					isspawner:ReleaseChild()
				end
			end
			
			if self.inst.prefab and (self.inst.prefab == "skeleton" or self.inst.prefab == "skeleton_player") then
				islootdropper:SpawnLootPrefab("goldnugget")
			end
			isworkable:WorkedBy(searcher, 3)
			return
		elseif searcher.components.talker then
			searcher.components.talker:Say("I found nothing.")
		end
	else
		if searcher.components.talker then
			searcher.components.talker:Say("It's empty.")
		end
	end
end

return Interactions