--
-- AutoRepair V1.0.0.0
-- Copyright (C) Bobster82
-- 

autorepair = {};


function autorepair.prerequisitesPresent(specializations)
    return true;
end;


function autorepair:loadMap(name)
	-- Repair flag
	autorepair.repair = true;
end;


function autorepair:update(dt)

	-- Auto repair at midnight.
	if g_currentMission.environment.currentHour == 0 and autorepair.repair then
		for _, vehicle in pairs(g_currentMission.vehicles) do
			if vehicle.ownerFarmId ~= 0 then		
				vehicle:repairVehicle(true);
			end;
		end;
		-- Repair flag to false, only 1 time repairing needed.
		autorepair.repair = false;
	end;

	-- Set the repair flag to true when hour is not 0.
	if g_currentMission.environment.currentHour ~= 0 and not autorepair.repair then
		autorepair.repair = true;
	end;
end;


addModEventListener(autorepair);
