
local MakePlayerCharacter = require "prefabs/player_common"

local assets = {
    Asset("SCRIPT", "scripts/prefabs/player_common.lua"),
}
local prefabs = {}

-- Custom starting items
local start_inv = {
	"sewing_kit",
	"winterhat",
	"umbrella",
	"bedroll_straw",
	"bedroll_straw",
	"bedroll_straw",
	"bedroll_straw",
	"bedroll_straw",
	"bedroll_straw",
	"bedroll_straw",
	"bedroll_straw",
	"bedroll_straw",
	"bedroll_straw",
	"brush",
	"cane",
	"fishingrod", 
	"torch",
}

-- When the character is revived from human
local function onbecamehuman(inst)
	-- Set speed when reviving from ghost (optional)
	inst.components.locomotor:SetExternalSpeedMultiplier(inst, "boy_speed_mod", 1.5)
end

local function onbecameghost(inst)
	-- Remove speed modifier when becoming a ghost
   inst.components.locomotor:RemoveExternalSpeedMultiplier(inst, "boy_speed_mod")
end

-- When loading or spawning the character
local function onload(inst)
    inst:ListenForEvent("ms_respawnedfromghost", onbecamehuman)
    inst:ListenForEvent("ms_becameghost", onbecameghost)

    if inst:HasTag("playerghost") then
        onbecameghost(inst)
    else
        onbecamehuman(inst)
    end
	
end


-- This initializes for both the server and client. Tags can be added here.
local common_postinit = function(inst) 
	-- Minimap icon
	inst.MiniMapEntity:SetIcon( "boy.tex" )
end

-- This initializes for the server only. Components are added here.
local master_postinit = function(inst)
	-- choose which sounds this character will play
	inst.soundsname = "wendy"
	
	-- Uncomment if "wathgrithr"(Wigfrid) or "webber" voice is used
    --inst.talker_path_override = "dontstarve_DLC001/characters/"
	
	-- Stats	
	inst.components.health:SetMaxHealth(150)
	inst.components.hunger:SetMax(100)
	inst.components.sanity:SetMax(250)
	
	-- Damage multiplier (optional)
    inst.components.combat.damagemultiplier = 1
	
	-- Hunger rate (optional)
	inst.components.hunger.hungerrate = 1 * TUNING.WILSON_HUNGER_RATE
	
	inst.OnLoad = onload
    inst.OnNewSpawn = onload
	
	inst:DoTaskInTime(0, function(inst)
	inst.components.builder:AddRecipe("sewing_kit")
	inst:PushEvent("unlockrecipe", { recipe = "sewing_kit" })
end)
	
	inst:DoTaskInTime(0, function(inst)
	inst.components.builder:AddRecipe("slow_farmplot")
	inst:PushEvent("unlockrecipe", { recipe = "slow_farmplot" })
end)

	inst:DoTaskInTime(0, function(inst)
	inst.components.builder:AddRecipe("hammer")
	inst:PushEvent("unlockrecipe", { recipe = "hammer" })
end)

	inst:DoTaskInTime(0, function(inst)
	inst.components.builder:AddRecipe("backpack")
	inst:PushEvent("unlockrecipe", { recipe = "backpack" })
end)

	inst:DoTaskInTime(0, function(inst)
	inst.components.builder:AddRecipe("siestahut")
	inst:PushEvent("unlockrecipe", { recipe = "siestahut" })
end)

	inst:DoTaskInTime(0, function(inst)
	inst.components.builder:AddRecipe("bushhat")
	inst:PushEvent("unlockrecipe", { recipe = "bushhat" })
end)

	inst:DoTaskInTime(0, function(inst)
	inst.components.builder:AddRecipe("beehat")
	inst:PushEvent("unlockrecipe", { recipe = "beehat" })
end)

	inst:DoTaskInTime(0, function(inst)
	inst.components.builder:AddRecipe("tent")
	inst:PushEvent("unlockrecipe", { recipe = "tent" })
end)

	inst:DoTaskInTime(0, function(inst)
	inst.components.builder:AddRecipe("bugnet")
	inst:PushEvent("unlockrecipe", { recipe = "bugnet" })
end)

	inst:DoTaskInTime(0, function(inst)
	inst.components.builder:AddRecipe("cookpot")
	inst:PushEvent("unlockrecipe", { recipe = "cookpot" })
end)

	inst:DoTaskInTime(0, function(inst)
	inst.components.builder:AddRecipe("brush")
	inst:PushEvent("unlockrecipe", { recipe = "brush" })
end)

	inst:DoTaskInTime(0, function(inst)
	inst.components.builder:AddRecipe("winterhat")
	inst:PushEvent("unlockrecipe", { recipe = "winterhat" })
end)

	inst:DoTaskInTime(0, function(inst)
	inst.components.builder:AddRecipe("umbrella")
	inst:PushEvent("unlockrecipe", { recipe = "umbrella" })
end)

	inst:DoTaskInTime(0, function(inst)
	inst.components.builder:AddRecipe("bedroll_straw")
	inst:PushEvent("unlockrecipe", { recipe = "bedroll_straw" })
end)

	inst:DoTaskInTime(0, function(inst)
	inst.components.builder:AddRecipe("cane")
	inst:PushEvent("unlockrecipe", { recipe = "cane" })
end)

	inst:DoTaskInTime(0, function(inst)
	inst.components.builder:AddRecipe("fishingrod")
	inst:PushEvent("unlockrecipe", { recipe = "fishingrod" })
end)
	
	inst:ListenForEvent("onattackother", function(inst, data)
	 if data.target:HasTag("player") then
		inst.components.sanity:DoDelta(-10)
	else
		inst.components.sanity:DoDelta(-5)
	end
end)
	
end

return MakePlayerCharacter("boy", prefabs, assets, common_postinit, master_postinit, start_inv)
