/**
 * @license
 * Visual Blocks Language
 *
 * Copyright 2016 Google Inc.
 * https://developers.google.com/blockly/
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * @fileoverview Translatable string constants for Accessible Blockly.
 * @author madeeha@google.com (Madeeha Ghori)
 */
'use strict';

Blockly.Msg.WORKSPACE = 'Workspace';
Blockly.Msg.WORKSPACE_BLOCK =
    'workspace block. Move right to edit. Press Enter for more options.';

Blockly.Msg.ATTACH_NEW_BLOCK_TO_LINK = 'Attach new block to link...';
Blockly.Msg.CREATE_NEW_BLOCK_GROUP = 'Create new block group...';
Blockly.Msg.ERASE_WORKSPACE = 'Erase Workspace';
Blockly.Msg.NO_BLOCKS_IN_WORKSPACE = 'There are no blocks in the workspace.';

Blockly.Msg.COPY_BLOCK = 'Copy block';
Blockly.Msg.DELETE = 'Delete block';
Blockly.Msg.MARK_SPOT_BEFORE = 'Add link before';
Blockly.Msg.MARK_SPOT_AFTER = 'Add link after';
Blockly.Msg.MARK_THIS_SPOT = 'Add link inside';
Blockly.Msg.MOVE_TO_MARKED_SPOT = 'Move to existing link';
Blockly.Msg.PASTE_AFTER = 'Paste after';
Blockly.Msg.PASTE_BEFORE = 'Paste before';
Blockly.Msg.PASTE_INSIDE = 'Paste inside';

Blockly.Msg.BLOCK_OPTIONS = 'Block Options';
Blockly.Msg.SELECT_A_BLOCK = 'Select a block...';
Blockly.Msg.CANCEL = 'Cancel';

Blockly.Msg.ANY = 'any';
Blockly.Msg.BLOCK = 'block';
Blockly.Msg.BUTTON = 'Button.';
Blockly.Msg.FOR = 'for';
Blockly.Msg.VALUE = 'value';

Blockly.Msg.ADDED_LINK_MSG = 'Added link.';
Blockly.Msg.ATTACHED_BLOCK_TO_LINK_MSG = 'attached to link. ';
Blockly.Msg.COPIED_BLOCK_MSG = 'copied. ';
Blockly.Msg.PASTED_BLOCK_FROM_CLIPBOARD_MSG = 'pasted. ';

Blockly.Msg.PRESS_ENTER_TO_EDIT_NUMBER = 'Press Enter to edit number. ';
Blockly.Msg.PRESS_ENTER_TO_EDIT_TEXT = 'Press Enter to edit text. ';
