'use strict';

goog.provide('Blockly.Blocks.sensors');  // Deprecated
goog.provide('Blockly.Constants.Sensors');  // deprecated, 2019 April 5

goog.require('Blockly.Blocks');
goog.require('Blockly');




//��������

//ϵͳ��Դ
Blockly.Blocks['gettouch'] = {
    init: function () {
        this.appendDummyInput()
            .appendField("Touch sensor")
            .appendField(new Blockly.FieldDropdown([["Port5", "4"], ["Port6", "3"], ["Port7", "2"], ["Port8", "1"]]), "port");
        this.setOutput(true, null);
        this.setColour(100);
        this.setTooltip("");
        this.setHelpUrl("");
    }
};
Blockly.Blocks['getgcc'] = {
    init: function () {
        this.appendValueInput("NAME")
            .setCheck(null)
            .appendField("Seperation of")
            .appendField(new Blockly.FieldDropdown([["x-axis", "acc_x"], ["y-axis", "acc_y"], ["z-axis", "acc_z"]]), "acc")
            .appendField("acceleration");
        this.setOutput(true, null);
        this.setColour(100);
        this.setTooltip("");
        this.setHelpUrl("");
    }
};

Blockly.Blocks['detectmove'] = {
    init: function () {
        this.appendDummyInput()
            .appendField("gyroscope")
            .appendField(new Blockly.FieldDropdown([["Port5", "4"], ["Port6", "3"]]), "in")
            .appendField("detect movement");
        this.setInputsInline(true);
        this.setOutput(true, null);
        this.setColour(100);
        this.setTooltip("");
        this.setHelpUrl("");
    }
};
Blockly.Blocks['startstopcounting'] = {
    init: function () {
        this.appendDummyInput()
            .appendField("gyroscope")
            .appendField(new Blockly.FieldDropdown([["Port5", "4"], ["Port7", "3"]]), "in")
            .appendField("counting steps")
            .appendField(new Blockly.FieldDropdown([["start", "3"], ["stop", "5"]]), "functions");
        this.setPreviousStatement(true, null);
        this.setNextStatement(true, null);
        this.setColour(100);
        this.setTooltip("");
        this.setHelpUrl("");
    }
};
Blockly.Blocks['obtainsteps'] = {
    init: function () {
        this.appendDummyInput()
            .appendField("gyroscope")
            .appendField(new Blockly.FieldDropdown([["Port5", "4"], ["Port6", "3"]]), "in")
            .appendField("obtain steps");
        this.setOutput(true, null);
        this.setColour(100);
        this.setTooltip("");
        this.setHelpUrl("");
    }
};

Blockly.Blocks['getaccelerate'] = {
    init: function () {
        this.appendDummyInput()
            .appendField("gyroscope")
            .appendField(new Blockly.FieldDropdown([["Port5", "4"], ["Port6", "3"]]), "in")
            .appendField("get acceleration")
            .appendField(new Blockly.FieldDropdown([["x-axis", "x_value"], ["y-axis", "y_value"], ["z-axis", "z_value"], ["x&y&z", "acc_xyz"]]), "get_value")
            .appendField("value");
        this.setInputsInline(true);
        this.setOutput(true, null);
        this.setColour(100);
        this.setTooltip("");
        this.setHelpUrl("");
    }
};

//�¼�
Blockly.defineBlocksWithJsonArray([
    {
        "type": "list",
        "message0": "[ %1 ]",
        "args0": [
            {
                "type": "field_input",
                "name": "DATA",
                "text": "\"MRT\","
            }
        ],
        "inputsInline": true,
        "output": null,
        "colour": 300,
        "tooltip": "",
        "helpUrl": ""
    },
    {
        "type": "set",
        "message0": "{ %1 }",
        "args0": [
            {
                "type": "field_input",
                "name": "DATA",
                "text": "\"MRT\","
            }
        ],
        "inputsInline": true,
        "output": null,
        "colour": 350,
        "tooltip": "",
        "helpUrl": ""
    },
    {
        "type": "nnn",
        "message0": "( %1 )",
        "args0": [
            {
                "type": "field_input",
                "name": "DATA",
                "text": "\"MRT\","
            }
        ],
        "inputsInline": true,
        "output": null,
        "colour": 300,
        "tooltip": "",
        "helpUrl": ""
    },
    {
        "type": "string",
        "message0": "\" %1 \"",
        "args0": [
            {
                "type": "field_input",
                "name": "DATA",
                "text": "MRT"
            }
        ],
        "inputsInline": true,
        "output": null,
        "colour": 300,
        "tooltip": "",
        "helpUrl": ""
    },
    {
        "type": "newdefine_tuple",
        "message0": "define tuple %1 = %2",
        "args0": [
            {
                "type": "field_variable",
                "name": "NAME1",
                "variable": "my_tuple",
            },
            {
                "type": "input_value",
                "name": "NAME2",
            }
        ],
        "inputsInline": true,
        "previousStatement": null,
        "nextStatement": null,
        "colour": 300,
        "tooltip": "",
        "helpUrl": ""
    },
    {
        "type": "sleep",
        "message0": "%{BKY_WAITING} %1 %{BKY_SECONDS}",
        "args0": [
            {
                "type": "input_value",
                "name": "NAME",
                "check": "Number"
            }
        ],
        "inputsInline": true,
        "previousStatement": null,
        "nextStatement": null,
        "colour": 120,
        "tooltip": "",
        "helpUrl": ""
    },
    {
        "type": "event_colorsensor",
        "message0": "%{BKY_CONTROLS_IF_MSG_IF} %1 %{BKY_COLOR_SENSOR_DETECT} %2 %3 %{BKY_CONTROLS_REPEAT_INPUT_DO} %4",
        "args0":[
            {
                "type": "field_dropdown",
                "name": "port",
                "options": [
                    [
                        "Port5", "4"
                    ],
                    [
                        "Port6", "3"
                    ]
                ]
            },
            {
                "type": "field_dropdown",
                "name": "colorsensor",
                "options": [
                    [
                        "%{BKY_COLOUR_RGB_RED}", "1"
                    ],
                    [
                        "%{BKY_COLOUR_RGB_GREEN}", "2"
                    ],
                    [
                        "%{BKY_COLOUR_RGB_BLUE}", "3"
                    ]
                ]
            },
            {
                "type": "input_dummy"
            },
            {
                "type": "input_statement",
                "name": "NAME"
            }
        ],
        "previousStatement": null,
        "nextStatement": null,
        "colour": 150,
        "tooltip": "",
        "helpUrl": ""
    },
    {
        "type": "event_irsensor",
        "message0": "%{BKY_CONTROLS_IF_MSG_IF} %1 %{BKY_IRSENSOR_DEC_OBJ} %2 %{BKY_CONTROLS_REPEAT_INPUT_DO} %3",
        "args0": [
            {
                "type": "field_dropdown",
                "name": "port",
                "options": [
                    [
                        "Port5",
                        "4"
                    ],
                    [
                        "Port6",
                        "3"
                    ],
                    [
                        "Port7",
                        "2"
                    ],
                    [
                        "Port8",
                        "1"
                    ]
                ]
            },
            {
                "type": "input_dummy"
            },
            {
                "type": "input_statement",
                "name": "NAME"
            }
        ],
        "previousStatement": null,
        "nextStatement": null,
        "colour": 150,
        "tooltip": "",
        "helpUrl": ""
    },

    {
        "type": "event_irsensor1",
        "message0": "%{BKY_CONTROLS_IF_MSG_IF} %1 %{BKY_IRSENSOR_DEC_OBJ} %2 %{BKY_CONTROLS_REPEAT_INPUT_DO} %3  %{BKY_CONTROLS_IF_MSG_ELSE} %4",
        "args0": [
            {
              "type": "field_dropdown",
              "name": "Port",
              "options": [
                [
                  "Port5",
                  "4"
                ],
                [
                  "Port6",
                  "3"
                ],
                [
                  "Port7",
                  "2"
                ],
                [
                  "Port8",
                  "1"
                ]
              ]
            },
            {
              "type": "input_dummy"
            },
            {
              "type": "input_statement",
              "name": "NAME1"
            },
            {
              "type": "input_statement",
              "name": "NAME2"
            }
          ],
          "previousStatement": null,
          "nextStatement": null,
          "colour": 150,
          "tooltip": "如果..否则",
          "helpUrl": ""
        },
    {
        "type": "event_touchsensor",
        "message0": "%{BKY_CONTROLS_IF_MSG_IF} %1 %{BKY_TOU_SENSOR_PRESSED} %2 %{BKY_CONTROLS_REPEAT_INPUT_DO} %3 ",
        "args0": [
            {
                "type": "field_dropdown",
                "name": "Port",
                "options": [
                    [
                        "Port5",
                        "4"
                    ],
                    [
                        "Port6",
                        "3"
                    ],
                    [
                        "Port7",
                        "2"
                    ],
                    [
                        "Port8",
                        "1"
                    ]
                ]
            },
            {
                "type": "input_dummy"
            },
            {
                "type": "input_statement",
                "name": "NAME"
            }
        ],
        "previousStatement": null,
        "nextStatement": null,
        "colour": 150,
        "tooltip": "",
        "helpUrl": ""
    },

      {
        "type": "event_touchsensor1",
        "message0": "%{BKY_CONTROLS_IF_MSG_IF} %1 %{BKY_TOU_SENSOR} %2 %3 %{BKY_CONTROLS_REPEAT_INPUT_DO} %4 %{BKY_CONTROLS_IF_MSG_ELSE} %5",
        "args0": [
          {
            "type": "field_dropdown",
            "name": "Port",
            "options": [
              [
                "Port5",
                "4"
              ],
              [
                "Port6",
                "3"
              ],
              [
                "Port7",
                "2"
              ],
              [
                "Port8",
                "1"
              ]
            ]
          },
          {
            "type": "field_dropdown",
            "name": "mode",
            "options": [
              [
                "ON",
                "1"
              ],
              [
                "OFF",
                "0"
              ]
            ]
          },
          {
            "type": "input_dummy"
          },
          {
            "type": "input_statement",
            "name": "NAME1"
          },
          {
            "type": "input_statement",
            "name": "NAME2"
          }
        ],
        "previousStatement": null,
        "nextStatement": null,
        "colour": 150,
        "tooltip": "",
        "helpUrl": "http://www.handuankeji.com/download.html"
      },

    {
        "type": "event_rainsensor",
        "message0": "%{BKY_CONTROLS_IF_MSG_IF} %1 %{BKY_RAIN_SENSOR_DETECTS_RAIN} %2 %{BKY_CONTROLS_REPEAT_INPUT_DO} %3",
        "args0": [
            {
                "type": "field_dropdown",
                "name": "port",
                "options": [
                    [
                        "Port5",
                        "4"
                    ],
                    [
                        "Port6",
                        "3"
                    ],
                    [
                        "Port7",
                        "2"
                    ],
                    [
                        "Port8",
                        "1"
                    ]
                ]
            },
            {
                "type": "input_dummy"
            },
            {
                "type": "input_statement",
                "name": "NAME"
            }
        ],
        "previousStatement": null,
        "nextStatement": null,
        "colour": 150,
        "tooltip": "",
        "helpUrl": "http://www.handuankeji.com/download.html"
    },
    {
        "type": "event_gyroscope",
        "message0": "%{BKY_CONTROLS_IF_MSG_IF} %1 %{BKY_ACC_SENSOR_DETECTS_MOVEMENT} %2 %{BKY_CONTROLS_REPEAT_INPUT_DO} %3",
        "args0": [
            {
                "type": "field_dropdown",
                "name": "port",
                "options": [
                    [
                        "Port5",
                        "4"
                    ],
                    [
                        "Port6",
                        "3"
                    ]
                ]
            },
            {
                "type": "input_dummy"
            },
            {
                "type": "input_statement",
                "name": "NAME"
            }
        ],
        "previousStatement": null,
        "nextStatement": null,
        "colour": 150,
        "tooltip": "",
        "helpUrl": ""
    },
    {
        "type": "event_gassensor",
        "message0": "%{BKY_CONTROLS_IF_MSG_IF} %1 %{BKY_GAS_SENSOR_DETECTS_COM_GAS} %2 %{BKY_CONTROLS_REPEAT_INPUT_DO} %3",
        "args0": [
            {
                "type": "field_dropdown",
                "name": "port",
                "options": [
                    [
                        "Port5",
                        "4"
                    ],
                    [
                        "Port6",
                        "3"
                    ],
                    [
                        "Port7",
                        "2"
                    ],
                    [
                        "Port8",
                        "1"
                    ]
                ]
            },
            {
                "type": "input_dummy"
            },
            {
                "type": "input_statement",
                "name": "NAME"
            }
        ],
        "previousStatement": null,
        "nextStatement": null,
        "colour": 150,
        "tooltip": "",
        "helpUrl": ""
    },
    {
        "type": "event_remote",
        "message0": "%{BKY_CONTROLS_IF_MSG_IF} %{BKY_REMOTE}  %1 %{BKY_IS_PRESSED} %2 %{BKY_CONTROLS_REPEAT_INPUT_DO} %3",
        "args0": [
            {
                "type": "field_dropdown",
                "name": "direction",
                "options": [
                    [
                        "%{BKY_KEYOFF}",
                        "10"
                    ],
                    [
                        "%{BKY_UP}",
                        "19"
                    ],
                    [
                        "%{BKY_DOWN}",
                        "1"
                    ],
                    [
                        "%{BKY_LEFT}",
                        "0"
                    ],
                    [
                        "%{BKY_RIGHT}",
                        "2"
                    ],
                    [
                        "F1",
                        "13"
                    ],
                    [
                        "F2",
                        "28"
                    ],
                    [
                        "F3",
                        "11"
                    ],
                    [
                        "F4",
                        "26"
                    ],
                    [
                        "F5",
                        "25"
                    ],
                    [
                        "F6",
                        "8"
                    ],
                    [
                        "%{BKY_UP_LEFT}",
                        "9"
                    ],
                    [
                        "%{BKY_UP_RIGHT}",
                        "3"
                    ],
                    [
                        "%{BKY_DOWN_LEFT}",
                        "12"
                    ],
                    [
                        "%{BKY_DOWN_RIGHT}",
                        "6"
                    ],
                ]
            },
            {
                "type": "input_dummy"
            },
            {
                "type": "input_statement",
                "name": "NAME"
            }
        ],
        "previousStatement": null,
        "nextStatement": null,
        "colour": 150,
        "tooltip": "",
        "helpUrl": ""
    },
    //颜色
    {
        "type": "sensor_color",
        "message0": "%1 %{BKY_COLOR_SENSOR_DETECTS_COLOR}",
        "args0": [
            {
                "type": "field_image",
                "src": "../../images/color.png",
                "width": 37,
                "height": 37,
                "alt": "*",
                "flipRtl": false
            },
            {
                "type": "field_dropdown",
                "name": "port",
                "options": [
                    [
                        "Port5",
                        "4"
                    ],
                    [
                        "Port6",
                        "3"
                    ]
                ]
            }
        ],
        "output": null,
        "colour": 250,
        "tooltip": "",
        "helpUrl": ""
    },
    {
        "type": "sensor_ir",
        "message0": "%1 %{BKY_IR_SENSOR_DETECTS_OBSTACLE}",
        "args0": [
            {
                "type": "field_image",
                "src": "../../images/ir.png",
                "width": 48,
                "height": 37,
                "alt": "*",
                "flipRtl": false
            },
            {
                "type": "field_dropdown",
                "name": "port",
                "options": [
                    [
                        "Port5",
                        "4"
                    ],
                    [
                        "Port6",
                        "3"
                    ],
                    [
                        "Port7",
                        "2"
                    ],
                    [
                        "Port8",
                        "1"
                    ]
                ]
            }
        ],
        "output": null,
        "colour": 250,
        "tooltip": "",
        "helpUrl": ""
    },
    {
        "type": "sensor_button",
        "message0": "%1 %{BKY_BUTTON_IS} %3",
        "args0": [
            {
                "type": "field_image",
                "src": "../../images/button.png",
                "width": 43,
                "height": 37,
                "alt": "*",
                "flipRtl": false
            },
            {
                "type": "field_dropdown",
                "name": "Port",
                "options": [
                    [
                        "Port5",
                        "4"
                    ],
                    [
                        "Port6",
                        "3"
                    ],
                    [
                        "Port7",
                        "2"
                    ],
                    [
                        "Port8",
                        "1"
                    ]
                ]
            },
            {
                "type": "field_dropdown",
                "name": "NAME",
                "options": [
                    [
                        "%{BKY_PRESSED}",
                        "1"
                    ],
                    [
                        "%{BKY_RELEASED}",
                        "0"
                    ]
                ]
            }
        ],
        "output": null,
        "colour": 250,
        "tooltip": "",
        "helpUrl": ""
    },
    {
        "type": "sensor_rain",
        "message0": "%1 %{BKY_RAIN_SENSOR_DETECTS_RAIN_STATE}",
        "args0": [
            {
                "type": "field_image",
                "src": "../../images/water.png",
                "width": 47,
                "height": 37,
                "alt": "*",
                "flipRtl": false
            },
            {
                "type": "field_dropdown",
                "name": "port",
                "options": [
                    [
                        "Port5",
                        "4"
                    ],
                    [
                        "Port6",
                        "3"
                    ],
                    [
                        "Port7",
                        "2"
                    ],
                    [
                        "Port8",
                        "1"
                    ]
                ]
            }
        ],
        "output": null,
        "colour": 250,
        "tooltip": "",
        "helpUrl": ""
    },
    {
    "type": "calibration",
        "message0": "%1 %{BKY_ACC_SENSOR_CALIBRATION}",
        "args0": [
            {
                "type": "field_image",
                "src": "../../images/acc.png",
                "width": 47,
                "height": 37,
                "alt": "*",
                "flipRtl": false
            },
            {
                "type": "field_dropdown",
                "name": "in",
                "options": [
                    [
                        "Port5",
                        "4"
                    ],
                    [
                        "Port6",
                        "3"
                    ]
                ]
            }
        ],
        "previousStatement": null,
        "nextStatement": null,
        "colour": 250,
        "tooltip": "",
        "helpUrl": ""
    },
    {
        "type": "sensor_acc",
        "message0": "%1 %{BKY_ACC_SENSOR_MOTION_STATE}",
        "args0": [
            {
                "type": "field_image",
                "src": "../../images/acc.png",
                "width": 47,
                "height": 37,
                "alt": "*",
                "flipRtl": false
            },
            {
                "type": "field_dropdown",
                "name": "port",
                "options": [
                    [
                        "Port5",
                        "4"
                    ],
                    [
                        "Port6",
                        "3"
                    ]
                ]
            }
        ],
        "output": null,
        "colour": 250,
        "tooltip": "",
        "helpUrl": ""
    },
    {
        "type": "sensor_gas",
        "message0": "%1 %{BKY_GAS_SENSOR}",
        "args0": [
            {
                "type": "field_image",
                "src": "../../images/gas.png",
                "width": 47,
                "height": 37,
                "alt": "*",
                "flipRtl": false
            },
            {
                "type": "field_dropdown",
                "name": "port",
                "options": [
                    [
                        "Port5",
                        "4"
                    ],
                    [
                        "Port6",
                        "3"
                    ],
                    [
                        "Port7",
                        "2"
                    ],
                    [
                        "Port8",
                        "1"
                    ]
                ]
            }
        ],
        "output": null,
        "colour": 250,
        "tooltip": "",
        "helpUrl": ""
    },
    {
        "type": "sensor_ultrasonic",
        "message0": "%1 %{BKY_ULTRASONIC_SENSOR_DISTANCE}",
        "args0": [
            {
                "type": "field_image",
                "src": "../../images/ultrasonic.png",
                "width": 47,
                "height": 37,
                "alt": "*",
                "flipRtl": false
            },
            {
                "type": "field_dropdown",
                "name": "port",
                "options": [
                    [
                        "Port5",
                        "4"
                    ],
                    [
                        "Port6",
                        "3"
                    ],
                    [
                        "Port7",
                        "2"
                    ],
                    [
                        "Port8",
                        "1"
                    ]
                ]
            }
        ],
        "output": null,
        "colour": 250,
        "tooltip": "",
        "helpUrl": ""
    },
    {
        "type": "sensor_cds",
        "message0": "%1 %{BKY_CDS_DETECTS_INTENSITY}",
        "args0": [
            {
                "type": "field_image",
                "src": "../../images/photosen.png",
                "width": 47,
                "height": 37,
                "alt": "*",
                "flipRtl": false
            },
            {
                "type": "field_dropdown",
                "name": "port",
                "options": [
                    [
                        "Port5",
                        "4"
                    ],
                    [
                        "Port6",
                        "3"
                    ],
                    [
                        "Port7",
                        "2"
                    ],
                    [
                        "Port8",
                        "1"
                    ]
                ]
            }
        ],
        "output": null,
        "colour": 250,
        "tooltip": "",
        "helpUrl": ""
    },
    {
        "type": "sensor_steps",
        "message0": "%1 %{BKY_PEDOMETER_OBTAINS_THE_STEPS}",
        "args0": [
            {
                "type": "field_image",
                "src": "../../images/acc.png",
                "width": 47,
                "height": 37,
                "alt": "*",
                "flipRtl": false
            },
            {
                "type": "field_dropdown",
                "name": "port",
                "options": [
                    [
                        "Port5",
                        "4"
                    ],
                    [
                        "Port6",
                        "3"
                    ]
                ]
            }
        ],
        "output": null,
        "colour": 250,
        "tooltip": "",
        "helpUrl": ""
    },
    {
        "type": "sensor_temperaturehumidity",
        "message0": "%1 %{BKY_TEM_A_HUM_GETS} %3",
        "args0": [
            {
                "type": "field_image",
                "src": "../../images/environment.png",
                "width": 47,
                "height": 37,
                "alt": "*",
                "flipRtl": false
            },
            {
                "type": "field_dropdown",
                "name": "in",
                "options": [
                    [
                        "Port5",
                        "4"
                    ],
                    [
                        "Port6",
                        "3"
                    ]
                ]
            },
            {
                "type": "field_dropdown",
                "name": "functions",
                "options": [
                    [
                        "%{BKY_TEM}",
                        "getAirTemperature"
                    ],
                    [
                        "%{BKY_HUM}",
                        "getAirHumidity"
                    ]
                ]
            }
        ],
        "output": null,
        "colour": 250,
        "tooltip": "",
        "helpUrl": ""
    },
    {
        "type": "getsoilhumidity",
        "message0": "%1 %{BKY_SOIL_HUM_GETS}",
        "args0": [
            {
                "type": "field_image",
                "src": "../../images/soilhumidity.png",
                "width": 47,
                "height": 37,
                "alt": "*",
                "flipRtl": false
            },
            {
                "type": "field_dropdown",
                "name": "in",
                "options": [
                    [
                        "Port5",
                        "4"
                    ],
                    [
                        "Port6",
                        "3"
                    ],
                    [
                        "Port7",
                        "2"
                    ],
                    [
                        "Port8",
                        "1"
                    ]
                ]
            }
        ],
        "inputsInline": true,
        "output": null,
        "colour": 250,
        "tooltip": "",
        "helpUrl": ""
    },
    {
        "type": "getsoiltemperature",
        "message0": "%1 %2 %{BKY_SOIL_TEM_GETS} ",
        "args0": [
            {
                "type": "field_image",
                "src": "../../images/soilenvir.png",
                "width": 47,
                "height": 37,
                "alt": "*",
                "flipRtl": false
            },
            {
                "type": "field_dropdown",
                "name": "in",
                "options": [
                    [
                        "Port5",
                        "4"
                    ],
                    [
                        "Port6",
                        "3"
                    ],
                    [
                        "Port7",
                        "2"
                    ],
                    [
                        "Port8",
                        "1"
                    ]
                ]
            }
        ],
        "output": null,
        "colour": 250,
        "tooltip": "",
        "helpUrl": ""
    },
    {
        "type": "setpump",
        "message0": "%1 %{BKY_SET} %2 %{BKY_PUMP_FLOW_RATE} %3",
        "args0": [
            {
                "type": "field_image",
                "src": "../../images/pump.png",
                "width": 47,
                "height": 37,
                "alt": "*",
                "flipRtl": false
            },
            {
                "type": "field_dropdown",
                "name": "in",
                "options": [
                    [
                        "Port1",
                        "1"
                    ],
                    [
                        "Port2",
                        "2"
                    ],
                    [
                        "Port3",
                        "3"
                    ],
                    [
                        "Port4",
                        "4"
                    ]
                ]
            },
            {
                "type": "field_dropdown",
                "name": "status",
                "options": [
                    [
                        "%{BKY_CLOSE}",
                        "0"
                    ],
                    [
                        "%{BKY_FAST}",
                        "1"
                    ],
                
                    [
                        "%{BKY_SLOW}",
                        "2"
                    ]
                ]
            }
        ],
        "previousStatement": null,
        "nextStatement": null,
        "colour": 250,
        "tooltip": "",
        "helpUrl": ""
    },
    {
        "type": "rgbstr",
        "message0": "%{BKY_LED_STR}",
        "args0": [
            {
                "type": "field_dropdown",
                "name": "out",
                "options": [
                    [
                        "Port1",
                        "1"
                    ],
                    [
                        "Port2",
                        "2"
                    ],
                    [
                        "Port3",
                        "3"
                    ],
                    [
                        "Port4",
                        "4"
                    ]
                ]
            },
            {
                "type": "input_dummy",
                "align": "CENTRE"
            },
            {
                "type": "input_value",
                "name": "Red",
                "check": "Colour",
                "align": "RIGHT"
            }
        ],
        "inputsInline": true,
        "previousStatement": null,
        "nextStatement": null,
        "colour": 250,
        "tooltip": "",
        "helpUrl": ""
    },
    {
        "type": "rgbled",
        "message0": "%1 %{BKY_LED_LAMP} %2 %3 %{BKY_SET_LED_PAR} %{BKY_COLOUR_RGB_RED}%4 %{BKY_COLOUR_RGB_GREEN} %5 %{BKY_COLOUR_RGB_BLUE} %6",
        "args0": [
            {
                "type": "field_image",
                "src": "../../images/led.png",
                "width": 47,
                "height": 37,
                "alt": "*",
                "flipRtl": false
            },
            {
                "type": "field_dropdown",
                "name": "out",
                "options": [
                    [
                        "Port1",
                        "1"
                    ],
                    [
                        "Port2",
                        "2"
                    ],
                    [
                        "Port3",
                        "3"
                    ],
                    [
                        "Port4",
                        "4"
                    ]
                ]
            },
            {
                "type": "input_dummy",
                "align": "CENTRE"
            },
            {
                "type": "input_value",
                "name": "Red",
                "check": "Number",
                "align": "RIGHT"
            },
            {
                "type": "input_value",
                "name": "Green",
                "check": "Number",
                "align": "RIGHT"
            },
            {
                "type": "input_value",
                "name": "Blue",
                "check": "Number",
                "align": "RIGHT"
            }
        ],
        "inputsInline": false,
        "previousStatement": null,
        "nextStatement": null,
        "colour": 250,
        "tooltip": "RGB的范围取值为0-255",
        "helpUrl": ""
    },
    {
        "type": "sensor_remote",
        "message0": "%1 %{BKY_REMOTE_SENSOR_PRESSED} %2",
        "args0": [
            {
                "type": "field_image",
                "src": "../../images/remote.png",
                "width": 45,
                "height": 37,
                "alt": "*",
                "flipRtl": false
            },
            {
                "type": "field_dropdown",
                "name": "port",
                "options": [
                    [
                        "%{BKY_KEYOFF}",
                        "10"
                    ],
                    [
                        "%{BKY_UP}",
                        "19"
                    ],
                    [
                        "%{BKY_DOWN}",
                        "1"
                    ],
                    [
                        "%{BKY_LEFT}",
                        "0"
                    ],
                    [
                        "%{BKY_RIGHT}",
                        "2"
                    ],
                    [
                        "F1",
                        "13"
                    ],
                    [
                        "F2",
                        "28"
                    ],
                    [
                        "F3",
                        "11"
                    ],
                    [
                        "F4",
                        "26"
                    ],
                    [
                        "F5",
                        "25"
                    ],
                    [
                        "F6",
                        "8"
                    ],
                    [
                        "%{BKY_UP_LEFT}",
                        "9"
                    ],
                    [
                        "%{BKY_UP_RIGHT}",
                        "3"
                    ],
                    [
                        "%{BKY_DOWN_LEFT}",
                        "12"
                    ],
                    [
                        "%{BKY_DOWN_RIGHT}",
                        "6"
                    ],
                ]
            }
        ],
        "output": null,
        "colour": 250,
        "tooltip": "",
        "helpUrl": ""
    },
    {
        "type": "sensor_optionled",
        "message0": "%1 %{BKY_SET} %2 %3 LED %{BKY_LAMP}",
        "args0": [
            {
                "type": "field_image",
                "src": "../../images/led.png",
                "width": 47,
                "height": 37,
                "alt": "*",
                "flipRtl": false
            },
            {
                "type": "field_dropdown",
                "name": "port",
                "options": [
                    [
                        "Port1",
                        "1"
                    ],
                    [
                        "Port2",
                        "2"
                    ],
                    [
                        "Port3",
                        "3"
                    ],
                    [
                        "Port4",
                        "4"
                    ]
                ]
            },
            {
                "type": "field_dropdown",
                "name": "switch",
                "options": [
                    [
                        "%{BKY_OPEN}",
                        "200"
                    ],
                    [
                        "%{BKY_CLOSEE}",
                        "0"
                    ]
                ]
            }
        ],
        "previousStatement": null,
        "nextStatement": null,
        "colour": 250,
        "tooltip": "",
        "helpUrl": ""
     },
     {
        "type": "sensor_motorcolor",
        "message0": "%1 %{BKY_SET} %2 %3 %{BKY_STEER_COLOR} %4 R %5 G %6 B %7",
        "args0": [
            {
                "type": "field_image",
                "src": "../../images/digitmotor.png",
                "width": 47,
                "height": 37,
                "alt": "*",
                "flipRtl": false
            },
            {
                "type": "field_dropdown",
                "name": "port",
                "options": [
                    [
                        "Port1",
                        "1"
                    ],
                    [
                        "Port2",
                        "2"
                    ],
                    [
                        "Port3",
                        "3"
                    ],
                    [
                        "Port4",
                        "4"
                    ]
                ]
            },
            {
                "type": "field_dropdown",
                "name": "number",
                "options": [
                    [
                        " %{BKY_NUMBER_1}",
                        "1"
                    ],
                    [
                        "%{BKY_NUMBER_2}",
                        "2"
                    ]
                ]
            },
            {
                "type": "input_dummy"
            },
            {
                "type": "input_value",
                "name": "Red",
                "check": "Number",
                "align": "RIGHT"
            },
            {
                "type": "input_value",
                "name": "Green",
                "check": "Number",
                "align": "RIGHT"
            },
            {
                "type": "input_value",
                "name": "Blue",
                "check": "Number",
                "align": "RIGHT"
            }
        ],
        "inputsInline": true,
        "previousStatement": null,
        "nextStatement": null,
        "colour": 250,
        "tooltip": "",
        "helpUrl": ""
    },
    {
        "type": "sensor_motorangle",
        "message0": "%1 %{BKY_SET} %2 %3 %4 %{BKY_STEER_ANGLE} %5",
        "args0": [
            {
                "type": "field_image",
                "src": "../../images/digitmotor.png",
                "width": 47,
                "height": 37,
                "alt": "*",
                "flipRtl": false
            },
            {
                "type": "field_dropdown",
                "name": "port",
                "options": [
                    [
                        "Port1",
                        "1"
                    ],
                    [
                        "Port2",
                        "2"
                    ],
                    [
                        "Port3",
                        "3"
                    ],
                    [
                        "Port4",
                        "4"
                    ]
                ]
            },
            {
                "type": "field_dropdown",
                "name": "number",
                "options": [
                    [
                        "%{BKY_NUMBER_1}",
                        "1"
                    ],
                    [
                        "%{BKY_NUMBER_3}",
                        "3"
                    ]
                ]
            },
            {
                "type": "input_dummy"
            },
            {
                "type": "input_value",
                "name": "angle",
                "check": "Number",
                "align": "RIGHT"
            }
        ],
        "inputsInline": true,
        "previousStatement": null,
        "nextStatement": null,
        "colour": 250,
        "tooltip": "",
        "helpUrl": ""
    }
]);


//��ʾ
Blockly.defineBlocksWithJsonArray([
        
    {
        "type": "showpicture",
        "message0": "%1 %{BKY_SHOW_PICTURE} %2",
        "args0": [
            {
                "type": "field_image",
                "src": "../../images/show.png",
                "width": 47,
                "height": 37,
                "alt": "*",
                "flipRtl": false
            },
            {
                "type": "input_value",
                "name": "picture number",
                "value": 0,
                "min": 0,
                "max": 9
                 
            }
        ],
        "inputsInline": true,
        "previousStatement": null,
        "nextStatement": null,
        "colour": 300,
        "tooltip": "",
        "helpUrl": ""
    },
    {
        "type": "show_oled",
        "message0": "%1 OLED %{BKY_CLEAR}",
        "args0": [
            {
                "type": "field_image",
                "src": "../../images/show.png",
                "width": 47,
                "height": 37,
                "alt": "*",
                "flipRtl": false
            }
        ],
        "previousStatement": null,
        "nextStatement": null,
        "colour": 300,
        "tooltip": "",
        "helpUrl": ""
    },
    {
        "type": "show_line",
        "message0": "%1 %{BKY_OLED_LINE} %2 %{BKY_SHOW} %3",
        "args0": [
            {
                "type": "field_image",
                "src": "../../images/show.png",
                "width": 47,
                "height": 37,
                "alt": "*",
                "flipRtl": false
            },
            {
                "type": "input_value",
                "name": "NAME 1"
            },
            {
                "type": "input_value",
                "name": "NAME 2"
            }
        ],
        "inputsInline": true,
        "previousStatement": null,
        "nextStatement": null,
        "colour": 300,
        "tooltip": "",
        "helpUrl": ""
    },
    {
        "type": "show_clearline",
        "message0": "%{BKY_OLED_CLEAR_LINE}",
        "args0": [
            {
                "type": "field_image",
                "src": "../../images/show.png",
                "width": 47,
                "height": 37,
                "alt": "*",
                "flipRtl": false
            },
            {
                "type": "input_value",
                "name": "NAME"
            }
        ],
        "inputsInline": true,
        "previousStatement": null,
        "nextStatement": null,
        "colour": 300,
        "tooltip": "",
        "helpUrl": ""
    },
    {
        "type": "show_text",
        "message0": "%{BKY_DISPLAY_TEXT_XY}",
        "args0": [
            {
                "type": "field_image",
                "src": "../../images/show.png",
                "width": 47,
                "height": 37,
                "alt": "*",
                "flipRtl": false
            },
            {
                "type": "input_value",
                "name": "NAME 1"
            },
            {
                "type": "input_value",
                "name": "NAME 2"
            },
            {
                "type": "input_value",
                "name": "NAME 3"
            }
        ],
        "inputsInline": true,
        "previousStatement": null,
        "nextStatement": null,
        "colour": 300,
        "tooltip": "",
        "helpUrl": ""
    },
    {
        "type": "show_data",
        "message0": "%{BKY_DISPLAY_DATA}",
        "args0": [
            {
                "type": "field_image",
                "src": "../../images/show.png",
                "width": 47,
                "height": 37,
                "alt": "*",
                "flipRtl": false
            },
            {
                "type": "input_value",
                "name": "NAME 1"
            },
            {
                "type": "input_value",
                "name": "NAME 2"
            },
            {
                "type": "input_value",
                "name": "NAME 3"
            }
        ],
        "inputsInline": true,
        "previousStatement": null,
        "nextStatement": null,
        "colour": 300,
        "tooltip": "",
        "helpUrl": ""
    },
    {
        "type": "show_point",
        "message0": "%{BKY_SHOW_POINT}",
        "args0": [
            {
                "type": "field_image",
                "src": "../../images/show.png",
                "width": 47,
                "height": 37,
                "alt": "*",
                "flipRtl": false
            },
            {
                "type": "input_value",
                "name": "NAME 2"
            },
            {
                "type": "input_value",
                "name": "NAME 3"
            }
        ],
        "inputsInline": true,
        "previousStatement": null,
        "nextStatement": null,
        "colour": 300,
        "tooltip": "",
        "helpUrl": ""
    },
    {
        "type": "show_progress",
        "message0": "%{BKY_SHOW_PROGRESS}",
        "args0": [
            {
                "type": "field_image",
                "src": "../../images/show.png",
                "width": 47,
                "height": 37,
                "alt": "*",
                "flipRtl": false
            },
            {
                "type": "input_value",
                "name": "NAME1"
            },
            {
                "type": "input_value",
                "name": "NAME2"
            },
            {
                "type": "input_value",
                "name": "NAME3"
            },
            {
                "type": "input_value",
                "name": "NAME4"
            },
            {
                "type": "input_value",
                "name": "NAME5"
            }
        ],
        "inputsInline": true,
        "previousStatement": null,
        "nextStatement": null,
        "colour": 300,
        "tooltip": "",
        "helpUrl": ""
    },
    {
        "type": "show_column",
        "message0": "%{BKY_SHOW_COLOUM}",
        "args0": [
            {
                "type": "field_image",
                "src": "../../images/show.png",
                "width": 47,
                "height": 37,
                "alt": "*",
                "flipRtl": false
            },
            {
                "type": "field_dropdown",
                "name": "line",
                "options": [
                    [
                        "%{BKY_VERTICAL}",
                        "1"
                    ],
                    [
                        "%{BKY_HORIZONTAL}",
                        "2"
                    ]
                ]
            },
            {
                "type": "input_dummy"
            },
            {
                "type": "input_value",
                "name": "NAME1"
            },
            {
                "type": "input_value",
                "name": "NAME2"
            },
            {
                "type": "input_value",
                "name": "NAME3"
            },
            {
                "type": "input_value",
                "name": "NAME4"
            }
        ],
        "inputsInline": true,
        "previousStatement": null,
        "nextStatement": null,
        "colour": 300,
        "tooltip": "",
        "helpUrl": ""
    },
    {
        "type": "show_vertical_line",
        "message0": "%1 %{BKY_SHOW_VERTICAL_LINE}",
        "args0": [
            {
                "type": "field_image",
                "src": "../../images/show.png",
                "width": 47,
                "height": 37,
                "alt": "*",
                "flipRtl": false
            },
            {
                "type": "field_dropdown",
                "name": "line",
                "options": [
                    [
                        "%{BKY_VERTICAL}",
                        "1"
                    ],
                    [
                        "%{BKY_HORIZONTAL}",
                        "2"
                    ]
                ]
            },
            {
                "type": "input_dummy"
            },
            {
                "type": "input_value",
                "name": "NAME1"
            },
            {
                "type": "input_value",
                "name": "NAME2"
            },
            {
                "type": "input_value",
                "name": "NAME3"
            }
        ],
        "inputsInline": true,
        "previousStatement": null,
        "nextStatement": null,
        "colour": 300,
        "tooltip": "",
        "helpUrl": ""
    },
    {
        "type": "show_draw_line",
        "message0": "%1 %{BKY_SHOW_DRAW_LINE}",
        "args0": [
            {
                "type": "field_image",
                "src": "../../images/show.png",
                "width": 47,
                "height": 37,
                "alt": "*",
                "flipRtl": false
            },
            {
                "type": "input_dummy"
            },
            {
                "type": "input_value",
                "name": "NAME1"
            },
            {
                "type": "input_value",
                "name": "NAME2"
            },
            {
                "type": "input_value",
                "name": "NAME3"
            },
            {
                "type": "input_value",
                "name": "NAME4"
            }
        ],
        "inputsInline": true,
        "previousStatement": null,
        "nextStatement": null,
        "colour": 300,
        "tooltip": "X范围：0-127   Y范围：0-63",
        "helpUrl": ""
    },
    {
        "type": "show_rectangle",
        "message0": "%1 %{BKY_SHOW_RECTANGLE}",
        "args0": [
            {
                "type": "field_image",
                "src": "../../images/show.png",
                "width": 47,
                "height": 37,
                "alt": "*",
                "flipRtl": false
            },
            {
                "type": "field_dropdown",
                "name": "shape",
                "options": [
                    [
                        "%{BKY_HOLLOW}",
                        "2"
                    ],
                    [
                        "%{BKY_SOLID}",
                        "1"
                    ]
                ]
            },
            {
                "type": "input_dummy"
            },
            {
                "type": "input_value",
                "name": "NAME1"
            },
            {
                "type": "input_value",
                "name": "NAME2"
            },
            {
                "type": "input_value",
                "name": "NAME3"
            },
            {
                "type": "input_value",
                "name": "NAME4"
            }
        ],
        "inputsInline": true,
        "previousStatement": null,
        "nextStatement": null,
        "colour": 300,
        "tooltip": "",
        "helpUrl": ""
    },
    {
        "type": "show_circle",
        "message0": "%1 %{BKY_SHOW_CIRCLE}",
        "args0": [
            {
                "type": "field_image",
                "src": "../../images/show.png",
                "width": 47,
                "height": 37,
                "alt": "*",
                "flipRtl": false
            },
            {
                "type": "field_dropdown",
                "name": "shape",
                "options": [
                    [
                        "%{BKY_HOLLOW}",
                        "2"
                    ],
                    [
                        "%{BKY_SOLID}",
                        "1"
                    ]
                ]
            },
            {
                "type": "input_dummy"
            },
            {
                "type": "input_value",
                "name": "NAME1"
            },
            {
                "type": "input_value",
                "name": "NAME2"
            },
            {
                "type": "input_value",
                "name": "NAME3"
            }
        ],
        "inputsInline": true,
        "previousStatement": null,
        "nextStatement": null,
        "colour": 300,
        "tooltip": "",
        "helpUrl": ""
    },
    {
        "type": "show_arc",
        "message0": "%1 %{BKY_SHOW_ARC}",
        "args0": [
            {
                "type": "field_image",
                "src": "../../images/show.png",
                "width": 47,
                "height": 37,
                "alt": "*",
                "flipRtl": false
            },
            {
                "type": "field_dropdown",
                "name": "quadrant",
                "options": [
                    [
                        "%{BKY_FIRST_QUADRANT} ",
                        "1"
                    ],
                    [
                        "%{BKY_SECOND_QUADRANT}",
                        "2"
                    ],
                    [
                        "%{BKY_THIRD_QUADRANT}",
                        "3"
                    ],
                    [
                        "%{BKY_FORTH_QUADRANT}",
                        "4"
                    ]
                ]
            },
            {
                "type": "input_dummy"
            },
            {
                "type": "input_value",
                "name": "NAME1"
            },
            {
                "type": "input_value",
                "name": "NAME2"
            },
            {
                "type": "input_value",
                "name": "NAME3"
            }
        ],
        "inputsInline": true,
        "previousStatement": null,
        "nextStatement": null,
        "colour": 300,
        "tooltip": "",
        "helpUrl": ""
    },
    {
        "type": "show_triangle",
        "message0": "%1 %{BKY_SHOW_TRIANGLE}",
        "args0": [
            {
                "type": "field_image",
                "src": "../../images/show.png",
                "width": 47,
                "height": 37,
                "alt": "*",
                "flipRtl": false
            },
            {
                "type": "field_dropdown",
                "name": "shape",
                "options": [
                    [
                        "%{BKY_HOLLOW}",
                        "2"
                    ],
                    [
                        "%{BKY_SOLID}",
                        "1"
                    ]
                ]
            },
            {
                "type": "input_dummy"
            },
            {
                "type": "input_value",
                "name": "NAME2"
            },
            {
                "type": "input_value",
                "name": "NAME3"
            },
            {
                "type": "input_value",
                "name": "NAME4"
            },
            {
                "type": "input_value",
                "name": "NAME5"
            },
            {
                "type": "input_value",
                "name": "NAME6"
            },
            {
                "type": "input_value",
                "name": "NAME7"
            }
        ],
        "inputsInline": true,
        "previousStatement": null,
        "nextStatement": null,
        "colour": 300,
        "tooltip": "",
        "helpUrl": ""
    },
    {
        "type": "show_hex_data",
        "message0": "%1 %{BKY_SHOW_HEX_DATA}",
        "args0": [
            {
                "type": "field_image",
                "src": "../../images/show.png",
                "width": 47,
                "height": 37,
                "alt": "*",
                "flipRtl": false
            },
            {
                "type": "input_dummy"
            },
            {
                "type": "input_value",
                "name": "NAME2"
            },
            {
                "type": "input_value",
                "name": "NAME3"
            },
            {
                "type": "input_value",
                "name": "NAME4"
            },
            {
                "type": "input_value",
                "name": "NAME5"
            },
            {
                "type": "input_value",
                "name": "NAME6"
            }
        ],
        "inputsInline": true,
        "previousStatement": null,
        "nextStatement": null,
        "colour": 300,
        "tooltip": "",
        "helpUrl": ""
    },
    {
        "type": "show_oclock",
        "message0": "%1 %{BKY_SHOW_CLOCK}",
        "args0": [
            {
                "type": "field_image",
                "src": "../../images/show.png",
                "width": 47,
                "height": 37,
                "alt": "*",
                "flipRtl": false
            },
            {
                "type": "field_dropdown",
                "name": "function",
                "options": [
                    [
                        "%{BKY_DIGITAL}",
                        "1"
                    ],
                    [
                        "%{BKY_CIRCUMFERENCE}",
                        "0"
                    ]
                ]
            }
        ],
        "inputsInline": true,
        "previousStatement": null,
        "nextStatement": null,
        "colour": 300,
        "tooltip": "",
        "helpUrl": ""
    }

 ])

//wifi
Blockly.defineBlocksWithJsonArray([
    {
        "type": "wifi_connect",
        "message0": "%{BKY_WIFI_CONNECT}",
        "args0": [
            {
                "type": "field_image",
                "src": "../../images/logowifi.png",
                "width": 47,
                "height": 37,
                "alt": "*",
                "flipRtl": false
            },
            {
                "type": "input_dummy"
            },
            {
                "type": "input_value",
                "name": "ssid",
            },
            {
                "type": "input_value",
                "name": "password"
            },
        ],
        "inputsInline": true,
        "previousStatement": null,
        "nextStatement": null,
        "colour": 350,
        "tooltip": "",
        "helpUrl": ""
    },
    {
        "type": "wifi_disconnect",
        "message0": "%1 %{BKY_WIFI_DISCONNECT}",
        "args0": [
            {
                "type": "field_image",
                "src": "../../images/logowifi.png",
                "width": 47,
                "height": 37,
                "alt": "*",
                "flipRtl": false
            }
        ],
        "previousStatement": null,
        "nextStatement": null,
        "colour": 350,
        "tooltip": "",
        "helpUrl": ""
    },
    {
        "type": "wifi_isconnected",
        "message0": "%1 %{BKY_WIFI_ISCONNECTED}",
        "args0": [
            {
                "type": "field_image",
                "src": "../../images/logowifi.png",
                "width": 47,
                "height": 37,
                "alt": "*",
                "flipRtl": false
            }
        ],
        "inputsInline": true,
        "output": null,
        "colour": 350,
        "tooltip": "",
        "helpUrl": ""
    },
    {
        "type": "wifi_msg",
        "message0": "%1 %{BKY_WIFI_MSG}",
        "args0": [
            {
                "type": "field_image",
                "src": "../../images/logowifi.png",
                "width": 47,
                "height": 37,
                "alt": "*",
                "flipRtl": false
            }
        ],
        "inputsInline": true,
        "output": null,
        "colour": 350,
        "tooltip": "",
        "helpUrl": ""
    },
    {
        "type": "wifi_message",
        "message0": "%1 %{BKY_WIFI_MSG} %2 %3",
        "args0": [
            {
                "type": "field_image",
                "src": "../../images/logowifi.png",
                "width": 47,
                "height": 37,
                "alt": "*",
                "flipRtl": false
            },
            {
                "type": "input_dummy"
            },
            {
                "type": "field_dropdown",
                "name": "position",
                "options": [
                    [
                        "IP",
                        "0"
                    ],
                    [
                        "netmask",
                        "1"
                    ],
                    [
                        "gateway",
                        "2"
                    ],
                    [
                        "DNS",
                        "3"
                    ],
                ]
            }
        ],

        "inputsInline": true,
        "output": null,
        "colour": 350,
        "tooltip": "",
        "helpUrl": ""
    },

])


//��ѧ
Blockly.defineBlocksWithJsonArray([
    {
        "type": "remainder",
        "message0": "%1 %{BKY_KEEP} %2 %{BKY_DECIMAL_PLA}",
        "args0": [
            {
                "type": "input_value",
                "name": "input"
            },
            {
                "type": "input_value",
                "name": "limit",
                "align": "RIGHT"
            }
        ],
        "inputsInline": true,
        "output": null,
        "colour": 230,
        "tooltip": "",
        "helpUrl": ""
    },
    {
        "type": "casts",
        "message0": "%1 %2",
        "args0": [
            {
                "type": "field_dropdown",
                "name": "type",
                "options": [
                    [
                        "int",
                        "int"
                    ],
                    [
                        "float",
                        "float"
                    ],
                    [
                        "str",
                        "str"
                    ]
                ]
            },
            {
                "type": "input_value",
                "name": "NAME"
            }
        ],
        "inputsInline": false,
        "output": null,
        "colour": 230,
        "tooltip": "",
        "helpUrl": ""
    },
    {
        "type": "typeof",
        "message0": "%{BKY_TYPE} %1",
        "args0": [
            {
                "type": "input_value",
                "name": "NAME"
            }
        ],
        "output": null,
        "colour": 230,
        "tooltip": "",
        "helpUrl": ""
    },
    {
        "type": "bit_option",
        "message0": "%1 %2 %3",
        "args0": [
            {
                "type": "input_value",
                "name": "NAME1"
            },
            {
                "type": "field_dropdown",
                "name": "signal",
                "options": [
                    [
                        "|",
                        "|"
                    ],
                    [
                        "&",
                        "&"
                    ],
                    [
                        "^",
                        "^"
                    ],
                    [
                        "<<",
                        "<<"
                    ],
                    [
                        ">>",
                        ">>"
                    ]
                ]
            },
            {
                "type": "input_value",
                "name": "NAME2"
            }
        ],
        "inputsInline": true,
        "output": null,
        "colour": 230,
        "tooltip": "",
        "helpUrl": ""
    },
    {
        "type": "invert",
        "message0": "%{BKY_BINARY_INVERT} %1",
        "args0": [
            {
                "type": "input_value",
                "name": "NAME"
            }
        ],
        "inputsInline": true,
        "output": null,
        "colour": 230,
        "tooltip": "",
        "helpUrl": ""
    },
    {
        "type": "decimal_conversion",
        "message0": "%{BKY_DECIMAL_INT} %1 %{BKY_CONVERTED_TO} %2 %{BKY_STRING}",
        "args0": [
            {
                "type": "input_value",
                "name": "input"
            },
            {
                "type": "field_dropdown",
                "name": "option", 
                "options": [
                    [
                        "binary",
                        "bin"
                    ],
                    [
                        "octal",
                        "oct"
                    ],
                    [
                        "hexadecimal",
                        "hex"
                    ]
                ]
            }
        ],
        "inputsInline": true,
        "output": null,
        "colour": 230,
        "tooltip": "",
        "helpUrl": ""
    },
    {
        "type": "convert_decimal",
        "message0": "%1 %{BKY_STRING} %2 %{BKY_CONVERTED_TO}%{BKY_DECIMAL_INT}",
        "args0": [
            {
                "type": "field_dropdown",
                "name": "option",
                "options": [
                    [
                        "binary",
                        "2"
                    ],
                    [
                        "octal",
                        "8"
                    ],
                    [
                        "hexadecimal",
                        "16"
                    ]
                ]
            },
            {
                "type": "input_value",
                "name": "NAME"
            }
        ],
        "inputsInline": true,
        "output": null,
        "colour": 230,
        "tooltip": "",
        "helpUrl": ""
    }

]);

//tupleԪ��
Blockly.Blocks['tuple_create_with'] = {
    /**
     * Block for creating a list with any number of elements of any type.
     * @this Blockly.Block
     */
    init: function () {
        this.setHelpUrl(Blockly.Msg['LISTS_CREATE_WITH_HELPURL']);
        //this.setStyle('logic_blocks');
        this.setColour(300);
        this.itemCount_ = 3;
        this.updateShape_();
        this.setOutput(true, 'Array');
        this.setMutator(new Blockly.Mutator(['lists_create_with_item']));
        this.setTooltip(Blockly.Msg['LISTS_CREATE_WITH_TOOLTIP']);
    },
    /**
     * Create XML to represent list inputs.
     * @return {!Element} XML storage element.
     * @this Blockly.Block
     */
    mutationToDom: function () {
        var container = document.createElement('mutation');
        container.setAttribute('items', this.itemCount_);
        return container;
    },
    /**
     * Parse XML to restore the list inputs.
     * @param {!Element} xmlElement XML storage element.
     * @this Blockly.Block
     */
    domToMutation: function (xmlElement) {
        this.itemCount_ = parseInt(xmlElement.getAttribute('items'), 10);
        this.updateShape_();
    },
    /**
     * Populate the mutator's dialog with this block's components.
     * @param {!Blockly.Workspace} workspace Mutator's workspace.
     * @return {!Blockly.Block} Root block in mutator.
     * @this Blockly.Block
     */
    decompose: function (workspace) {
        var containerBlock = workspace.newBlock('lists_create_with_container');
        containerBlock.initSvg();
        var connection = containerBlock.getInput('STACK').connection;
        for (var i = 0; i < this.itemCount_; i++) {
            var itemBlock = workspace.newBlock('lists_create_with_item');
            itemBlock.initSvg();
            connection.connect(itemBlock.previousConnection);
            connection = itemBlock.nextConnection;
        }
        return containerBlock;
    },
    /**
     * Reconfigure this block based on the mutator dialog's components.
     * @param {!Blockly.Block} containerBlock Root block in mutator.
     * @this Blockly.Block
     */
    compose: function (containerBlock) {
        var itemBlock = containerBlock.getInputTargetBlock('STACK');
        // Count number of inputs.
        var connections = [];
        while (itemBlock) {
            connections.push(itemBlock.valueConnection_);
            itemBlock = itemBlock.nextConnection &&
                itemBlock.nextConnection.targetBlock();
        }
        // Disconnect any children that don't belong.
        for (var i = 0; i < this.itemCount_; i++) {
            var connection = this.getInput('ADD' + i).connection.targetConnection;
            if (connection && connections.indexOf(connection) == -1) {
                connection.disconnect();
            }
        }
        this.itemCount_ = connections.length;
        this.updateShape_();
        // Reconnect any child blocks.
        for (var i = 0; i < this.itemCount_; i++) {
            Blockly.Mutator.reconnect(connections[i], this, 'ADD' + i);
        }
    },
    /**
     * Store pointers to any connected child blocks.
     * @param {!Blockly.Block} containerBlock Root block in mutator.
     * @this Blockly.Block
     */
    saveConnections: function (containerBlock) {
        var itemBlock = containerBlock.getInputTargetBlock('STACK');
        var i = 0;
        while (itemBlock) {
            var input = this.getInput('ADD' + i);
            itemBlock.valueConnection_ = input && input.connection.targetConnection;
            i++;
            itemBlock = itemBlock.nextConnection &&
                itemBlock.nextConnection.targetBlock();
        }
    },
    /**
     * Modify this block to have the correct number of inputs.
     * @private
     * @this Blockly.Block
     */
    updateShape_: function () {
        if (this.itemCount_ && this.getInput('EMPTY')) {
            this.removeInput('EMPTY');
        } 
        // Add new inputs.
        for (var i = 0; i < this.itemCount_; i++) {
            if (!this.getInput('ADD' + i)) {
                var input = this.appendValueInput('ADD' + i);
                if (i == 0) {
                    input.appendField(Blockly.Msg["TUPLE_CREATE_WITH_INPUT_WITH"]);
                }
            }
        }
        // Remove deleted inputs.
        while (this.getInput('ADD' + i)) {
            this.removeInput('ADD' + i);
            i++;
        }
    }
};

//Ԫ��
Blockly.defineBlocksWithJsonArray([
    {
        "type": "newdefine_tuple",
        "message0": "%{BKY_DEFINE_TUPLE} %1 = %2",
        "args0": [
            {
                "type": "field_variable",
                "name": "NAME1",
                "variable": "my_tuple"
            },
            {
                "type": "input_value",
                "name": "NAME2"
            }
        ],
        "inputsInline": true,
        "previousStatement": null,
        "nextStatement": null,
        "colour": 300,
        "tooltip": "",
        "helpUrl": ""
    },
    {
        "type": "tuple_item",
        "message0": "%{BKY_TUPLE_ITEM}",
        "args0": [
            {
                "type": "input_value",
                "name": "NAME2"
            },
            {
                "type": "field_dropdown",
                "name": "function",
                "options": [
                    [
                        "%{BKY_DI}",
                        ""
                    ],
                    [
                        "%{BKY_COUNT_DI}",
                        "-"
                    ]
                ]
            },
            {
                "type": "input_value",
                "name": "NAME"
            }
        ],
        "inputsInline": true,
        "output": null,
        "colour": 300,
        "tooltip": "",
        "helpUrl": ""
    },
    {
        "type": "tuple_value",
        "message0": "%{BKY_TUPLE_VALUE}",
        "args0": [
            {
                "type": "input_value",
                "name": "NAME2"
            }
        ],
        "inputsInline": true,
        "output": null,
        "colour": 300,
        "tooltip": "",
        "helpUrl": ""
    },
    {
        "type": "tuple_return_value",
        "message0": "%{BKY_TUPLE_RETURN_VALUE}",
        "args0": [
            {
                "type": "input_value",
                "name": "NAME1"
            },
            {
                "type": "field_dropdown",
                "name": "function1",
                "options": [
                    [
                        "%{BKY_DI}",
                        ""
                    ],
                    [
                        "%{BKY_COUNT_DI}",
                        "-"
                    ]
                ]
            },
            {
                "type": "input_value",
                "name": "NAME2"
            },
            {
                "type": "field_dropdown",
                "name": "function2",
                "options": [
                    [
                        "%{BKY_DI}",
                        ""
                    ],
                    [
                        "%{BKY_COUNT_DI}",
                        "-"
                    ]
                ]
            },
            {
                "type": "input_value",
                "name": "NAME3"
            }
        ],
        "inputsInline": true,
        "output": null,
        "colour": 300,
        "tooltip": "",
        "helpUrl": ""
    },
    {
        "type": "tuple_minvalue",
        "message0": "%{BKY_TUPLEE} %1 %2",
        "args0": [
            {
                "type": "input_value",
                "name": "NAME1"
            },
            {
                "type": "field_dropdown",
                "name": "NAME2",
                "options": [
                    [
                        "%{BKY_MIN_VALUE}",
                        "min"
                    ],
                    [
                        "%{BKY_MAX_VALUE}",
                        "max"
                    ],
                    [
                        "%{BKY_LENGTH}",
                        "len"
                    ]
                ]
            }
        ],
        "inputsInline": true,
        "output": null,
        "colour": 300,
        "tooltip": "",
        "helpUrl": ""
    },
    {
        "type": "tuple_include",
        "message0": "%{BKY_TUPLEE} %1 %{BKY_INCLUDE} %2",
        "args0": [
            {
                "type": "input_value",
                "name": "NAME1"
            },
            {
                "type": "input_value",
                "name": "NAME2"
            }
        ],
        "inputsInline": true,
        "output": null,
        "colour": 300,
        "tooltip": "",
        "helpUrl": ""
    }

])

Blockly.defineBlocksWithJsonArray([
    {
        "type": "setsinglemove",    
        "message0": "%1 %{BKY_SET} %2 %{BKY_CODING_MOT} %3 %4 %{BKY_LAPS} %5 %{BKY_SPEED} %6",
        "args0": [
            {
                "type": "field_image",
                "src": "../../images/code.png",
                "width": 47,
                "height": 37,
                "alt": "*",
                "flipRtl": false
            },
            {
                "type": "field_dropdown",
                "name": "number",
                "options": [
                    [
                        "Port10",
                        "3"
                    ],
                    [
                        "Port12",
                        "4"
                    ]
                ]
            },
            {
                "type": "field_dropdown",
                "name": "status",
                "options": [
                    [
                        "%{BKY_CLOSE}",
                        "3"
                    ],
                    [
                        "%{BKY_FORWARD}",
                        "1"
                    ],
                    [
                        "%{BKY_BACK}",
                        "2"
                    ]
                ]
            },
            {
                "type": "input_dummy"
            },
            {
                "type": "input_value",
                "name": "NAME"
            },
            {
                "type": "field_dropdown",
                "name": "speed",
                "options": [
                    [
                        "%{BKY_FAST}",
                        "3"
                    ],
                    [
                        "%{BKY_MEDIUM}",
                        "2"
                    ],
                    [
                        "%{BKY_SLOW}",
                        "1"
                    ]
                ]
            }
        ],
        "inputsInline": true,
        "previousStatement": null,
        "nextStatement": null,
        "colour": 200,
        "tooltip": "",
        "helpUrl": ""
    },
    {
        "type": "motion_doucoding",
        "message0": "%1 %{BKY_SET} %2 %{BKY_DOU_CODING_MOT} %{BKY_DIRECTION} %3 %4 %{BKY_LAPS} %5 %{BKY_SPEED} %6",
        "args0": [
            {
                "type": "field_image",
                "src": "../../images/code.png",
                "width": 47,
                "height": 37,
                "alt": "*",
                "flipRtl": false
            },
            {
                "type": "field_dropdown",
                "name": "Port",
                "options": [
                    [
                        "Port10&12",
                        "1"
                    ],
                ]
            },
            {
                "type": "field_dropdown",
                "name": "Status",
                "options": [
                    [
                        "%{BKY_FORWARD}",
                        "1"
                    ],
                    [
                        "%{BKY_BACK}",
                        "2"
                    ],
                    [
                        "%{BKY_TURN_LEFT}",
                        "3"
                    ],
                    [
                        "%{BKY_TURN_RIGHT}",
                        "4"
                    ]
                ]
            },
            {
                "type": "input_dummy"
            },
            {
                "type": "input_value",
                "name": "laps"
            },
            {
                "type": "field_dropdown",
                "name": "Speed",
                "options": [
                    [
                        "%{BKY_FAST}",
                        "3"
                    ],
                    [
                        "%{BKY_MEDIUM}",
                        "2"
                    ],
                    [
                        "%{BKY_SLOW}",
                        "1"
                    ],
                    [
                        "%{BKY_ZERO}",
                        "4"
                    ],
                    [
                        "%{BKY_NEGLECT}",
                        "0"
                    ]
                ]
            }
        ],
        "inputsInline": true,
        "previousStatement": null,
        "nextStatement": null,
        "colour": 200,
        "tooltip": "",
        "helpUrl": ""
    },
    {
        "type": "setdcmotor",
        "message0": "%1 %{BKY_SET} %2 %{BKY_DC_MOT} %3 %{BKY_SPEED} %4",
        "args0": [
            {
                "type": "field_image",
                "src": "../../images/DC.png",
                "width": 47,
                "height": 37,
                "alt": "*",
                "flipRtl": false
            },
            {
                "type": "field_dropdown",
                "name": "number",
                "options": [
                    [
                        "Port9",
                        "1"
                    ],
                    [
                        "Port10",
                        "3"
                    ],
                    [
                        "Port11",
                        "2"
                    ],
                    [
                        "Port12",
                        "4"
                    ]
                ]
            },
            {
                "type": "field_dropdown",
                "name": "direct",
                "options": [
                    [
                        "%{BKY_FORWARD}",
                        "1"
                    ],
                    [
                        "%{BKY_BACK}",
                        "2"
                    ]
                ]
            },
            {
                "type": "field_dropdown",
                "name": "speed",
                "options": [
                    [
                        "%{BKY_ZERO}",
                        "0"
                    ],
                    [
                        "%{BKY_FAST}",
                        "3"
                    ],
                    [
                        "%{BKY_MEDIUM}",
                        "2"
                    ],
                    [
                        "%{BKY_SLOW}",
                        "1"
                    ]
                ]
            }
        ],
        "previousStatement": null,
        "nextStatement": null,
        "colour": 200,
        "tooltip": "",
        "helpUrl": ""
    },
    {
        "type": "setdoubledcmotor",
        "message0": "%1 %{BKY_SET} %2 %{BKY_DOU_DC_MOT} %{BKY_DIRECTION} %3 %{BKY_SPEED} %4",
        "args0": [
            {
                "type": "field_image",
                "src": "../../images/DC.png",
                "width": 47,
                "height": 37,
                "alt": "*",
                "flipRtl": false
            },
            {
                "type": "field_dropdown",
                "name": "port",
                "options": [
                    [
                        "Port9&11",
                        "1"
                    ],
                    [
                        "Port10&12",
                        "2"
                    ]
                ]
            },
            {
                "type": "field_dropdown",
                "name": "Direction",
                "options": [
                    [
                        "%{BKY_FORWARD}",
                        "1"
                    ],
                    [
                        "%{BKY_BACK}",
                        "2"
                    ],
                    [
                        "%{BKY_TURN_LEFT}",
                        "3"
                    ],
                    [
                        "%{BKY_TURN_RIGHT}",
                        "4"
                    ]
                ]
            },
            {
                "type": "field_dropdown",
                "name": "Speed",
                "options": [
                    [
                        "%{BKY_ZERO}",
                        "0"
                    ],
                    [
                        "%{BKY_FAST}",
                        "3"
                    ],
                    [
                        "%{BKY_MEDIUM}",
                        "2"
                    ],
                    [
                        "%{BKY_SLOW}",
                        "1"
                    ]
                ]
            }
        ],
        "previousStatement": null,
        "nextStatement": null,
        "colour": 200,
        "tooltip": "",
        "helpUrl": ""
    },
   {
    "type": "starttrack",
    "message0": "%{BKY_START_TRACK}",
    "previousStatement": null,
    "nextStatement": null,
    "colour": 200,
    "tooltip": "",
    "helpUrl": ""
    },
    {
        "type": "four_motor",
        "message0": "%1 %{BKY_FOUR_MOTOR}",
        "args0": [
            {
                "type": "field_image",
                "src": "../../images/DC.png",
                "width": 47,
                "height": 37,
                "alt": "*",
                "flipRtl": false
            },
            {
                "type": "field_dropdown",
                "name": "left_speed",
                "options": [
                    [
                        "-5",
                        "-5"
                    ],
                    [
                        "-4",
                        "-4"
                    ],
                    [
                        "-3",
                        "-3"
                    ],
                    [
                        "-2",
                        "-2"
                    ],
                    [
                        "-1",
                        "-1"
                    ],
                    [
                        "0",
                        "0"
                    ],
                    [
                        "1",
                        "1"
                    ],
                    [
                        "2",
                        "2"
                    ],
                    [
                        "3",
                        "3"
                    ],
                    [
                        "4",
                        "4"
                    ],
                    [
                        "5",
                        "5"
                    ]
                ]
            },
            {
                "type": "field_dropdown",
                "name": "right speed",
                "options": [
                    [
                        "-5",
                        "-5"
                    ],
                    [
                        "-4",
                        "-4"
                    ],
                    [
                        "-3",
                        "-3"
                    ],
                    [
                        "-2",
                        "-2"
                    ],
                    [
                        "-1",
                        "-1"
                    ],
                    [
                        "0",
                        "0"
                    ],
                    [
                        "1",
                        "1"
                    ],
                    [
                        "2",
                        "2"
                    ],
                    [
                        "3",
                        "3"
                    ],
                    [
                        "4",
                        "4"
                    ],
                    [
                        "5",
                        "5"
                    ]
                ]
            }
        ],
        "inputsInline": true,
        "previousStatement": null,
        "nextStatement": null,
        "colour": 200,
        "tooltip": "",
        "helpUrl": ""
    },
    {
        "type": "four1_motor",
        "message0": "%1 %{BKY_FOUR_MOTOR}",
        "args0": [
            {
                "type": "field_image",
                "src": "../../images/DC.png",
                "width": 47,
                "height": 37,
                "alt": "*",
                "flipRtl": false
            },
            {
                "type": "input_value",
                "name": "left_speed",
                "check": "Number",
                "align": "CENTRE"
            },
            {
                "type": "input_value",
                "name": "right_speed",
                "check": "Number",
                "align": "CENTRE"
            }
        ],
        "inputsInline": true,
        "previousStatement": null,
        "nextStatement": null,
        "colour": 200,
        "tooltip": "",
        "helpUrl": ""
    },
    {
        "type": "track_condition",
        "message0": "%1 %{BKY_TRACKING_CONDITION}",
        "args0": [
            {
                "type": "field_image",
                "src": "../../images/track.png",
                "width": 47,
                "height": 37,
                "alt": "*",
                "flipRtl": false
            },
            {
                "type": "field_dropdown",
                "name": "IR1",
                "options": [
                    [
                        "%{BKY_WHITE}",
                        "1"
                    ],
                    [
                        "%{BKY_BLACK}",
                        "0"
                    ],
                    [
                        "%{BKY_INDETERMINATE}",
                        "2"
                    ]
                ]
            },
            {
                "type": "field_dropdown",
                "name": "IR2",
                "options": [
                    [
                        "%{BKY_WHITE}",
                        "1"
                    ],
                    [
                        "%{BKY_BLACK}",
                        "0"
                    ],
                    [
                        "%{BKY_INDETERMINATE}",
                        "2"
                    ]
                ]
            },
            {
                "type": "field_dropdown",
                "name": "IR3",
                "options": [
                    [
                        "%{BKY_WHITE}",
                        "1"
                    ],
                    [
                        "%{BKY_BLACK}",
                        "0"
                    ],
                    [
                        "%{BKY_INDETERMINATE}",
                        "2"
                    ]
                ]
            },
            {
                "type": "field_dropdown",
                "name": "IR4",
                "options": [
                    [
                        "%{BKY_WHITE}",
                        "1"
                    ],
                    [
                        "%{BKY_BLACK}",
                        "0"
                    ],
                    [
                        "%{BKY_INDETERMINATE}",
                        "2"
                    ]
                ]
            },
            {
                "type": "field_dropdown",
                "name": "IR5",
                "options": [
                    [
                        "%{BKY_WHITE}",
                        "1"
                    ],
                    [
                        "%{BKY_BLACK}",
                        "0"
                    ],
                    [
                        "%{BKY_INDETERMINATE}",
                        "2"
                    ]
                ]
            }
        ],
        "output": null,
        "colour": 200,
        "tooltip": "",
        "helpUrl": ""
    },
    {
        "type": "track_straight",
        "message0": "%1 %{BKY_TRACK_STRAIGHT}",
        "args0": [
            {
                "type": "field_image",
                "src": "../../images/DC.png",
                "width": 47,
                "height": 37,
                "alt": "*",
                "flipRtl": false
            },
            {
                "type": "field_dropdown",
                "name": "port",
                "options": [
                    [
                        "Port9&11",
                        "2"
                    ],
                    [
                        "Port10&12",
                        "1"
                    ],
                    [
                        "Port9&10&11&12",
                        "3"
                    ]
                ]
            },
            {
                "type": "input_value",
                "name": "speed11",
                "check": "Number",
                "align": "CENTRE"
            },
            {
                "type": "input_value",
                "name": "speed12",
                "check": "Number",
                "align": "CENTRE"
            },
            {
                "type": "input_value",
                "name": "speed21",
                "check": "Number",
                "align": "CENTRE"
            },
            {
                "type": "input_value",
                "name": "speed22",
                "check": "Number",
                "align": "CENTRE"
            },
            {
                "type": "input_value",
                "name": "speed31",
                "check": "Number",
                "align": "CENTRE"
            },
            {
                "type": "input_value",
                "name": "speed32",
                "check": "Number",
                "align": "CENTRE"
            },
            {
                "type": "input_value",
                "name": "speed41",
                "check": "Number",
                "align": "CENTRE"
            },
            {
                "type": "input_value",
                "name": "speed42",
                "check": "Number",
                "align": "CENTRE"
            },
            {
                "type": "input_value",
                "name": "speed51",
                "check": "Number",
                "align": "CENTRE"
            },
            {
                "type": "input_value",
                "name": "speed52",
                "check": "Number",
                "align": "CENTRE"
            }
        ],
        "inputsInline": true,
        "previousStatement": null,
        "nextStatement": null,
        "colour": 200,
        "tooltip": "",
        "helpUrl": ""
    },
    {
        "type": "track_4turn",
        "message0": "%1 %{BKY_TRACK_4TURN}",
        "args0": [
            {
                "type": "field_image",
                "src": "../../images/DC.png",
                "width": 47,
                "height": 37,
                "alt": "*",
                "flipRtl": false
            },
            {
                "type": "input_value",
                "name": "left_speed",
                "check": "Number",
                "align": "CENTRE"
            },
            {
                "type": "input_value",
                "name": "right_speed",
                "check": "Number",
                "align": "CENTRE"
            },
            {
                "type": "field_dropdown",
                "name": "mark",
                "options": [
                    [
                        "%{BKY_LEFTMOST}",
                        "0"
                    ],
                    [
                        "%{BKY_LEFT2}",
                        "1"
                    ],
                    [
                        "%{BKY_MIDDLE}",
                        "2"
                    ],
                    [
                        "%{BKY_RIGHT2}",
                        "3"
                    ],
                    [
                        "%{BKY_RIGHTMOST}",
                        "4"
                    ]
                ]
            },
            {
                "type": "input_dummy"
            },
            {
                "type": "input_value",
                "name": "line",
                "check": "Number",
                "align": "CENTRE"
            },
            {
                "type": "input_value",
                "name": "time",
                "check": "Number",
                "align": "CENTRE"
            }
        ],
        "inputsInline": true,
        "previousStatement": null,
        "nextStatement": null,
        "colour": 200,
        "tooltip": "",
        "helpUrl": ""
    },
    {
        "type": "track_2turn",
        "message0": "%1 %{BKY_TRACK_2TURN}",
        "args0": [
            {
                "type": "field_image",
                "src": "../../images/DC.png",
                "width": 47,
                "height": 37,
                "alt": "*",
                "flipRtl": false
            },
            {
                "type": "field_dropdown",
                "name": "port",
                "options": [
                    [
                        "Port9&11",
                        "2"
                    ],
                    [
                        "Port10&12",
                        "1"
                    ],
                    [
                        "Port9&10&11&12",
                        "3"
                    ]
                ]
            },
            {
                "type": "input_value",
                "name": "left_speed",
                "check": "Number",
                "align": "CENTRE"
            },
            {
                "type": "input_value",
                "name": "right_speed",
                "check": "Number",
                "align": "CENTRE"
            },
            {
                "type": "input_value",
                "name": "time1",
                "check": "Number",
                "align": "CENTRE"
            },
            {
                "type": "field_dropdown",
                "name": "mark",
                "options": [
                    [
                        "%{BKY_LEFTMOST}",
                        "0"
                    ],
                    [
                        "%{BKY_LEFT2}",
                        "1"
                    ],
                    [
                        "%{BKY_MIDDLE}",
                        "2"
                    ],
                    [
                        "%{BKY_RIGHT2}",
                        "3"
                    ],
                    [
                        "%{BKY_RIGHTMOST}",
                        "4"
                    ]
                ]
            },
            {
                "type": "input_dummy"
            },
            {
                "type": "input_value",
                "name": "time",
                "check": "Number",
                "align": "CENTRE"
            }
        ],
        "inputsInline": true,
        "previousStatement": null,
        "nextStatement": null,
        "colour": 200,
        "tooltip": "",
        "helpUrl": ""
    },
    {
        "type": "track_2turn2",
        "message0": "%1 %{BKY_TRACK_2TURN2}",
        "args0": [
            {
                "type": "field_image",
                "src": "../../images/DC.png",
                "width": 47,
                "height": 37,
                "alt": "*",
                "flipRtl": false
            },
            {
                "type": "field_dropdown",
                "name": "port",
                "options": [
                    [
                        "Port9&11",
                        "2"
                    ],
                    [
                        "Port10&12",
                        "1"
                    ]
                ]
            },
            {
                "type": "input_value",
                "name": "left_speed",
                "check": "Number",
                "align": "CENTRE"
            },
            {
                "type": "input_value",
                "name": "right_speed",
                "check": "Number",
                "align": "CENTRE"
            },
            {
                "type": "field_dropdown",
                "name": "mark1",
                "options": [
                    [
                        "%{BKY_LEFTMOST}",
                        "0"
                    ],
                    [
                        "%{BKY_LEFT2}",
                        "1"
                    ],
                    [
                        "%{BKY_MIDDLE}",
                        "2"
                    ],
                    [
                        "%{BKY_RIGHT2}",
                        "3"
                    ],
                    [
                        "%{BKY_RIGHTMOST}",
                        "4"
                    ]
                ]
            },
            {
                "type": "field_dropdown",
                "name": "mark2",
                "options": [
                    [
                        "%{BKY_LEFTMOST}",
                        "0"
                    ],
                    [
                        "%{BKY_LEFT2}",
                        "1"
                    ],
                    [
                        "%{BKY_MIDDLE}",
                        "2"
                    ],
                    [
                        "%{BKY_RIGHT2}",
                        "3"
                    ],
                    [
                        "%{BKY_RIGHTMOST}",
                        "4"
                    ]
                ]
            },
            {
                "type": "input_dummy"
            },
            {
                "type": "input_value",
                "name": "time",
                "check": "Number",
                "align": "CENTRE"
            }
        ],
        "inputsInline": true,
        "previousStatement": null,
        "nextStatement": null,
        "colour": 200,
        "tooltip": "",
        "helpUrl": ""
    },
    {
        "type": "track_start",
        "message0": "%{BKY_START_TRACK}",
        "previousStatement": null,
        "nextStatement": null,
        "colour": 200,
        "tooltip": "",
        "helpUrl": ""
    },
    {
        "type": "track_stop",
        "message0": "%{BKY_STOP_TRACK}",
        "previousStatement": null,
        "nextStatement": null,
        "colour": 200,
        "tooltip": "",
        "helpUrl": ""
    },
    {
        "type": "start_program",
        "message0": "%{BKY_START_PRO}",
        "nextStatement": null,
        "colour": "#A53637",
        "tooltip": "",
        "helpUrl": ""
    },
    {
        "type": "end_program",
        "message0": "%{BKY_END_PRO}",
        "previousStatement": null,
        "colour": "#A53637",
        "tooltip": "",
        "helpUrl": ""
    }
]);


//集合
Blockly.defineBlocksWithJsonArray([
{
  "type": "newdefine_set",
        "message0": "%{BKY_DEFINE_SET} %1 = %2",
  "args0": [
    {
      "type": "field_variable",
      "name": "NAME1",
      "variable": "my_set"
    },
    {
      "type": "input_value",
      "name": "NAME2"
    }
  ],
  "inputsInline": true,
  "previousStatement": null,
  "nextStatement": null,
        "colour": 350,
  "tooltip": "",
  "helpUrl": ""
},
{
  "type": "update_set",
    "message0": "%{BKY_UPDATE_SET}",
  "args0": [
    {
      "type": "field_variable",
      "name": "NAME1",
      "variable": "my_set"
    },
    {
      "type": "input_value",
      "name": "NAME2"
    },
    {
      "type": "field_dropdown",
      "name": "function",
      "options": [
        [
          "%{BKY_INTERSECTION}",
          "intersection"
        ],
        [
          "%{BKY_UNION}",
          "union"
        ],
        [
          "%{BKY_DIFFERENCE}",
          "difference"
        ]
      ]
    }
  ],
  "inputsInline": true,
  "previousStatement": null,
  "nextStatement": null,
    "colour": 350,
  "tooltip": "",
  "helpUrl": ""
},
{
  "type": "set_add",
    "message0": "%{BKY_SET_ADD}",
  "args0": [
    {
      "type": "input_value",
      "name": "NAME2"
    },
    {
      "type": "input_value",
      "name": "NAME"
    }
  ],
  "inputsInline": true,
  "previousStatement": null,
  "nextStatement": null,
    "colour": 350,
  "tooltip": "",
  "helpUrl": ""
},
{
  "type": "set_length",
    "message0": "%{BKY_SET_LENGTH}",
  "args0": [
    {
      "type": "input_value",
      "name": "NAME2"
    }
  ],
  "inputsInline": true,
  "output": null,
    "colour": 350,
  "tooltip": "",
  "helpUrl": ""
},
{
  "type": "set_subset",
    "message0": "%{BKY_SET_SUBSET}",
  "args0": [
    {
      "type": "input_value",
      "name": "NAME2"
    },
    {
      "type": "field_dropdown",
      "name": "function",
      "options": [
        [
          "%{BKY_SUBSET}",
          ".issubset"
        ],
        [
          "%{BKY_SUPERSET} ",
          ".issuperset"
        ]
      ]
    },
    {
      "type": "input_value",
      "name": "NAME"
    }
  ],
  "inputsInline": true,
  "output": null,
    "colour": 350,
  "tooltip": "",
  "helpUrl": ""
}
]);
