from time import sleep
from machine import UART

uart = UART(0, 115200)  # init with given baudrate
uart.init(115200, bits=8, parity=None, stop=1)

import uos

uos.dupterm(None, 1)

import esp

esp.uart_swap()

# 区分传感器输入值的正负数 默认大于128为负数
def distinguish_value(a):
    if a > 128:
        return a - 256
    else:
        return a

#计时，设置等待最长时间为1秒  0.001*1000
def count_time(i):
    sleep(0.001)
    if i < 1000:
        tag = True
    else:
        tag = False
    return tag

# 等待接收返回值 
def wait():
    tag = True
    i = 0
    while tag:
      value = uart.read()   #串口读取接收值
      i +=1
      tag = count_time(i)
      if value:            #读取到值，即返回此值
        return value
    return [256,256,1,0,1,0,0,0,0,0,0,0,0]  # 使得获取传感器的返回值为False
# 超声波
def ultrasonic(a, ID, port):
    b = uart.write(a)    #8266通过串口发送指令到2560
    b = wait()
    check = 0b11111111
    b = list(b)
    sleep(0.5)
    if ID == b[4] and port == b[3] and ((b[2] + b[3] + b[4] + b[5] + b[6] +b[7]) & check) == b[8]:  #校验
      value = uart.read()
      return (b[6] << 8) + b[7]
    else:
      value = uart.read()
      return 0


# 无需检测端口号
def set(a,ID):
    b = uart.write(a)
    b = wait()
    check = 0b11111111
    b = list(b)
    try:
        if b[3] == 44:
            return b[5]
        if ID == b[3] and ((b[2] + b[3] + b[4] + b[5]) & check) == b[6]:
            value = uart.read()
            return 1
        else:
            value = uart.read()
        return 0
    except:
        return 0

def value(a,ID,port):
    b = uart.write(a)
    b = wait()
    b = list(b)
    sleep(0.1)
    check = 0b11111111
    b[6] = distinguish_value(b[6])
    if ID == b[4] and port ==b[3] and ((b[2] + b[3] + b[4] + b[5] + b[6]) & check) == b[7]:
        value = uart.read()
        return b[6]
    else:
        value = uart.read()
        return 0

# 返回加速度的x,y,z值
def get(a, c, ID, port):
    b = uart.write(a)
    b = wait()
    b = list(b)
    value = uart.read()
    check = 0b11111111
    if ID == b[4] and port ==b[3] and ((b[2] + b[3] + b[4] + b[5] + b[6] + b[7] + b[8] + b[9] + b[10]) & check) == b[11]:
        b[6] = distinguish_value(b[6])
        b[7] = distinguish_value(b[7])
        b[8] = distinguish_value(b[8])
        if c == "steps_value":
            return (b[9] << 8) + b[10]
        if c == "x_value":
            return b[6]
        if c == "y_value":
            return b[7]
        if c == "z_value":
            return b[8]
        if c == "calibration":
            return True
        if c == "counting":
            return True
        if c == "acc_xyz":
            acc_x = b[6] << 16
            acc_y = b[7] << 8
            acc = acc_x + acc_y + b[8]
            return acc
    else:
        return 0

# 检测是否运动
def detect_move(a,ID, port):
    check = 0b11111111
    b = uart.write(a)
    b = wait()
    b = list(b)  
    # value = uart.read()
    if len(b) ==12:
        b[6] = distinguish_value(b[6])
        b[7] = distinguish_value(b[7])
        b[8] = distinguish_value(b[8])
        sleep(0.5)
        c = uart.write(a)
        c = wait()
        c = list(c)
        sleep(0.5)
        if len(c)==12:
            c[6] = distinguish_value(c[6])
            c[7] = distinguish_value(c[7])
            c[8] = distinguish_value(c[8])
            if ID == b[4] and port ==b[3] and ID == c[4] and port ==c[3] and((b[2] + b[3] + b[4] + b[5] + b[6] + b[7] + b[8] + b[9]+b[10]) & check) == b[11] and ((c[2] + c[3] + c[4] + c[5] + c[6] + c[7] + c[8] + c[9]+c[10]) & check) == c[11]:
                if abs(abs(c[6]) - abs(b[6])) > 1 or abs(abs(c[7]) - abs(b[7])) > 1 or abs(abs(c[8]) - abs(b[8])) > 1:
                    return 1
                else:
                    return 0
            else:
                return 0
        else:
            return 0
    else:
        return 0


# 获得加速度传感的速度值
def get_acc(acc, value):
    x = acc >> 16
    y1 = acc - (x << 16)
    y = y1 >> 8
    z = y1 - (y << 8)
    if value == "acc_x":
        acc_x = distinguish_value(x)
        return acc_x
    if value == "acc_y":
        acc_y = distinguish_value(y)
        return acc_y
    if value == "acc_z":
        acc_z = distinguish_value(z)
        return acc_z
    else:
        return 0















