import network
import socket
import ure
import time
import ubinascii
import MRT
ap_ssid='MRT_'
ap_password = "12345678"
ap_authmode = 3  # WPA2

wlan_ap = network.WLAN(network.AP_IF)
wlan_sta = network.WLAN(network.STA_IF)

server_socket = None
NETWORK_PROFILES = 'wifi.dat'

sta_ssid=""
sta_password=""


def do_connect(ssid, password):
    wlan_sta.active(True)
    wlan_sta.connect(ssid, password)
    count = 0
    # print("wifi 连接")
    while (not wlan_sta.isconnected())and(count <10):
        time.sleep(1)
        count=count+1

    return wlan_sta.isconnected()


def send_header(client, status_code=200, content_length=None ):
    client.sendall("HTTP/1.0 {} OK\r\n".format(status_code))
    client.sendall("Content-Type: text/html\r\n")
    if content_length is not None:
      client.sendall("Content-Length: {}\r\n".format(content_length))
    client.sendall("\r\n")


def send_response(client, payload, status_code=200):
    content_length = len(payload)
    send_header(client, status_code, content_length)
    if content_length > 0:
        client.sendall(payload)
    client.close()


def handle_root(client):
    wlan_sta.active(True)
    ssids = sorted(ssid.decode('utf-8') for ssid, *_ in wlan_sta.scan())
    send_header(client)
    client.sendall("""\
        <html>
            <h1 style="color: #5e9ca0; text-align: center;">
                <span style="color: #ff0000;">
                    Wi-Fi Client Setup
                </span>
            </h1>
            <form action="configure" method="post">
                <table style="margin-left: auto; margin-right: auto;">
                    <tbody>
    """)
    while len(ssids):
        ssid = ssids.pop(0)
        client.sendall("""\
                        <tr>
                            <td colspan="2">
                                <input type="radio" name="ssid" value="{0}" />{0}
                            </td>
                        </tr>
        """.format(ssid))
    client.sendall("""\
                        <tr>
                            <td>Password:</td>
                            <td><input name="password" type="password" /></td>
                        </tr>
                    </tbody>
                </table>
                <p style="text-align: center;">
                    <input type="submit" value="Submit" />
                </p>
            </form>
            <p>&nbsp;</p>
            <hr />
            <h5>
                <span style="color: #ff0000;">
                    Your ssid and password information will be saved into the
                    "%(filename)s" file in your ESP module for future usage.
                    Be careful about security!
                </span>
            </h5>
            <hr />
            
        </html>
    """ % dict(filename=NETWORK_PROFILES))
    client.close()


def handle_configure(client, request):
    match = ure.search("ssid=([^&]*)&password=(.*)", request)

    if match is None:
        send_response(client, "Parameters not found", status_code=400)
        return False
    # version 1.9 compatibility
    try:
        ssid = match.group(1).decode("utf-8").replace("%3F", "?").replace("%21", "!")
        password = match.group(2).decode("utf-8").replace("%3F", "?").replace("%21", "!")
    except Exception:
        ssid = match.group(1).replace("%3F", "?").replace("%21", "!")
        password = match.group(2).replace("%3F", "?").replace("%21", "!")

    if len(ssid) == 0:
        send_response(client, "SSID must be provided", status_code=400)
        return False

    print("wifi:"+ssid+" pass:"+password) #输出 password
    
    wlan_sta.active(True)
    wlan_sta.connect(ssid, password)
    count = 0
    # print("wifi 连接")
    while (not wlan_sta.isconnected())and(count <5):
        time.sleep(1)
        count=count+1

    if wlan_sta.isconnected():
        response = """\
            <html>
                <center>
                    <br><br>
                    <h1 style="color: #5e9ca0; text-align: center;">
                        <span style="color: #ff0000;">
                            ESP successfully connected to WiFi network %(ssid)s.
                        </span>
                    </h1>
                    <br><br>
                </center>
            </html>
        """ % dict(ssid=ssid)
        send_response(client, response)
        client.close()
        MRT.set("setClear()",64)
        MRT.set('setDisplay_row(2,"SET WIFI OK")',68)
        MRT.set('setDisplay_row(4,"Please Restart")',68)
        time.sleep(3)
        return True
    else:
        response = """\
            <html>
                <center>
                    <h1 style="color: #5e9ca0; text-align: center;">
                        <span style="color: #ff0000;">
                            ESP could not connect to WiFi network %(ssid)s.
                        </span>
                    </h1>
                    <br><br>
                    <form>
                        <input type="button" value="Go back!" onclick="history.back()"></input>
                    </form>
                </center>
            </html>
        """ % dict(ssid=ssid)
        send_response(client, response)
        client.close()
        MRT.set("setClear()",64)
        MRT.set('setDisplay_row(3,"SET WIFI Fail!")',68)
        time.sleep(3)
        MRT.set("setClear()",64)
        MRT.set('setDisplay_row(3,"SET WIFI ....")',68)
        time.sleep(1)
        return False


def handle_not_found(client, url):
    send_response(client, "Path not found: {}".format(url), status_code=404)




def start():
    addr = socket.getaddrinfo('0.0.0.0', 80)[0][-1]

    # wlan_sta.active(True)
    # wlan_ap.active(True)

    # mac=network.WLAN().config('mac')[3:6]
    # ap_ssid='MRT_'+str(ubinascii.hexlify(mac))[2:8]
    # wlan_ap.config(essid=ap_ssid, password=ap_password, authmode=ap_authmode)  #AP设置
    server_socket = socket.socket()
    server_socket.bind(addr)
    server_socket.listen(205)

    while True:
        client, addr = server_socket.accept()  #等待连接
        try:
            client.settimeout(5.0) #时间超了 
            request = b""
            try:
                while "\r\n\r\n" not in request:
                    request += client.recv(512)
            except OSError:
                pass
            # print("Request is: {}".format(request))
            if "HTTP" not in request:  # skip invalid requests
                continue
            # version 1.9 compatibility
            try:
                url = ure.search("(?:GET|POST) /(.*?)(?:\\?.*?)? HTTP", request).group(1).decode("utf-8").rstrip("/")
            except Exception:
                url = ure.search("(?:GET|POST) /(.*?)(?:\\?.*?)? HTTP", request).group(1).rstrip("/")
            print("URL is {}".format(url))
            if url == "":
                handle_root(client)
            elif url == "configure":
                handle_configure(client, request)
            else:
                pass
        except:
            MRT.set("setClear()",64)
            MRT.set('setDisplay_row(3,"SET WIFI ERROR!")',68)
            time.sleep(3)
            MRT.set("setClear()",64)
            MRT.set('setDisplay_row(3,"SET WIFI ....")',68)
            time.sleep(1)
