/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.JTextField;
import javax.swing.border.Border;

public class Ih
extends JTextField
implements Ii,
FocusListener {
    private static final String TAG = "CTextField";
    private boolean first;
    private String defaultValue;
    private Color emptyColor = Color.LIGHT_GRAY;
    private boolean focusing = false;
    private boolean haveNotTransparentDialog = false;
    private boolean emptyBackGround = false;

    public Ih(String text, String defaultValue) {
        this.defaultValue = defaultValue;
        this.setText(text);
        super.addFocusListener(this);
    }

    @Override
    public String getText() {
        if (this.first) {
            return "";
        }
        return super.getText();
    }

    @Override
    public final void setText(String text) {
        if ((text == null || text.isEmpty()) && !this.focusing) {
            this.first = true;
            super.setText(this.defaultValue);
        } else {
            this.first = false;
            super.setText(text);
        }
    }

    @Override
    public void focusGained(FocusEvent e2) {
        this.focusing = true;
        if (this.first) {
            this.first = false;
            super.setText("");
        }
    }

    @Override
    public void focusLost(FocusEvent e2) {
        this.focusing = false;
        if (this.getText().isEmpty()) {
            // empty if block
        }
    }

    @Override
    public void setEmptyColor(Color emptyColor) {
        this.emptyColor = emptyColor;
    }

    @Override
    public void paint(Graphics g2) {
        boolean currentHaveNotTransparentDialog = Dc.b();
        if (!this.emptyBackGround && currentHaveNotTransparentDialog != this.haveNotTransparentDialog) {
            this.haveNotTransparentDialog = currentHaveNotTransparentDialog;
            super.setOpaque(!this.haveNotTransparentDialog);
        }
        if (!this.first) {
            super.paint(g2);
        }
        if (this.first || this.getDocument().getLength() < 1) {
            if (this.isOpaque()) {
                super.paint(g2);
            }
            g2.setColor(this.emptyColor);
            g2.setFont(this.getFont());
            Ih.painDefault(g2, this.getWidth(), this.getHeight(), this.defaultValue, this.getHorizontalAlignment(), this);
        }
    }

    public static void painDefault(Graphics g2, int width, int height, String defaultValue, int horizontalAlignment, JTextField textField) {
        FontMetrics fm2 = g2.getFontMetrics();
        ((Graphics2D)g2).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int tranX = 0;
        int tranY = 0;
        Border border = textField.getBorder();
        if (border != null) {
            Insets insets = border.getBorderInsets(textField);
            width -= insets.right + insets.left;
            height -= insets.top + insets.bottom;
            tranX = insets.left;
            tranY = insets.top;
        }
        int y2 = fm2.getAscent() + tranY + (height - fm2.getHeight()) / 2;
        switch (horizontalAlignment) {
            case 4: {
                int w2 = (int)fm2.getStringBounds(defaultValue, g2).getWidth();
                g2.drawString(defaultValue, width - w2 - 1, y2);
                break;
            }
            case 0: {
                int w3 = (int)fm2.getStringBounds(defaultValue, g2).getWidth();
                g2.drawString(defaultValue, tranX + (width - w3) / 2, y2);
                break;
            }
            default: {
                g2.drawString(defaultValue, 1 + tranX, y2);
            }
        }
    }

    public boolean isFirst() {
        return this.first;
    }

    @Override
    public String getDefaultValue() {
        return this.defaultValue;
    }

    @Override
    public String getMText() {
        return this.getText();
    }

    @Override
    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    public void setEchoChar(char echoChar) {
    }

    @Override
    public void setEmptyBackGround(boolean emptyBackGround) {
        this.emptyBackGround = emptyBackGround;
    }
}

