/*
 * Decompiled with CFR 0.152.
 */
import java.util.Arrays;

class OL
extends OI {
    private int holdCountAdditionOwner = 0;
    private Thread[] threads = null;
    private int threadNum = 0;

    OL() {
    }

    @Override
    public final void incrHoldCount(Thread thread) {
        super.incrHoldCount(thread);
        if (!this.isOriginalOwner(thread)) {
            ++this.holdCountAdditionOwner;
        }
    }

    @Override
    public final void decrHoldCount(Thread thread) {
        super.decrHoldCount(thread);
        if (!this.isOriginalOwner(thread)) {
            --this.holdCountAdditionOwner;
        }
    }

    public final int getAdditionalOwnerHoldCount() {
        return this.holdCountAdditionOwner;
    }

    public final boolean isOriginalOwner(Thread thread) {
        return super.isOwner(thread);
    }

    @Override
    public final boolean isOwner(Thread thread) {
        if (this.getExclusiveOwnerThread() == thread) {
            return true;
        }
        for (int i2 = this.threadNum - 1; 0 <= i2; --i2) {
            if (this.threads[i2] != thread) continue;
            return true;
        }
        return false;
    }

    public final int getAddOwnerCount() {
        return this.threadNum;
    }

    public final void addOwner(Thread thread) {
        if (null == this.threads) {
            if (this.threadNum > 0) {
                throw new InternalError("XXX");
            }
            this.threads = new Thread[4];
        }
        for (int i2 = this.threadNum - 1; 0 <= i2; --i2) {
            if (this.threads[i2] != thread) continue;
            throw new IllegalArgumentException("Thread already added: " + thread);
        }
        if (this.threadNum == this.threads.length) {
            this.threads = Arrays.copyOf(this.threads, this.threadNum * 2);
        }
        this.threads[this.threadNum] = thread;
        ++this.threadNum;
    }

    public final void removeAllOwners() {
        for (int i2 = this.threadNum - 1; 0 <= i2; --i2) {
            this.threads[i2] = null;
        }
        this.threadNum = 0;
    }

    public final void removeOwner(Thread thread) {
        for (int i2 = 0; i2 < this.threadNum; ++i2) {
            if (this.threads[i2] != thread) continue;
            --this.threadNum;
            System.arraycopy(this.threads, i2 + 1, this.threads, i2, this.threadNum - i2);
            this.threads[this.threadNum] = null;
            return;
        }
        throw new IllegalArgumentException("Not an owner: " + thread);
    }

    String addOwnerToString() {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i2 = 0; i2 < this.threadNum; ++i2) {
            if (i2 > 0) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(this.threads[i2].getName());
        }
        return stringBuilder.toString();
    }
}

