/*
 * Decompiled with CFR 0.152.
 */
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import javax.net.ssl.SSLPeerUnverifiedException;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public final class QD {
    public static final QD a = new QE().a();
    private final Set<QF> a;
    @Nullable
    private final Tp a;

    QD(Set<QF> pins, @Nullable Tp certificateChainCleaner) {
        this.a = pins;
        this.a = certificateChainCleaner;
    }

    public boolean equals(@Nullable Object other) {
        if (other == this) {
            return true;
        }
        return other instanceof QD && Rw.a(this.a, (Object)((QD)other).a) && this.a.equals(((QD)other).a);
    }

    public int hashCode() {
        int result = this.a != null ? this.a.hashCode() : 0;
        result = 31 * result + this.a.hashCode();
        return result;
    }

    public void a(String hostname, List<Certificate> peerCertificates) {
        List<QF> pins = this.a(hostname);
        if (pins.isEmpty()) {
            return;
        }
        if (this.a != null) {
            peerCertificates = this.a.a(peerCertificates, hostname);
        }
        int certsSize = peerCertificates.size();
        for (int c2 = 0; c2 < certsSize; ++c2) {
            X509Certificate x509Certificate = (X509Certificate)peerCertificates.get(c2);
            TQ sha1 = null;
            TQ sha256 = null;
            int pinsSize = pins.size();
            for (int p2 = 0; p2 < pinsSize; ++p2) {
                QF pin = pins.get(p2);
                if (pin.c.equals("sha256/")) {
                    if (sha256 == null) {
                        sha256 = QD.b(x509Certificate);
                    }
                    if (!pin.a.equals(sha256)) continue;
                    return;
                }
                if (pin.c.equals("sha1/")) {
                    if (sha1 == null) {
                        sha1 = QD.a(x509Certificate);
                    }
                    if (!pin.a.equals(sha1)) continue;
                    return;
                }
                throw new AssertionError((Object)("unsupported hashAlgorithm: " + pin.c));
            }
        }
        StringBuilder message = new StringBuilder().append("Certificate pinning failure!").append("\n  Peer certificate chain:");
        int certsSize2 = peerCertificates.size();
        for (int c3 = 0; c3 < certsSize2; ++c3) {
            X509Certificate x509Certificate = (X509Certificate)peerCertificates.get(c3);
            message.append("\n    ").append(QD.a((Certificate)x509Certificate)).append(": ").append(x509Certificate.getSubjectDN().getName());
        }
        message.append("\n  Pinned certificates for ").append(hostname).append(":");
        int pinsSize = pins.size();
        for (int p3 = 0; p3 < pinsSize; ++p3) {
            QF pin = pins.get(p3);
            message.append("\n    ").append(pin);
        }
        throw new SSLPeerUnverifiedException(message.toString());
    }

    List<QF> a(String hostname) {
        List<QF> result = Collections.emptyList();
        Iterator iterator = this.a.iterator();
        while (iterator.hasNext()) {
            QF pin = (QF)iterator.next();
            if (!pin.a(hostname)) continue;
            if (result.isEmpty()) {
                result = new ArrayList<QF>();
            }
            result.add(pin);
        }
        return result;
    }

    QD a(@Nullable Tp certificateChainCleaner) {
        return Rw.a(this.a, (Object)certificateChainCleaner) ? this : new QD((Set<QF>)((Object)this.a), certificateChainCleaner);
    }

    public static String a(Certificate certificate) {
        if (!(certificate instanceof X509Certificate)) {
            throw new IllegalArgumentException("Certificate pinning requires X509 certificates");
        }
        return "sha256/" + QD.b((X509Certificate)certificate).base64();
    }

    static TQ a(X509Certificate x509Certificate) {
        return TQ.of(x509Certificate.getPublicKey().getEncoded()).sha1();
    }

    static TQ b(X509Certificate x509Certificate) {
        return TQ.of(x509Certificate.getPublicKey().getEncoded()).sha256();
    }
}

