/*
 * Decompiled with CFR 0.152.
 */
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import okhttp3.HttpUrl;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public final class QN {
    private static final Pattern a = Pattern.compile("(\\d{2,4})[^\\d]*");
    private static final Pattern b = Pattern.compile("(?i)(jan|feb|mar|apr|may|jun|jul|aug|sep|oct|nov|dec).*");
    private static final Pattern c = Pattern.compile("(\\d{1,2})[^\\d]*");
    private static final Pattern d = Pattern.compile("(\\d{1,2}):(\\d{1,2}):(\\d{1,2})[^\\d]*");
    private final String a;
    private final String b;
    private final long a;
    private final String c;
    private final String d;
    private final boolean a;
    private final boolean b;
    private final boolean c;
    private final boolean d;

    private QN(String name, String value, long expiresAt, String domain, String path, boolean secure, boolean httpOnly, boolean hostOnly, boolean persistent) {
        this.a = name;
        this.b = value;
        this.a = expiresAt;
        this.c = domain;
        this.d = path;
        this.a = secure;
        this.b = httpOnly;
        this.d = hostOnly;
        this.c = persistent;
    }

    public String a() {
        return this.a;
    }

    public String b() {
        return this.b;
    }

    private static boolean a(String urlHost, String domain) {
        if (urlHost.equals(domain)) {
            return true;
        }
        return urlHost.endsWith(domain) && urlHost.charAt(urlHost.length() - domain.length() - 1) == '.' && !Rw.a(urlHost);
    }

    @Nullable
    public static QN a(HttpUrl url, String setCookie) {
        return QN.a(System.currentTimeMillis(), url, setCookie);
    }

    @Nullable
    static QN a(long currentTimeMillis, HttpUrl url, String setCookie) {
        long deltaMilliseconds;
        int pos = 0;
        int limit = setCookie.length();
        int cookiePairEnd = Rw.a(setCookie, pos, limit, ';');
        int pairEqualsSign = Rw.a(setCookie, pos, cookiePairEnd, '=');
        if (pairEqualsSign == cookiePairEnd) {
            return null;
        }
        String cookieName = Rw.a(setCookie, pos, pairEqualsSign);
        if (cookieName.isEmpty() || Rw.a(cookieName) != -1) {
            return null;
        }
        String cookieValue = Rw.a(setCookie, pairEqualsSign + 1, cookiePairEnd);
        if (Rw.a(cookieValue) != -1) {
            return null;
        }
        long expiresAt = 253402300799999L;
        long deltaSeconds = -1L;
        String domain = null;
        String path = null;
        boolean secureOnly = false;
        boolean httpOnly = false;
        boolean hostOnly = true;
        boolean persistent = false;
        pos = cookiePairEnd + 1;
        while (pos < limit) {
            String attributeValue;
            int attributePairEnd = Rw.a(setCookie, pos, limit, ';');
            int attributeEqualsSign = Rw.a(setCookie, pos, attributePairEnd, '=');
            String attributeName = Rw.a(setCookie, pos, attributeEqualsSign);
            String string = attributeValue = attributeEqualsSign < attributePairEnd ? Rw.a(setCookie, attributeEqualsSign + 1, attributePairEnd) : "";
            if (attributeName.equalsIgnoreCase("expires")) {
                try {
                    expiresAt = QN.a(attributeValue, 0, attributeValue.length());
                    persistent = true;
                }
                catch (IllegalArgumentException illegalArgumentException) {}
            } else if (attributeName.equalsIgnoreCase("max-age")) {
                try {
                    deltaSeconds = QN.a(attributeValue);
                    persistent = true;
                }
                catch (NumberFormatException numberFormatException) {}
            } else if (attributeName.equalsIgnoreCase("domain")) {
                try {
                    domain = QN.a(attributeValue);
                    hostOnly = false;
                }
                catch (IllegalArgumentException illegalArgumentException) {}
            } else if (attributeName.equalsIgnoreCase("path")) {
                path = attributeValue;
            } else if (attributeName.equalsIgnoreCase("secure")) {
                secureOnly = true;
            } else if (attributeName.equalsIgnoreCase("httponly")) {
                httpOnly = true;
            }
            pos = attributePairEnd + 1;
        }
        if (deltaSeconds == Long.MIN_VALUE) {
            expiresAt = Long.MIN_VALUE;
        } else if (deltaSeconds != -1L && ((expiresAt = currentTimeMillis + (deltaMilliseconds = deltaSeconds <= 9223372036854775L ? deltaSeconds * 1000L : Long.MAX_VALUE)) < currentTimeMillis || expiresAt > 253402300799999L)) {
            expiresAt = 253402300799999L;
        }
        String urlHost = url.d();
        if (domain == null) {
            domain = urlHost;
        } else if (!QN.a(urlHost, domain)) {
            return null;
        }
        if (urlHost.length() != domain.length() && Tm.a().a(domain) == null) {
            return null;
        }
        if (path == null || !path.startsWith("/")) {
            String encodedPath = url.e();
            int lastSlash = encodedPath.lastIndexOf(47);
            path = lastSlash != 0 ? encodedPath.substring(0, lastSlash) : "/";
        }
        return new QN(cookieName, cookieValue, expiresAt, domain, path, secureOnly, httpOnly, hostOnly, persistent);
    }

    private static long a(String s2, int pos, int limit) {
        pos = QN.a(s2, pos, limit, false);
        int hour = -1;
        int minute = -1;
        int second = -1;
        int dayOfMonth = -1;
        int month = -1;
        int year = -1;
        Matcher matcher = d.matcher(s2);
        while (pos < limit) {
            int end = QN.a(s2, pos + 1, limit, true);
            matcher.region(pos, end);
            if (hour == -1 && matcher.usePattern(d).matches()) {
                hour = Integer.parseInt(matcher.group(1));
                minute = Integer.parseInt(matcher.group(2));
                second = Integer.parseInt(matcher.group(3));
            } else if (dayOfMonth == -1 && matcher.usePattern(c).matches()) {
                dayOfMonth = Integer.parseInt(matcher.group(1));
            } else if (month == -1 && matcher.usePattern(b).matches()) {
                String monthString = matcher.group(1).toLowerCase(Locale.US);
                month = b.pattern().indexOf(monthString) / 4;
            } else if (year == -1 && matcher.usePattern(a).matches()) {
                year = Integer.parseInt(matcher.group(1));
            }
            pos = QN.a(s2, end + 1, limit, false);
        }
        if (year >= 70 && year <= 99) {
            year += 1900;
        }
        if (year >= 0 && year <= 69) {
            year += 2000;
        }
        if (year < 1601) {
            throw new IllegalArgumentException();
        }
        if (month == -1) {
            throw new IllegalArgumentException();
        }
        if (dayOfMonth < 1 || dayOfMonth > 31) {
            throw new IllegalArgumentException();
        }
        if (hour < 0 || hour > 23) {
            throw new IllegalArgumentException();
        }
        if (minute < 0 || minute > 59) {
            throw new IllegalArgumentException();
        }
        if (second < 0 || second > 59) {
            throw new IllegalArgumentException();
        }
        GregorianCalendar calendar = new GregorianCalendar(Rw.a);
        calendar.setLenient(false);
        calendar.set(1, year);
        calendar.set(2, month - 1);
        calendar.set(5, dayOfMonth);
        calendar.set(11, hour);
        calendar.set(12, minute);
        calendar.set(13, second);
        calendar.set(14, 0);
        return calendar.getTimeInMillis();
    }

    private static int a(String input, int pos, int limit, boolean invert) {
        for (int i2 = pos; i2 < limit; ++i2) {
            char c2 = input.charAt(i2);
            boolean dateCharacter = c2 < ' ' && c2 != '\t' || c2 >= '\u007f' || c2 >= '0' && c2 <= '9' || c2 >= 'a' && c2 <= 'z' || c2 >= 'A' && c2 <= 'Z' || c2 == ':';
            if (dateCharacter != !invert) continue;
            return i2;
        }
        return limit;
    }

    private static long a(String s2) {
        try {
            long parsed = Long.parseLong(s2);
            return parsed <= 0L ? Long.MIN_VALUE : parsed;
        }
        catch (NumberFormatException e2) {
            if (s2.matches("-?\\d+")) {
                return s2.startsWith("-") ? Long.MIN_VALUE : Long.MAX_VALUE;
            }
            throw e2;
        }
    }

    private static String a(String s2) {
        String canonicalDomain;
        if (s2.endsWith(".")) {
            throw new IllegalArgumentException();
        }
        if (s2.startsWith(".")) {
            s2 = s2.substring(1);
        }
        if ((canonicalDomain = Rw.a(s2)) == null) {
            throw new IllegalArgumentException();
        }
        return canonicalDomain;
    }

    public static List<QN> a(HttpUrl url, QY headers) {
        List<String> cookieStrings = headers.a("Set-Cookie");
        ArrayList<QN> cookies = null;
        int size = cookieStrings.size();
        for (int i2 = 0; i2 < size; ++i2) {
            QN cookie = QN.a(url, cookieStrings.get(i2));
            if (cookie == null) continue;
            if (cookies == null) {
                cookies = new ArrayList<QN>();
            }
            cookies.add(cookie);
        }
        return cookies != null ? Collections.unmodifiableList(cookies) : Collections.emptyList();
    }

    public String toString() {
        return this.a(false);
    }

    String a(boolean forObsoleteRfc2965) {
        StringBuilder result = new StringBuilder();
        result.append(this.a);
        result.append('=');
        result.append(this.b);
        if (this.c) {
            if (this.a == Long.MIN_VALUE) {
                result.append("; max-age=0");
            } else {
                result.append("; expires=").append(RX.a(new Date(this.a)));
            }
        }
        if (!this.d) {
            result.append("; domain=");
            if (forObsoleteRfc2965) {
                result.append(".");
            }
            result.append(this.c);
        }
        result.append("; path=").append(this.d);
        if (this.a) {
            result.append("; secure");
        }
        if (this.b) {
            result.append("; httponly");
        }
        return result.toString();
    }

    public boolean equals(@Nullable Object other) {
        if (!(other instanceof QN)) {
            return false;
        }
        QN that = (QN)other;
        return that.a.equals(this.a) && that.b.equals(this.b) && that.c.equals(this.c) && that.d.equals(this.d) && that.a == this.a && that.a == this.a && that.b == this.b && that.c == this.c && that.d == this.d;
    }

    public int hashCode() {
        int hash = 17;
        hash = 31 * hash + this.a.hashCode();
        hash = 31 * hash + this.b.hashCode();
        hash = 31 * hash + this.c.hashCode();
        hash = 31 * hash + this.d.hashCode();
        hash = 31 * hash + (int)(this.a ^ this.a >>> 32);
        hash = 31 * hash + (this.a ? 0 : 1);
        hash = 31 * hash + (this.b ? 0 : 1);
        hash = 31 * hash + (this.c ? 0 : 1);
        hash = 31 * hash + (this.d ? 0 : 1);
        return hash;
    }
}

