/*
 * Decompiled with CFR 0.152.
 */
import java.io.EOFException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.ByteChannel;
import java.nio.charset.Charset;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public final class TK
implements TO,
TP,
Cloneable,
ByteChannel {
    private static final byte[] DIGITS = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 97, 98, 99, 100, 101, 102};
    static final int REPLACEMENT_CHARACTER = 65533;
    @Nullable
    Uf head;
    long size;

    public long size() {
        return this.size;
    }

    @Override
    public TK buffer() {
        return this;
    }

    @Override
    public OutputStream outputStream() {
        return new TL(this);
    }

    @Override
    public TK emitCompleteSegments() {
        return this;
    }

    @Override
    public TO emit() {
        return this;
    }

    @Override
    public boolean exhausted() {
        return this.size == 0L;
    }

    @Override
    public void require(long byteCount) {
        if (this.size < byteCount) {
            throw new EOFException();
        }
    }

    public boolean request(long byteCount) {
        return this.size >= byteCount;
    }

    @Override
    public InputStream inputStream() {
        return new TM(this);
    }

    public TK copyTo(OutputStream out) {
        return this.copyTo(out, 0L, this.size);
    }

    public TK copyTo(OutputStream out, long offset, long byteCount) {
        if (out == null) {
            throw new IllegalArgumentException("out == null");
        }
        Um.a(this.size, offset, byteCount);
        if (byteCount == 0L) {
            return this;
        }
        Uf s2 = this.head;
        while (offset >= (long)(s2.b - s2.a)) {
            offset -= (long)(s2.b - s2.a);
            s2 = s2.a;
        }
        while (byteCount > 0L) {
            int pos = (int)((long)s2.a + offset);
            int toCopy = (int)Math.min((long)(s2.b - pos), byteCount);
            out.write(s2.a, pos, toCopy);
            byteCount -= (long)toCopy;
            offset = 0L;
            s2 = s2.a;
        }
        return this;
    }

    public TK copyTo(TK out, long offset, long byteCount) {
        if (out == null) {
            throw new IllegalArgumentException("out == null");
        }
        Um.a(this.size, offset, byteCount);
        if (byteCount == 0L) {
            return this;
        }
        out.size += byteCount;
        Uf s2 = this.head;
        while (offset >= (long)(s2.b - s2.a)) {
            offset -= (long)(s2.b - s2.a);
            s2 = s2.a;
        }
        while (byteCount > 0L) {
            Uf copy = s2.a();
            copy.a = (int)((long)copy.a + offset);
            copy.b = Math.min(copy.a + (int)byteCount, copy.b);
            if (out.head == null) {
                copy.a = copy.b = copy;
                out.head = copy.b;
            } else {
                out.head.b.a(copy);
            }
            byteCount -= (long)(copy.b - copy.a);
            offset = 0L;
            s2 = s2.a;
        }
        return this;
    }

    public TK writeTo(OutputStream out) {
        return this.writeTo(out, this.size);
    }

    public TK writeTo(OutputStream out, long byteCount) {
        if (out == null) {
            throw new IllegalArgumentException("out == null");
        }
        Um.a(this.size, 0L, byteCount);
        Uf s2 = this.head;
        while (byteCount > 0L) {
            int toCopy = (int)Math.min(byteCount, (long)(s2.b - s2.a));
            out.write(s2.a, s2.a, toCopy);
            s2.a += toCopy;
            this.size -= (long)toCopy;
            byteCount -= (long)toCopy;
            if (s2.a != s2.b) continue;
            Uf toRecycle = s2;
            this.head = s2 = toRecycle.c();
            Ug.a(toRecycle);
        }
        return this;
    }

    public TK readFrom(InputStream in2) {
        this.readFrom(in2, Long.MAX_VALUE, true);
        return this;
    }

    public TK readFrom(InputStream in2, long byteCount) {
        if (byteCount < 0L) {
            throw new IllegalArgumentException("byteCount < 0: " + byteCount);
        }
        this.readFrom(in2, byteCount, false);
        return this;
    }

    private void readFrom(InputStream in2, long byteCount, boolean forever) {
        if (in2 == null) {
            throw new IllegalArgumentException("in == null");
        }
        while (byteCount > 0L || forever) {
            Uf tail = this.writableSegment(1);
            int maxToCopy = (int)Math.min(byteCount, (long)(8192 - tail.b));
            int bytesRead = in2.read(tail.a, tail.b, maxToCopy);
            if (bytesRead == -1) {
                if (forever) {
                    return;
                }
                throw new EOFException();
            }
            tail.b += bytesRead;
            this.size += (long)bytesRead;
            byteCount -= (long)bytesRead;
        }
    }

    public long completeSegmentByteCount() {
        long result = this.size;
        if (result == 0L) {
            return 0L;
        }
        Uf tail = this.head.b;
        if (tail.b < 8192 && tail.b) {
            result -= (long)(tail.b - tail.a);
        }
        return result;
    }

    @Override
    public byte readByte() {
        if (this.size == 0L) {
            throw new IllegalStateException("size == 0");
        }
        Uf segment = this.head;
        int pos = segment.a;
        int limit = segment.b;
        byte[] data = segment.a;
        byte b2 = data[pos++];
        --this.size;
        if (pos == limit) {
            this.head = segment.c();
            Ug.a(segment);
        } else {
            segment.a = pos;
        }
        return b2;
    }

    public byte getByte(long pos) {
        Um.a(this.size, pos, 1L);
        if (this.size - pos > pos) {
            Uf s2 = this.head;
            while (true) {
                int segmentByteCount;
                if (pos < (long)(segmentByteCount = s2.b - s2.a)) {
                    return s2.a[s2.a + (int)pos];
                }
                pos -= (long)segmentByteCount;
                s2 = s2.a;
            }
        }
        pos -= this.size;
        Uf s3 = this.head.b;
        while ((pos += (long)(s3.b - s3.a)) < 0L) {
            s3 = s3.b;
        }
        return s3.a[s3.a + (int)pos];
    }

    @Override
    public short readShort() {
        if (this.size < 2L) {
            throw new IllegalStateException("size < 2: " + this.size);
        }
        Uf segment = this.head;
        int limit = segment.b;
        int pos = segment.a;
        if (limit - pos < 2) {
            int s2 = (this.readByte() & 0xFF) << 8 | this.readByte() & 0xFF;
            return (short)s2;
        }
        byte[] data = segment.a;
        int s3 = (data[pos++] & 0xFF) << 8 | data[pos++] & 0xFF;
        this.size -= 2L;
        if (pos == limit) {
            this.head = segment.c();
            Ug.a(segment);
        } else {
            segment.a = pos;
        }
        return (short)s3;
    }

    @Override
    public int readInt() {
        if (this.size < 4L) {
            throw new IllegalStateException("size < 4: " + this.size);
        }
        Uf segment = this.head;
        int limit = segment.b;
        int pos = segment.a;
        if (limit - pos < 4) {
            return (this.readByte() & 0xFF) << 24 | (this.readByte() & 0xFF) << 16 | (this.readByte() & 0xFF) << 8 | this.readByte() & 0xFF;
        }
        byte[] data = segment.a;
        int i2 = (data[pos++] & 0xFF) << 24 | (data[pos++] & 0xFF) << 16 | (data[pos++] & 0xFF) << 8 | data[pos++] & 0xFF;
        this.size -= 4L;
        if (pos == limit) {
            this.head = segment.c();
            Ug.a(segment);
        } else {
            segment.a = pos;
        }
        return i2;
    }

    @Override
    public long readLong() {
        if (this.size < 8L) {
            throw new IllegalStateException("size < 8: " + this.size);
        }
        Uf segment = this.head;
        int limit = segment.b;
        int pos = segment.a;
        if (limit - pos < 8) {
            return ((long)this.readInt() & 0xFFFFFFFFL) << 32 | (long)this.readInt() & 0xFFFFFFFFL;
        }
        byte[] data = segment.a;
        long v2 = ((long)data[pos++] & 0xFFL) << 56 | ((long)data[pos++] & 0xFFL) << 48 | ((long)data[pos++] & 0xFFL) << 40 | ((long)data[pos++] & 0xFFL) << 32 | ((long)data[pos++] & 0xFFL) << 24 | ((long)data[pos++] & 0xFFL) << 16 | ((long)data[pos++] & 0xFFL) << 8 | (long)data[pos++] & 0xFFL;
        this.size -= 8L;
        if (pos == limit) {
            this.head = segment.c();
            Ug.a(segment);
        } else {
            segment.a = pos;
        }
        return v2;
    }

    @Override
    public short readShortLe() {
        return Um.a(this.readShort());
    }

    @Override
    public int readIntLe() {
        return Um.a(this.readInt());
    }

    public long readLongLe() {
        return Um.a(this.readLong());
    }

    public long readDecimalLong() {
        if (this.size == 0L) {
            throw new IllegalStateException("size == 0");
        }
        long value = 0L;
        int seen = 0;
        boolean negative = false;
        boolean done = false;
        long overflowZone = -922337203685477580L;
        long overflowDigit = -7L;
        do {
            Uf segment = this.head;
            byte[] data = segment.a;
            int pos = segment.a;
            int limit = segment.b;
            while (pos < limit) {
                byte b2 = data[pos];
                if (b2 >= 48 && b2 <= 57) {
                    int digit = 48 - b2;
                    if (value < overflowZone || value == overflowZone && (long)digit < overflowDigit) {
                        TK buffer = new TK().writeDecimalLong(value).writeByte(b2);
                        if (!negative) {
                            buffer.readByte();
                        }
                        throw new NumberFormatException("Number too large: " + buffer.readUtf8());
                    }
                    value *= 10L;
                    value += (long)digit;
                } else if (b2 == 45 && seen == 0) {
                    negative = true;
                    --overflowDigit;
                } else {
                    if (seen == 0) {
                        throw new NumberFormatException("Expected leading [0-9] or '-' character but was 0x" + Integer.toHexString(b2));
                    }
                    done = true;
                    break;
                }
                ++pos;
                ++seen;
            }
            if (pos == limit) {
                this.head = segment.c();
                Ug.a(segment);
                continue;
            }
            segment.a = pos;
        } while (!done && this.head != null);
        this.size -= (long)seen;
        return negative ? value : -value;
    }

    @Override
    public long readHexadecimalUnsignedLong() {
        if (this.size == 0L) {
            throw new IllegalStateException("size == 0");
        }
        long value = 0L;
        int seen = 0;
        boolean done = false;
        do {
            Uf segment = this.head;
            byte[] data = segment.a;
            int pos = segment.a;
            int limit = segment.b;
            while (pos < limit) {
                int digit;
                byte b2 = data[pos];
                if (b2 >= 48 && b2 <= 57) {
                    digit = b2 - 48;
                } else if (b2 >= 97 && b2 <= 102) {
                    digit = b2 - 97 + 10;
                } else if (b2 >= 65 && b2 <= 70) {
                    digit = b2 - 65 + 10;
                } else {
                    if (seen == 0) {
                        throw new NumberFormatException("Expected leading [0-9a-fA-F] character but was 0x" + Integer.toHexString(b2));
                    }
                    done = true;
                    break;
                }
                if ((value & 0xF000000000000000L) != 0L) {
                    TK buffer = new TK().writeHexadecimalUnsignedLong(value).writeByte(b2);
                    throw new NumberFormatException("Number too large: " + buffer.readUtf8());
                }
                value <<= 4;
                value |= (long)digit;
                ++pos;
                ++seen;
            }
            if (pos == limit) {
                this.head = segment.c();
                Ug.a(segment);
                continue;
            }
            segment.a = pos;
        } while (!done && this.head != null);
        this.size -= (long)seen;
        return value;
    }

    public TQ readByteString() {
        return new TQ(this.readByteArray());
    }

    @Override
    public TQ readByteString(long byteCount) {
        return new TQ(this.readByteArray(byteCount));
    }

    public int select(Ua options) {
        Uf s2 = this.head;
        if (s2 == null) {
            return options.indexOf(TQ.EMPTY);
        }
        TQ[] byteStrings = options.a;
        int listSize = byteStrings.length;
        for (int i2 = 0; i2 < listSize; ++i2) {
            TQ b2 = byteStrings[i2];
            if (this.size < (long)b2.size() || !this.rangeEquals(s2, s2.a, b2, 0, b2.size())) continue;
            try {
                this.skip(b2.size());
                return i2;
            }
            catch (EOFException e2) {
                throw new AssertionError((Object)e2);
            }
        }
        return -1;
    }

    int selectPrefix(Ua options) {
        Uf s2 = this.head;
        TQ[] byteStrings = options.a;
        int listSize = byteStrings.length;
        for (int i2 = 0; i2 < listSize; ++i2) {
            TQ b2 = byteStrings[i2];
            int bytesLimit = (int)Math.min(this.size, (long)b2.size());
            if (bytesLimit != 0 && !this.rangeEquals(s2, s2.a, b2, 0, bytesLimit)) continue;
            return i2;
        }
        return -1;
    }

    @Override
    public void readFully(TK sink, long byteCount) {
        if (this.size < byteCount) {
            sink.write(this, this.size);
            throw new EOFException();
        }
        sink.write(this, byteCount);
    }

    public long readAll(Ui sink) {
        long byteCount = this.size;
        if (byteCount > 0L) {
            sink.write(this, byteCount);
        }
        return byteCount;
    }

    public String readUtf8() {
        try {
            return this.readString(this.size, Um.a);
        }
        catch (EOFException e2) {
            throw new AssertionError((Object)e2);
        }
    }

    public String readUtf8(long byteCount) {
        return this.readString(byteCount, Um.a);
    }

    @Override
    public String readString(Charset charset) {
        try {
            return this.readString(this.size, charset);
        }
        catch (EOFException e2) {
            throw new AssertionError((Object)e2);
        }
    }

    public String readString(long byteCount, Charset charset) {
        Um.a(this.size, 0L, byteCount);
        if (charset == null) {
            throw new IllegalArgumentException("charset == null");
        }
        if (byteCount > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("byteCount > Integer.MAX_VALUE: " + byteCount);
        }
        if (byteCount == 0L) {
            return "";
        }
        Uf s2 = this.head;
        if ((long)s2.a + byteCount > (long)s2.b) {
            return new String(this.readByteArray(byteCount), charset);
        }
        String result = new String(s2.a, s2.a, (int)byteCount, charset);
        s2.a = (int)((long)s2.a + byteCount);
        this.size -= byteCount;
        if (s2.a == s2.b) {
            this.head = s2.c();
            Ug.a(s2);
        }
        return result;
    }

    @Nullable
    public String readUtf8Line() {
        long newline = this.indexOf((byte)10);
        if (newline == -1L) {
            return this.size != 0L ? this.readUtf8(this.size) : null;
        }
        return this.readUtf8Line(newline);
    }

    @Override
    public String readUtf8LineStrict() {
        return this.readUtf8LineStrict(Long.MAX_VALUE);
    }

    @Override
    public String readUtf8LineStrict(long limit) {
        if (limit < 0L) {
            throw new IllegalArgumentException("limit < 0: " + limit);
        }
        long scanLength = limit == Long.MAX_VALUE ? Long.MAX_VALUE : limit + 1L;
        long newline = this.indexOf((byte)10, 0L, scanLength);
        if (newline != -1L) {
            return this.readUtf8Line(newline);
        }
        if (scanLength < this.size() && this.getByte(scanLength - 1L) == 13 && this.getByte(scanLength) == 10) {
            return this.readUtf8Line(scanLength);
        }
        TK data = new TK();
        this.copyTo(data, 0L, Math.min(32L, this.size()));
        throw new EOFException("\\n not found: limit=" + Math.min(this.size(), limit) + " content=" + data.readByteString().hex() + '\u2026');
    }

    String readUtf8Line(long newline) {
        if (newline > 0L && this.getByte(newline - 1L) == 13) {
            String result = this.readUtf8(newline - 1L);
            this.skip(2L);
            return result;
        }
        String result = this.readUtf8(newline);
        this.skip(1L);
        return result;
    }

    public int readUtf8CodePoint() {
        int min;
        int byteCount;
        int codePoint;
        if (this.size == 0L) {
            throw new EOFException();
        }
        byte b0 = this.getByte(0L);
        if ((b0 & 0x80) == 0) {
            codePoint = b0 & 0x7F;
            byteCount = 1;
            min = 0;
        } else if ((b0 & 0xE0) == 192) {
            codePoint = b0 & 0x1F;
            byteCount = 2;
            min = 128;
        } else if ((b0 & 0xF0) == 224) {
            codePoint = b0 & 0xF;
            byteCount = 3;
            min = 2048;
        } else if ((b0 & 0xF8) == 240) {
            codePoint = b0 & 7;
            byteCount = 4;
            min = 65536;
        } else {
            this.skip(1L);
            return 65533;
        }
        if (this.size < (long)byteCount) {
            throw new EOFException("size < " + byteCount + ": " + this.size + " (to read code point prefixed 0x" + Integer.toHexString(b0) + ")");
        }
        for (int i2 = 1; i2 < byteCount; ++i2) {
            byte b2 = this.getByte(i2);
            if ((b2 & 0xC0) == 128) {
                codePoint <<= 6;
                codePoint |= b2 & 0x3F;
                continue;
            }
            this.skip(i2);
            return 65533;
        }
        this.skip(byteCount);
        if (codePoint > 0x10FFFF) {
            return 65533;
        }
        if (codePoint >= 55296 && codePoint <= 57343) {
            return 65533;
        }
        if (codePoint < min) {
            return 65533;
        }
        return codePoint;
    }

    @Override
    public byte[] readByteArray() {
        try {
            return this.readByteArray(this.size);
        }
        catch (EOFException e2) {
            throw new AssertionError((Object)e2);
        }
    }

    @Override
    public byte[] readByteArray(long byteCount) {
        Um.a(this.size, 0L, byteCount);
        if (byteCount > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("byteCount > Integer.MAX_VALUE: " + byteCount);
        }
        byte[] result = new byte[(int)byteCount];
        this.readFully(result);
        return result;
    }

    public int read(byte[] sink) {
        return this.read(sink, 0, sink.length);
    }

    @Override
    public void readFully(byte[] sink) {
        int read;
        for (int offset = 0; offset < sink.length; offset += read) {
            read = this.read(sink, offset, sink.length - offset);
            if (read != -1) continue;
            throw new EOFException();
        }
    }

    public int read(byte[] sink, int offset, int byteCount) {
        Um.a(sink.length, offset, byteCount);
        Uf s2 = this.head;
        if (s2 == null) {
            return -1;
        }
        int toCopy = Math.min(byteCount, s2.b - s2.a);
        System.arraycopy(s2.a, s2.a, sink, offset, toCopy);
        s2.a += toCopy;
        this.size -= (long)toCopy;
        if (s2.a == s2.b) {
            this.head = s2.c();
            Ug.a(s2);
        }
        return toCopy;
    }

    @Override
    public int read(ByteBuffer sink) {
        Uf s2 = this.head;
        if (s2 == null) {
            return -1;
        }
        int toCopy = Math.min(sink.remaining(), s2.b - s2.a);
        sink.put(s2.a, s2.a, toCopy);
        s2.a += toCopy;
        this.size -= (long)toCopy;
        if (s2.a == s2.b) {
            this.head = s2.c();
            Ug.a(s2);
        }
        return toCopy;
    }

    public void clear() {
        try {
            this.skip(this.size);
        }
        catch (EOFException e2) {
            throw new AssertionError((Object)e2);
        }
    }

    @Override
    public void skip(long byteCount) {
        while (byteCount > 0L) {
            if (this.head == null) {
                throw new EOFException();
            }
            int toSkip = (int)Math.min(byteCount, (long)(this.head.b - this.head.a));
            this.size -= (long)toSkip;
            byteCount -= (long)toSkip;
            this.head.a += toSkip;
            if (this.head.a != this.head.b) continue;
            Uf toRecycle = this.head;
            this.head = toRecycle.c();
            Ug.a(toRecycle);
        }
    }

    @Override
    public TK write(TQ byteString) {
        if (byteString == null) {
            throw new IllegalArgumentException("byteString == null");
        }
        byteString.write(this);
        return this;
    }

    @Override
    public TK writeUtf8(String string) {
        return this.writeUtf8(string, 0, string.length());
    }

    public TK writeUtf8(String string, int beginIndex, int endIndex) {
        if (string == null) {
            throw new IllegalArgumentException("string == null");
        }
        if (beginIndex < 0) {
            throw new IllegalArgumentException("beginIndex < 0: " + beginIndex);
        }
        if (endIndex < beginIndex) {
            throw new IllegalArgumentException("endIndex < beginIndex: " + endIndex + " < " + beginIndex);
        }
        if (endIndex > string.length()) {
            throw new IllegalArgumentException("endIndex > string.length: " + endIndex + " > " + string.length());
        }
        int i2 = beginIndex;
        while (i2 < endIndex) {
            char low;
            char c2 = string.charAt(i2);
            if (c2 < '\u0080') {
                Uf tail = this.writableSegment(1);
                byte[] data = tail.a;
                int segmentOffset = tail.b - i2;
                int runLimit = Math.min(endIndex, 8192 - segmentOffset);
                data[segmentOffset + i2++] = (byte)c2;
                while (i2 < runLimit && (c2 = string.charAt(i2)) < '\u0080') {
                    data[segmentOffset + i2++] = (byte)c2;
                }
                int runSize = i2 + segmentOffset - tail.b;
                tail.b += runSize;
                this.size += (long)runSize;
                continue;
            }
            if (c2 < '\u0800') {
                this.writeByte(c2 >> 6 | 0xC0);
                this.writeByte(c2 & 0x3F | 0x80);
                ++i2;
                continue;
            }
            if (c2 < '\ud800' || c2 > '\udfff') {
                this.writeByte(c2 >> 12 | 0xE0);
                this.writeByte(c2 >> 6 & 0x3F | 0x80);
                this.writeByte(c2 & 0x3F | 0x80);
                ++i2;
                continue;
            }
            char c3 = low = i2 + 1 < endIndex ? string.charAt(i2 + 1) : (char)'\u0000';
            if (c2 > '\udbff' || low < '\udc00' || low > '\udfff') {
                this.writeByte(63);
                ++i2;
                continue;
            }
            int codePoint = 65536 + ((c2 & 0xFFFF27FF) << 10 | low & 0xFFFF23FF);
            this.writeByte(codePoint >> 18 | 0xF0);
            this.writeByte(codePoint >> 12 & 0x3F | 0x80);
            this.writeByte(codePoint >> 6 & 0x3F | 0x80);
            this.writeByte(codePoint & 0x3F | 0x80);
            i2 += 2;
        }
        return this;
    }

    public TK writeUtf8CodePoint(int codePoint) {
        if (codePoint < 128) {
            this.writeByte(codePoint);
        } else if (codePoint < 2048) {
            this.writeByte(codePoint >> 6 | 0xC0);
            this.writeByte(codePoint & 0x3F | 0x80);
        } else if (codePoint < 65536) {
            if (codePoint >= 55296 && codePoint <= 57343) {
                this.writeByte(63);
            } else {
                this.writeByte(codePoint >> 12 | 0xE0);
                this.writeByte(codePoint >> 6 & 0x3F | 0x80);
                this.writeByte(codePoint & 0x3F | 0x80);
            }
        } else if (codePoint <= 0x10FFFF) {
            this.writeByte(codePoint >> 18 | 0xF0);
            this.writeByte(codePoint >> 12 & 0x3F | 0x80);
            this.writeByte(codePoint >> 6 & 0x3F | 0x80);
            this.writeByte(codePoint & 0x3F | 0x80);
        } else {
            throw new IllegalArgumentException("Unexpected code point: " + Integer.toHexString(codePoint));
        }
        return this;
    }

    public TK writeString(String string, Charset charset) {
        return this.writeString(string, 0, string.length(), charset);
    }

    public TK writeString(String string, int beginIndex, int endIndex, Charset charset) {
        if (string == null) {
            throw new IllegalArgumentException("string == null");
        }
        if (beginIndex < 0) {
            throw new IllegalAccessError("beginIndex < 0: " + beginIndex);
        }
        if (endIndex < beginIndex) {
            throw new IllegalArgumentException("endIndex < beginIndex: " + endIndex + " < " + beginIndex);
        }
        if (endIndex > string.length()) {
            throw new IllegalArgumentException("endIndex > string.length: " + endIndex + " > " + string.length());
        }
        if (charset == null) {
            throw new IllegalArgumentException("charset == null");
        }
        if (charset.equals(Um.a)) {
            return this.writeUtf8(string, beginIndex, endIndex);
        }
        byte[] data = string.substring(beginIndex, endIndex).getBytes(charset);
        return this.write(data, 0, data.length);
    }

    @Override
    public TK write(byte[] source) {
        if (source == null) {
            throw new IllegalArgumentException("source == null");
        }
        return this.write(source, 0, source.length);
    }

    @Override
    public TK write(byte[] source, int offset, int byteCount) {
        if (source == null) {
            throw new IllegalArgumentException("source == null");
        }
        Um.a(source.length, offset, byteCount);
        int limit = offset + byteCount;
        while (offset < limit) {
            Uf tail = this.writableSegment(1);
            int toCopy = Math.min(limit - offset, 8192 - tail.b);
            System.arraycopy(source, offset, tail.a, tail.b, toCopy);
            offset += toCopy;
            tail.b += toCopy;
        }
        this.size += (long)byteCount;
        return this;
    }

    @Override
    public int write(ByteBuffer source) {
        int byteCount;
        if (source == null) {
            throw new IllegalArgumentException("source == null");
        }
        int remaining = byteCount = source.remaining();
        while (remaining > 0) {
            Uf tail = this.writableSegment(1);
            int toCopy = Math.min(remaining, 8192 - tail.b);
            source.get(tail.a, tail.b, toCopy);
            remaining -= toCopy;
            tail.b += toCopy;
        }
        this.size += (long)byteCount;
        return byteCount;
    }

    public long writeAll(Uj source) {
        long readCount;
        if (source == null) {
            throw new IllegalArgumentException("source == null");
        }
        long totalBytesRead = 0L;
        while ((readCount = source.read(this, 8192L)) != -1L) {
            totalBytesRead += readCount;
        }
        return totalBytesRead;
    }

    public TO write(Uj source, long byteCount) {
        while (byteCount > 0L) {
            long read = source.read(this, byteCount);
            if (read == -1L) {
                throw new EOFException();
            }
            byteCount -= read;
        }
        return this;
    }

    @Override
    public TK writeByte(int b2) {
        Uf tail = this.writableSegment(1);
        tail.a[tail.b++] = (byte)b2;
        ++this.size;
        return this;
    }

    @Override
    public TK writeShort(int s2) {
        Uf tail = this.writableSegment(2);
        byte[] data = tail.a;
        int limit = tail.b;
        data[limit++] = (byte)(s2 >>> 8 & 0xFF);
        data[limit++] = (byte)(s2 & 0xFF);
        tail.b = limit;
        this.size += 2L;
        return this;
    }

    public TK writeShortLe(int s2) {
        return this.writeShort(Um.a((short)s2));
    }

    @Override
    public TK writeInt(int i2) {
        Uf tail = this.writableSegment(4);
        byte[] data = tail.a;
        int limit = tail.b;
        data[limit++] = (byte)(i2 >>> 24 & 0xFF);
        data[limit++] = (byte)(i2 >>> 16 & 0xFF);
        data[limit++] = (byte)(i2 >>> 8 & 0xFF);
        data[limit++] = (byte)(i2 & 0xFF);
        tail.b = limit;
        this.size += 4L;
        return this;
    }

    public TK writeIntLe(int i2) {
        return this.writeInt(Um.a(i2));
    }

    public TK writeLong(long v2) {
        Uf tail = this.writableSegment(8);
        byte[] data = tail.a;
        int limit = tail.b;
        data[limit++] = (byte)(v2 >>> 56 & 0xFFL);
        data[limit++] = (byte)(v2 >>> 48 & 0xFFL);
        data[limit++] = (byte)(v2 >>> 40 & 0xFFL);
        data[limit++] = (byte)(v2 >>> 32 & 0xFFL);
        data[limit++] = (byte)(v2 >>> 24 & 0xFFL);
        data[limit++] = (byte)(v2 >>> 16 & 0xFFL);
        data[limit++] = (byte)(v2 >>> 8 & 0xFFL);
        data[limit++] = (byte)(v2 & 0xFFL);
        tail.b = limit;
        this.size += 8L;
        return this;
    }

    public TK writeLongLe(long v2) {
        return this.writeLong(Um.a(v2));
    }

    @Override
    public TK writeDecimalLong(long v2) {
        int width;
        if (v2 == 0L) {
            return this.writeByte(48);
        }
        boolean negative = false;
        if (v2 < 0L) {
            if ((v2 = -v2) < 0L) {
                return this.writeUtf8("-9223372036854775808");
            }
            negative = true;
        }
        int n2 = v2 < 100000000L ? (v2 < 10000L ? (v2 < 100L ? (v2 < 10L ? 1 : 2) : (v2 < 1000L ? 3 : 4)) : (v2 < 1000000L ? (v2 < 100000L ? 5 : 6) : (v2 < 10000000L ? 7 : 8))) : (v2 < 1000000000000L ? (v2 < 10000000000L ? (v2 < 1000000000L ? 9 : 10) : (v2 < 100000000000L ? 11 : 12)) : (v2 < 1000000000000000L ? (v2 < 10000000000000L ? 13 : (v2 < 100000000000000L ? 14 : 15)) : (v2 < 100000000000000000L ? (v2 < 10000000000000000L ? 16 : 17) : (width = v2 < 1000000000000000000L ? 18 : 19))));
        if (negative) {
            ++width;
        }
        Uf tail = this.writableSegment(width);
        byte[] data = tail.a;
        int pos = tail.b + width;
        while (v2 != 0L) {
            int digit = (int)(v2 % 10L);
            data[--pos] = DIGITS[digit];
            v2 /= 10L;
        }
        if (negative) {
            data[--pos] = 45;
        }
        tail.b += width;
        this.size += (long)width;
        return this;
    }

    @Override
    public TK writeHexadecimalUnsignedLong(long v2) {
        if (v2 == 0L) {
            return this.writeByte(48);
        }
        int width = Long.numberOfTrailingZeros(Long.highestOneBit(v2)) / 4 + 1;
        Uf tail = this.writableSegment(width);
        byte[] data = tail.a;
        int start = tail.b;
        for (int pos = tail.b + width - 1; pos >= start; --pos) {
            data[pos] = DIGITS[(int)(v2 & 0xFL)];
            v2 >>>= 4;
        }
        tail.b += width;
        this.size += (long)width;
        return this;
    }

    Uf writableSegment(int minimumCapacity) {
        if (minimumCapacity < 1 || minimumCapacity > 8192) {
            throw new IllegalArgumentException();
        }
        if (this.head == null) {
            this.head.a = this.head.b = (this.head = Ug.a());
            return this.head.b;
        }
        Uf tail = this.head.b;
        if (tail.b + minimumCapacity > 8192 || !tail.b) {
            tail = tail.a(Ug.a());
        }
        return tail;
    }

    @Override
    public void write(TK source, long byteCount) {
        if (source == null) {
            throw new IllegalArgumentException("source == null");
        }
        if (source == this) {
            throw new IllegalArgumentException("source == this");
        }
        Um.a(source.size, 0L, byteCount);
        while (byteCount > 0L) {
            if (byteCount < (long)(source.head.b - source.head.a)) {
                Uf tail;
                Uf uf2 = tail = this.head != null ? this.head.b : null;
                if (tail != null && tail.b && byteCount + (long)tail.b - (long)(tail.a ? 0 : tail.a) <= 8192L) {
                    source.head.a(tail, (int)byteCount);
                    source.size -= byteCount;
                    this.size += byteCount;
                    return;
                }
                source.head = source.head.a((int)byteCount);
            }
            Uf segmentToMove = source.head;
            long movedByteCount = segmentToMove.b - segmentToMove.a;
            source.head = segmentToMove.c();
            if (this.head == null) {
                this.head.a = this.head.b = (this.head = segmentToMove);
            } else {
                Uf tail = this.head.b;
                tail = tail.a(segmentToMove);
                tail.a();
            }
            source.size -= movedByteCount;
            this.size += movedByteCount;
            byteCount -= movedByteCount;
        }
    }

    @Override
    public long read(TK sink, long byteCount) {
        if (sink == null) {
            throw new IllegalArgumentException("sink == null");
        }
        if (byteCount < 0L) {
            throw new IllegalArgumentException("byteCount < 0: " + byteCount);
        }
        if (this.size == 0L) {
            return -1L;
        }
        if (byteCount > this.size) {
            byteCount = this.size;
        }
        sink.write(this, byteCount);
        return byteCount;
    }

    @Override
    public long indexOf(byte b2) {
        return this.indexOf(b2, 0L, Long.MAX_VALUE);
    }

    public long indexOf(byte b2, long fromIndex) {
        return this.indexOf(b2, fromIndex, Long.MAX_VALUE);
    }

    public long indexOf(byte b2, long fromIndex, long toIndex) {
        long offset;
        if (fromIndex < 0L || toIndex < fromIndex) {
            throw new IllegalArgumentException(String.format("size=%s fromIndex=%s toIndex=%s", this.size, fromIndex, toIndex));
        }
        if (toIndex > this.size) {
            toIndex = this.size;
        }
        if (fromIndex == toIndex) {
            return -1L;
        }
        Uf s2 = this.head;
        if (s2 == null) {
            return -1L;
        }
        if (this.size - fromIndex < fromIndex) {
            for (offset = this.size; offset > fromIndex; offset -= (long)(s2.b - s2.a)) {
                s2 = s2.b;
            }
        } else {
            long nextOffset;
            offset = 0L;
            while ((nextOffset = offset + (long)(s2.b - s2.a)) < fromIndex) {
                s2 = s2.a;
                offset = nextOffset;
            }
        }
        while (offset < toIndex) {
            byte[] data = s2.a;
            int limit = (int)Math.min((long)s2.b, (long)s2.a + toIndex - offset);
            for (int pos = (int)((long)s2.a + fromIndex - offset); pos < limit; ++pos) {
                if (data[pos] != b2) continue;
                return (long)(pos - s2.a) + offset;
            }
            fromIndex = offset += (long)(s2.b - s2.a);
            s2 = s2.a;
        }
        return -1L;
    }

    public long indexOf(TQ bytes) {
        return this.indexOf(bytes, 0L);
    }

    public long indexOf(TQ bytes, long fromIndex) {
        long offset;
        if (bytes.size() == 0) {
            throw new IllegalArgumentException("bytes is empty");
        }
        if (fromIndex < 0L) {
            throw new IllegalArgumentException("fromIndex < 0");
        }
        Uf s2 = this.head;
        if (s2 == null) {
            return -1L;
        }
        if (this.size - fromIndex < fromIndex) {
            for (offset = this.size; offset > fromIndex; offset -= (long)(s2.b - s2.a)) {
                s2 = s2.b;
            }
        } else {
            long nextOffset;
            offset = 0L;
            while ((nextOffset = offset + (long)(s2.b - s2.a)) < fromIndex) {
                s2 = s2.a;
                offset = nextOffset;
            }
        }
        byte b0 = bytes.getByte(0);
        int bytesSize = bytes.size();
        long resultLimit = this.size - (long)bytesSize + 1L;
        while (offset < resultLimit) {
            byte[] data = s2.a;
            int segmentLimit = (int)Math.min((long)s2.b, (long)s2.a + resultLimit - offset);
            for (int pos = (int)((long)s2.a + fromIndex - offset); pos < segmentLimit; ++pos) {
                if (data[pos] != b0 || !this.rangeEquals(s2, pos + 1, bytes, 1, bytesSize)) continue;
                return (long)(pos - s2.a) + offset;
            }
            fromIndex = offset += (long)(s2.b - s2.a);
            s2 = s2.a;
        }
        return -1L;
    }

    public long indexOfElement(TQ targetBytes) {
        return this.indexOfElement(targetBytes, 0L);
    }

    public long indexOfElement(TQ targetBytes, long fromIndex) {
        long offset;
        if (fromIndex < 0L) {
            throw new IllegalArgumentException("fromIndex < 0");
        }
        Uf s2 = this.head;
        if (s2 == null) {
            return -1L;
        }
        if (this.size - fromIndex < fromIndex) {
            for (offset = this.size; offset > fromIndex; offset -= (long)(s2.b - s2.a)) {
                s2 = s2.b;
            }
        } else {
            long nextOffset;
            offset = 0L;
            while ((nextOffset = offset + (long)(s2.b - s2.a)) < fromIndex) {
                s2 = s2.a;
                offset = nextOffset;
            }
        }
        if (targetBytes.size() == 2) {
            byte b0 = targetBytes.getByte(0);
            byte b1 = targetBytes.getByte(1);
            while (offset < this.size) {
                byte[] data = s2.a;
                int limit = s2.b;
                for (int pos = (int)((long)s2.a + fromIndex - offset); pos < limit; ++pos) {
                    byte b2 = data[pos];
                    if (b2 != b0 && b2 != b1) continue;
                    return (long)(pos - s2.a) + offset;
                }
                fromIndex = offset += (long)(s2.b - s2.a);
                s2 = s2.a;
            }
        } else {
            byte[] targetByteArray = targetBytes.internalArray();
            while (offset < this.size) {
                byte[] data = s2.a;
                int limit = s2.b;
                for (int pos = (int)((long)s2.a + fromIndex - offset); pos < limit; ++pos) {
                    byte b3 = data[pos];
                    for (byte t2 : targetByteArray) {
                        if (b3 != t2) continue;
                        return (long)(pos - s2.a) + offset;
                    }
                }
                fromIndex = offset += (long)(s2.b - s2.a);
                s2 = s2.a;
            }
        }
        return -1L;
    }

    @Override
    public boolean rangeEquals(long offset, TQ bytes) {
        return this.rangeEquals(offset, bytes, 0, bytes.size());
    }

    public boolean rangeEquals(long offset, TQ bytes, int bytesOffset, int byteCount) {
        if (offset < 0L || bytesOffset < 0 || byteCount < 0 || this.size - offset < (long)byteCount || bytes.size() - bytesOffset < byteCount) {
            return false;
        }
        for (int i2 = 0; i2 < byteCount; ++i2) {
            if (this.getByte(offset + (long)i2) == bytes.getByte(bytesOffset + i2)) continue;
            return false;
        }
        return true;
    }

    private boolean rangeEquals(Uf segment, int segmentPos, TQ bytes, int bytesOffset, int bytesLimit) {
        int segmentLimit = segment.b;
        byte[] data = segment.a;
        for (int i2 = bytesOffset; i2 < bytesLimit; ++i2) {
            if (segmentPos == segmentLimit) {
                segment = segment.a;
                data = segment.a;
                segmentPos = segment.a;
                segmentLimit = segment.b;
            }
            if (data[segmentPos] != bytes.getByte(i2)) {
                return false;
            }
            ++segmentPos;
        }
        return true;
    }

    @Override
    public void flush() {
    }

    @Override
    public boolean isOpen() {
        return true;
    }

    @Override
    public void close() {
    }

    @Override
    public Uk timeout() {
        return Uk.a;
    }

    List<Integer> segmentSizes() {
        if (this.head == null) {
            return Collections.emptyList();
        }
        ArrayList<Integer> result = new ArrayList<Integer>();
        result.add(this.head.b - this.head.a);
        Uf s2 = this.head.a;
        while (s2 != this.head) {
            result.add(s2.b - s2.a);
            s2 = s2.a;
        }
        return result;
    }

    public TQ md5() {
        return this.digest("MD5");
    }

    public TQ sha1() {
        return this.digest("SHA-1");
    }

    public TQ sha256() {
        return this.digest("SHA-256");
    }

    public TQ sha512() {
        return this.digest("SHA-512");
    }

    private TQ digest(String algorithm) {
        try {
            MessageDigest messageDigest = MessageDigest.getInstance(algorithm);
            if (this.head != null) {
                messageDigest.update(this.head.a, this.head.a, this.head.b - this.head.a);
                Uf s2 = this.head.a;
                while (s2 != this.head) {
                    messageDigest.update(s2.a, s2.a, s2.b - s2.a);
                    s2 = s2.a;
                }
            }
            return TQ.of(messageDigest.digest());
        }
        catch (NoSuchAlgorithmException e2) {
            throw new AssertionError();
        }
    }

    public TQ hmacSha1(TQ key) {
        return this.hmac("HmacSHA1", key);
    }

    public TQ hmacSha256(TQ key) {
        return this.hmac("HmacSHA256", key);
    }

    public TQ hmacSha512(TQ key) {
        return this.hmac("HmacSHA512", key);
    }

    private TQ hmac(String algorithm, TQ key) {
        try {
            Mac mac = Mac.getInstance(algorithm);
            mac.init(new SecretKeySpec(key.toByteArray(), algorithm));
            if (this.head != null) {
                mac.update(this.head.a, this.head.a, this.head.b - this.head.a);
                Uf s2 = this.head.a;
                while (s2 != this.head) {
                    mac.update(s2.a, s2.a, s2.b - s2.a);
                    s2 = s2.a;
                }
            }
            return TQ.of(mac.doFinal());
        }
        catch (NoSuchAlgorithmException e2) {
            throw new AssertionError();
        }
        catch (InvalidKeyException e3) {
            throw new IllegalArgumentException(e3);
        }
    }

    public boolean equals(Object o2) {
        long count;
        if (this == o2) {
            return true;
        }
        if (!(o2 instanceof TK)) {
            return false;
        }
        TK that = (TK)o2;
        if (this.size != that.size) {
            return false;
        }
        if (this.size == 0L) {
            return true;
        }
        Uf sa2 = this.head;
        Uf sb2 = that.head;
        int posA = sa2.a;
        int posB = sb2.a;
        for (long pos = 0L; pos < this.size; pos += count) {
            count = Math.min(sa2.b - posA, sb2.b - posB);
            int i2 = 0;
            while ((long)i2 < count) {
                if (sa2.a[posA++] != sb2.a[posB++]) {
                    return false;
                }
                ++i2;
            }
            if (posA == sa2.b) {
                sa2 = sa2.a;
                posA = sa2.a;
            }
            if (posB != sb2.b) continue;
            sb2 = sb2.a;
            posB = sb2.a;
        }
        return true;
    }

    public int hashCode() {
        Uf s2 = this.head;
        if (s2 == null) {
            return 0;
        }
        int result = 1;
        do {
            int limit = s2.b;
            for (int pos = s2.a; pos < limit; ++pos) {
                result = 31 * result + s2.a[pos];
            }
        } while ((s2 = s2.a) != this.head);
        return result;
    }

    public String toString() {
        return this.snapshot().toString();
    }

    public TK clone() {
        TK result = new TK();
        if (this.size == 0L) {
            return result;
        }
        result.head.a = result.head.b = (result.head = this.head.a());
        Uf s2 = this.head.a;
        while (s2 != this.head) {
            result.head.b.a(s2.a());
            s2 = s2.a;
        }
        result.size = this.size;
        return result;
    }

    public TQ snapshot() {
        if (this.size > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("size > Integer.MAX_VALUE: " + this.size);
        }
        return this.snapshot((int)this.size);
    }

    public TQ snapshot(int byteCount) {
        if (byteCount == 0) {
            return TQ.EMPTY;
        }
        return new Uh(this, byteCount);
    }

    public TN readUnsafe() {
        return this.readUnsafe(new TN());
    }

    public TN readUnsafe(TN unsafeCursor) {
        if (unsafeCursor.a != null) {
            throw new IllegalStateException("already attached to a buffer");
        }
        unsafeCursor.a = this;
        unsafeCursor.a = false;
        return unsafeCursor;
    }

    public TN readAndWriteUnsafe() {
        return this.readAndWriteUnsafe(new TN());
    }

    public TN readAndWriteUnsafe(TN unsafeCursor) {
        if (unsafeCursor.a != null) {
            throw new IllegalStateException("already attached to a buffer");
        }
        unsafeCursor.a = this;
        unsafeCursor.a = true;
        return unsafeCursor;
    }
}

