/*
 * Decompiled with CFR 0.152.
 */
import java.io.Serializable;
import java.math.RoundingMode;
import org.joda.convert.FromString;

public final class UD
extends Vy
implements Vf,
Serializable {
    public static final UD ZERO = new UD(0L);
    private static final long serialVersionUID = 2471658376918L;

    @FromString
    public static UD parse(String string) {
        return new UD(string);
    }

    public static UD standardDays(long l2) {
        if (l2 == 0L) {
            return ZERO;
        }
        return new UD(WS.a(l2, 86400000));
    }

    public static UD standardHours(long l2) {
        if (l2 == 0L) {
            return ZERO;
        }
        return new UD(WS.a(l2, 3600000));
    }

    public static UD standardMinutes(long l2) {
        if (l2 == 0L) {
            return ZERO;
        }
        return new UD(WS.a(l2, 60000));
    }

    public static UD standardSeconds(long l2) {
        if (l2 == 0L) {
            return ZERO;
        }
        return new UD(WS.a(l2, 1000));
    }

    public static UD millis(long l2) {
        if (l2 == 0L) {
            return ZERO;
        }
        return new UD(l2);
    }

    public UD(long l2) {
        super(l2);
    }

    public UD(long l2, long l3) {
        super(l2, l3);
    }

    public UD(Vg vg2, Vg vg3) {
        super(vg2, vg3);
    }

    public UD(Object object) {
        super(object);
    }

    public long getStandardDays() {
        return this.getMillis() / 86400000L;
    }

    public long getStandardHours() {
        return this.getMillis() / 3600000L;
    }

    public long getStandardMinutes() {
        return this.getMillis() / 60000L;
    }

    public long getStandardSeconds() {
        return this.getMillis() / 1000L;
    }

    @Override
    public UD toDuration() {
        return this;
    }

    public UC toStandardDays() {
        long l2 = this.getStandardDays();
        return UC.days(WS.a(l2));
    }

    public UH toStandardHours() {
        long l2 = this.getStandardHours();
        return UH.hours(WS.a(l2));
    }

    public UT toStandardMinutes() {
        long l2 = this.getStandardMinutes();
        return UT.minutes(WS.a(l2));
    }

    public Vk toStandardSeconds() {
        long l2 = this.getStandardSeconds();
        return Vk.seconds(WS.a(l2));
    }

    public UD withMillis(long l2) {
        if (l2 == this.getMillis()) {
            return this;
        }
        return new UD(l2);
    }

    public UD withDurationAdded(long l2, int n2) {
        if (l2 == 0L || n2 == 0) {
            return this;
        }
        long l3 = WS.a(l2, n2);
        long l4 = WS.a(this.getMillis(), l3);
        return new UD(l4);
    }

    public UD withDurationAdded(Vf vf2, int n2) {
        if (vf2 == null || n2 == 0) {
            return this;
        }
        return this.withDurationAdded(vf2.getMillis(), n2);
    }

    public UD plus(long l2) {
        return this.withDurationAdded(l2, 1);
    }

    public UD plus(Vf vf2) {
        if (vf2 == null) {
            return this;
        }
        return this.withDurationAdded(vf2.getMillis(), 1);
    }

    public UD minus(long l2) {
        return this.withDurationAdded(l2, -1);
    }

    public UD minus(Vf vf2) {
        if (vf2 == null) {
            return this;
        }
        return this.withDurationAdded(vf2.getMillis(), -1);
    }

    public UD multipliedBy(long l2) {
        if (l2 == 1L) {
            return this;
        }
        return new UD(WS.c(this.getMillis(), l2));
    }

    public UD dividedBy(long l2) {
        if (l2 == 1L) {
            return this;
        }
        return new UD(WS.d(this.getMillis(), l2));
    }

    public UD dividedBy(long l2, RoundingMode roundingMode) {
        if (l2 == 1L) {
            return this;
        }
        return new UD(WS.a(this.getMillis(), l2, roundingMode));
    }

    public UD negated() {
        if (this.getMillis() == Long.MIN_VALUE) {
            throw new ArithmeticException("Negation of this duration would overflow");
        }
        return new UD(-this.getMillis());
    }

    public UD abs() {
        if (this.getMillis() < 0L) {
            return this.negated();
        }
        return this;
    }
}

