/*
 * Decompiled with CFR 0.152.
 */
import org.joda.convert.FromString;
import org.joda.convert.ToString;

public final class UT
extends VE {
    public static final UT ZERO = new UT(0);
    public static final UT ONE = new UT(1);
    public static final UT TWO = new UT(2);
    public static final UT THREE = new UT(3);
    public static final UT MAX_VALUE = new UT(Integer.MAX_VALUE);
    public static final UT MIN_VALUE = new UT(Integer.MIN_VALUE);
    private static final XL PARSER = XG.a().a(UZ.minutes());
    private static final long serialVersionUID = 87525275727380863L;

    public static UT minutes(int n2) {
        switch (n2) {
            case 0: {
                return ZERO;
            }
            case 1: {
                return ONE;
            }
            case 2: {
                return TWO;
            }
            case 3: {
                return THREE;
            }
            case 0x7FFFFFFF: {
                return MAX_VALUE;
            }
            case -2147483648: {
                return MIN_VALUE;
            }
        }
        return new UT(n2);
    }

    public static UT minutesBetween(Vg vg2, Vg vg3) {
        int n2 = VE.between(vg2, vg3, UF.minutes());
        return UT.minutes(n2);
    }

    public static UT minutesBetween(Vi vi2, Vi vi3) {
        if (vi2 instanceof UR && vi3 instanceof UR) {
            Un un2 = Uv.a(vi2.getChronology());
            int n2 = un2.minutes().getDifference(((UR)vi3).getLocalMillis(), ((UR)vi2).getLocalMillis());
            return UT.minutes(n2);
        }
        int n3 = VE.between(vi2, vi3, ZERO);
        return UT.minutes(n3);
    }

    public static UT minutesIn(Vh vh2) {
        if (vh2 == null) {
            return ZERO;
        }
        int n2 = VE.between(vh2.getStart(), vh2.getEnd(), UF.minutes());
        return UT.minutes(n2);
    }

    public static UT standardMinutesIn(Vj vj2) {
        int n2 = VE.standardPeriodIn(vj2, 60000L);
        return UT.minutes(n2);
    }

    @FromString
    public static UT parseMinutes(String string) {
        if (string == null) {
            return ZERO;
        }
        UY uY2 = PARSER.a(string);
        return UT.minutes(uY2.getMinutes());
    }

    private UT(int n2) {
        super(n2);
    }

    private Object readResolve() {
        return UT.minutes(this.getValue());
    }

    @Override
    public UF getFieldType() {
        return UF.minutes();
    }

    @Override
    public UZ getPeriodType() {
        return UZ.minutes();
    }

    public Vo toStandardWeeks() {
        return Vo.weeks(this.getValue() / 10080);
    }

    public UC toStandardDays() {
        return UC.days(this.getValue() / 1440);
    }

    public UH toStandardHours() {
        return UH.hours(this.getValue() / 60);
    }

    public Vk toStandardSeconds() {
        return Vk.seconds(WS.b(this.getValue(), 60));
    }

    public UD toStandardDuration() {
        long l2 = this.getValue();
        return new UD(l2 * 60000L);
    }

    public int getMinutes() {
        return this.getValue();
    }

    public UT plus(int n2) {
        if (n2 == 0) {
            return this;
        }
        return UT.minutes(WS.a(this.getValue(), n2));
    }

    public UT plus(UT uT2) {
        if (uT2 == null) {
            return this;
        }
        return this.plus(uT2.getValue());
    }

    public UT minus(int n2) {
        return this.plus(WS.a(n2));
    }

    public UT minus(UT uT2) {
        if (uT2 == null) {
            return this;
        }
        return this.minus(uT2.getValue());
    }

    public UT multipliedBy(int n2) {
        return UT.minutes(WS.b(this.getValue(), n2));
    }

    public UT dividedBy(int n2) {
        if (n2 == 1) {
            return this;
        }
        return UT.minutes(this.getValue() / n2);
    }

    public UT negated() {
        return UT.minutes(WS.a(this.getValue()));
    }

    public boolean isGreaterThan(UT uT2) {
        if (uT2 == null) {
            return this.getValue() > 0;
        }
        return this.getValue() > uT2.getValue();
    }

    public boolean isLessThan(UT uT2) {
        if (uT2 == null) {
            return this.getValue() < 0;
        }
        return this.getValue() < uT2.getValue();
    }

    @ToString
    public String toString() {
        return "PT" + String.valueOf(this.getValue()) + "M";
    }
}

