/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import java.io.Serializable;
import java.util.Locale;
import java.util.Set;
import java.util.TimeZone;
import java.util.concurrent.atomic.AtomicReference;
import org.joda.convert.FromString;
import org.joda.convert.ToString;

public abstract class Uy
implements Serializable {
    private static final long serialVersionUID = 5546345482340108586L;
    public static final Uy UTC = Vn.INSTANCE;
    private static final int MAX_MILLIS = 86399999;
    private static final AtomicReference<Yi> cProvider = new AtomicReference();
    private static final AtomicReference<Yh> cNameProvider = new AtomicReference();
    private static final AtomicReference<Uy> cDefault = new AtomicReference();
    public static final String DEFAULT_TZ_DATA_PATH = "org/joda/time/tz/data";
    private final String iID;

    public static Uy getDefault() {
        Uy uy2 = cDefault.get();
        if (uy2 == null) {
            try {
                try {
                    String string = System.getProperty("user.timezone");
                    if (string != null) {
                        uy2 = Uy.forID(string);
                    }
                }
                catch (RuntimeException runtimeException) {
                    // empty catch block
                }
                if (uy2 == null) {
                    uy2 = Uy.forTimeZone(TimeZone.getDefault());
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            if (uy2 == null) {
                uy2 = UTC;
            }
            if (!cDefault.compareAndSet(null, uy2)) {
                uy2 = cDefault.get();
            }
        }
        return uy2;
    }

    public static void setDefault(Uy uy2) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new UM("DateTimeZone.setDefault"));
        }
        if (uy2 == null) {
            throw new IllegalArgumentException("The datetime zone must not be null");
        }
        cDefault.set(uy2);
    }

    @FromString
    public static Uy forID(String string) {
        if (string == null) {
            return Uy.getDefault();
        }
        if (string.equals("UTC")) {
            return UTC;
        }
        Uy uy2 = Uy.getProvider().a(string);
        if (uy2 != null) {
            return uy2;
        }
        if (string.startsWith("+") || string.startsWith("-")) {
            int n2 = Uy.parseOffset(string);
            if ((long)n2 == 0L) {
                return UTC;
            }
            string = Uy.printOffset(n2);
            return Uy.fixedOffsetZone(string, n2);
        }
        throw new IllegalArgumentException("The datetime zone id '" + string + "' is not recognised");
    }

    public static Uy forOffsetHours(int n2) {
        return Uy.forOffsetHoursMinutes(n2, 0);
    }

    public static Uy forOffsetHoursMinutes(int n2, int n3) {
        if (n2 == 0 && n3 == 0) {
            return UTC;
        }
        if (n2 < -23 || n2 > 23) {
            throw new IllegalArgumentException("Hours out of range: " + n2);
        }
        if (n3 < -59 || n3 > 59) {
            throw new IllegalArgumentException("Minutes out of range: " + n3);
        }
        if (n2 > 0 && n3 < 0) {
            throw new IllegalArgumentException("Positive hours must not have negative minutes: " + n3);
        }
        int n4 = 0;
        try {
            int n5 = n2 * 60;
            n3 = n5 < 0 ? n5 - Math.abs(n3) : n5 + n3;
            n4 = WS.b(n3, 60000);
        }
        catch (ArithmeticException arithmeticException) {
            throw new IllegalArgumentException("Offset is too large");
        }
        return Uy.forOffsetMillis(n4);
    }

    public static Uy forOffsetMillis(int n2) {
        if (n2 < -86399999 || n2 > 86399999) {
            throw new IllegalArgumentException("Millis out of range: " + n2);
        }
        String string = Uy.printOffset(n2);
        return Uy.fixedOffsetZone(string, n2);
    }

    public static Uy forTimeZone(TimeZone timeZone) {
        if (timeZone == null) {
            return Uy.getDefault();
        }
        String string = timeZone.getID();
        if (string == null) {
            throw new IllegalArgumentException("The TimeZone id must not be null");
        }
        if (string.equals("UTC")) {
            return UTC;
        }
        Uy uy2 = null;
        String string2 = Uy.getConvertedId(string);
        Yi yi2 = Uy.getProvider();
        if (string2 != null) {
            uy2 = yi2.a(string2);
        }
        if (uy2 == null) {
            uy2 = yi2.a(string);
        }
        if (uy2 != null) {
            return uy2;
        }
        if (string2 == null && ((string2 = string).startsWith("GMT+") || string2.startsWith("GMT-"))) {
            char c2;
            if ((string2 = string2.substring(3)).length() > 2 && (c2 = (char)string2.charAt(1)) > '9' && Character.isDigit(c2)) {
                string2 = Uy.convertToAsciiNumber(string2);
            }
            if ((long)(c2 = Uy.parseOffset(string2)) == 0L) {
                return UTC;
            }
            string2 = Uy.printOffset(c2);
            return Uy.fixedOffsetZone(string2, c2);
        }
        throw new IllegalArgumentException("The datetime zone id '" + string + "' is not recognised");
    }

    private static String convertToAsciiNumber(String string) {
        StringBuilder stringBuilder = new StringBuilder(string);
        for (int i2 = 0; i2 < stringBuilder.length(); ++i2) {
            char c2 = stringBuilder.charAt(i2);
            int n2 = Character.digit(c2, 10);
            if (n2 < 0) continue;
            stringBuilder.setCharAt(i2, (char)(48 + n2));
        }
        return stringBuilder.toString();
    }

    private static Uy fixedOffsetZone(String string, int n2) {
        if (n2 == 0) {
            return UTC;
        }
        return new Yg(string, null, n2, n2);
    }

    public static Set<String> getAvailableIDs() {
        return Uy.getProvider().a();
    }

    public static Yi getProvider() {
        Yi yi2 = cProvider.get();
        if (yi2 == null && !cProvider.compareAndSet(null, yi2 = Uy.getDefaultProvider())) {
            yi2 = cProvider.get();
        }
        return yi2;
    }

    public static void setProvider(Yi yi2) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new UM("DateTimeZone.setProvider"));
        }
        if (yi2 == null) {
            yi2 = Uy.getDefaultProvider();
        } else {
            Uy.validateProvider(yi2);
        }
        cProvider.set(yi2);
    }

    private static Yi validateProvider(Yi yi2) {
        Set<String> set = yi2.a();
        if (set == null || set.size() == 0) {
            throw new IllegalArgumentException("The provider doesn't have any available ids");
        }
        if (!set.contains("UTC")) {
            throw new IllegalArgumentException("The provider doesn't support UTC");
        }
        if (!UTC.equals(yi2.a("UTC"))) {
            throw new IllegalArgumentException("Invalid UTC zone provided");
        }
        return yi2;
    }

    private static Yi getDefaultProvider() {
        Object object;
        try {
            object = System.getProperty("org.joda.time.DateTimeZone.Provider");
            if (object != null) {
                try {
                    Class<?> clazz = Class.forName((String)object, false, Uy.class.getClassLoader());
                    if (!Yi.class.isAssignableFrom(clazz)) {
                        throw new IllegalArgumentException("System property referred to class that does not implement " + Yi.class);
                    }
                    Yi yi2 = clazz.asSubclass(Yi.class).getConstructor(new Class[0]).newInstance(new Object[0]);
                    return Uy.validateProvider(yi2);
                }
                catch (Exception exception) {
                    throw new RuntimeException(exception);
                }
            }
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        try {
            object = System.getProperty("org.joda.time.DateTimeZone.Folder");
            if (object != null) {
                try {
                    Ym ym2 = new Ym(new File((String)object));
                    return Uy.validateProvider(ym2);
                }
                catch (Exception exception) {
                    throw new RuntimeException(exception);
                }
            }
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        try {
            object = new Ym(DEFAULT_TZ_DATA_PATH);
            return Uy.validateProvider((Yi)object);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return new Yj();
        }
    }

    public static Yh getNameProvider() {
        Yh yh2 = cNameProvider.get();
        if (yh2 == null && !cNameProvider.compareAndSet(null, yh2 = Uy.getDefaultNameProvider())) {
            yh2 = cNameProvider.get();
        }
        return yh2;
    }

    public static void setNameProvider(Yh yh2) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new UM("DateTimeZone.setNameProvider"));
        }
        if (yh2 == null) {
            yh2 = Uy.getDefaultNameProvider();
        }
        cNameProvider.set(yh2);
    }

    private static Yh getDefaultNameProvider() {
        Yh yh2;
        block6: {
            yh2 = null;
            try {
                String string = System.getProperty("org.joda.time.DateTimeZone.NameProvider");
                if (string == null) break block6;
                try {
                    Class<?> clazz = Class.forName(string, false, Uy.class.getClassLoader());
                    if (!Yh.class.isAssignableFrom(clazz)) {
                        throw new IllegalArgumentException("System property referred to class that does not implement " + Yh.class);
                    }
                    yh2 = clazz.asSubclass(Yh.class).getConstructor(new Class[0]).newInstance(new Object[0]);
                }
                catch (Exception exception) {
                    throw new RuntimeException(exception);
                }
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
        if (yh2 == null) {
            yh2 = new Yf();
        }
        return yh2;
    }

    private static String getConvertedId(String string) {
        return Uz.a.get(string);
    }

    private static int parseOffset(String string) {
        return -((int)Uz.a.a(string));
    }

    private static String printOffset(int n2) {
        StringBuffer stringBuffer = new StringBuffer();
        if (n2 >= 0) {
            stringBuffer.append('+');
        } else {
            stringBuffer.append('-');
            n2 = -n2;
        }
        int n3 = n2 / 3600000;
        XD.a(stringBuffer, n3, 2);
        int n4 = (n2 -= n3 * 3600000) / 60000;
        stringBuffer.append(':');
        XD.a(stringBuffer, n4, 2);
        if ((n2 -= n4 * 60000) == 0) {
            return stringBuffer.toString();
        }
        int n5 = n2 / 1000;
        stringBuffer.append(':');
        XD.a(stringBuffer, n5, 2);
        if ((n2 -= n5 * 1000) == 0) {
            return stringBuffer.toString();
        }
        stringBuffer.append('.');
        XD.a(stringBuffer, n2, 3);
        return stringBuffer.toString();
    }

    protected Uy(String string) {
        if (string == null) {
            throw new IllegalArgumentException("Id must not be null");
        }
        this.iID = string;
    }

    @ToString
    public final String getID() {
        return this.iID;
    }

    public abstract String getNameKey(long var1);

    public final String getShortName(long l2) {
        return this.getShortName(l2, null);
    }

    public String getShortName(long l2, Locale locale) {
        String string;
        if (locale == null) {
            locale = Locale.getDefault();
        }
        if ((string = this.getNameKey(l2)) == null) {
            return this.iID;
        }
        Yh yh2 = Uy.getNameProvider();
        String string2 = yh2 instanceof Yf ? ((Yf)yh2).a(locale, this.iID, string, this.isStandardOffset(l2)) : yh2.a(locale, this.iID, string);
        if (string2 != null) {
            return string2;
        }
        return Uy.printOffset(this.getOffset(l2));
    }

    public final String getName(long l2) {
        return this.getName(l2, null);
    }

    public String getName(long l2, Locale locale) {
        String string;
        if (locale == null) {
            locale = Locale.getDefault();
        }
        if ((string = this.getNameKey(l2)) == null) {
            return this.iID;
        }
        Yh yh2 = Uy.getNameProvider();
        String string2 = yh2 instanceof Yf ? ((Yf)yh2).b(locale, this.iID, string, this.isStandardOffset(l2)) : yh2.b(locale, this.iID, string);
        if (string2 != null) {
            return string2;
        }
        return Uy.printOffset(this.getOffset(l2));
    }

    public abstract int getOffset(long var1);

    public final int getOffset(Vg vg2) {
        if (vg2 == null) {
            return this.getOffset(Uv.a());
        }
        return this.getOffset(vg2.getMillis());
    }

    public abstract int getStandardOffset(long var1);

    public boolean isStandardOffset(long l2) {
        return this.getOffset(l2) == this.getStandardOffset(l2);
    }

    public int getOffsetFromLocal(long l2) {
        int n2;
        int n3;
        long l3;
        long l4;
        int n4;
        int n5 = this.getOffset(l2);
        if (n5 != (n4 = this.getOffset(l4 = l2 - (long)n5))) {
            if (n5 - n4 < 0) {
                long l5;
                long l6 = this.nextTransition(l4);
                if (l6 == l2 - (long)n5) {
                    l6 = Long.MAX_VALUE;
                }
                if ((l5 = this.nextTransition(l2 - (long)n4)) == l2 - (long)n4) {
                    l5 = Long.MAX_VALUE;
                }
                if (l6 != l5) {
                    return n5;
                }
            }
        } else if (n5 >= 0 && (l3 = this.previousTransition(l4)) < l4 && l4 - l3 <= (long)(n3 = (n2 = this.getOffset(l3)) - n5)) {
            return n2;
        }
        return n4;
    }

    public long convertUTCToLocal(long l2) {
        int n2 = this.getOffset(l2);
        long l3 = l2 + (long)n2;
        if ((l2 ^ l3) < 0L && (l2 ^ (long)n2) >= 0L) {
            throw new ArithmeticException("Adding time zone offset caused overflow");
        }
        return l3;
    }

    public long convertLocalToUTC(long l2, boolean bl2, long l3) {
        int n2 = this.getOffset(l3);
        long l4 = l2 - (long)n2;
        int n3 = this.getOffset(l4);
        if (n3 == n2) {
            return l4;
        }
        return this.convertLocalToUTC(l2, bl2);
    }

    public long convertLocalToUTC(long l2, boolean bl2) {
        long l3;
        int n2;
        int n3 = this.getOffset(l2);
        if (n3 != (n2 = this.getOffset(l2 - (long)n3)) && (bl2 || n3 < 0)) {
            long l4;
            l3 = this.nextTransition(l2 - (long)n3);
            if (l3 == l2 - (long)n3) {
                l3 = Long.MAX_VALUE;
            }
            if ((l4 = this.nextTransition(l2 - (long)n2)) == l2 - (long)n2) {
                l4 = Long.MAX_VALUE;
            }
            if (l3 != l4) {
                if (bl2) {
                    throw new UJ(l2, this.getID());
                }
                n2 = n3;
            }
        }
        if ((l2 ^ (l3 = l2 - (long)n2)) < 0L && (l2 ^ (long)n2) < 0L) {
            throw new ArithmeticException("Subtracting time zone offset caused overflow");
        }
        return l3;
    }

    public long getMillisKeepLocal(Uy uy2, long l2) {
        if (uy2 == null) {
            uy2 = Uy.getDefault();
        }
        if (uy2 == this) {
            return l2;
        }
        long l3 = this.convertUTCToLocal(l2);
        return uy2.convertLocalToUTC(l3, false, l2);
    }

    public boolean isLocalDateTimeGap(UP uP2) {
        if (this.isFixed()) {
            return false;
        }
        try {
            uP2.toDateTime(this);
            return false;
        }
        catch (UJ uJ2) {
            return true;
        }
    }

    public long adjustOffset(long l2, boolean bl2) {
        long l3;
        long l4 = l2 - 10800000L;
        long l5 = l2 + 10800000L;
        long l6 = this.getOffset(l4);
        if (l6 <= (l3 = (long)this.getOffset(l5))) {
            return l2;
        }
        long l7 = l6 - l3;
        long l8 = this.nextTransition(l4);
        long l9 = l8 - l7;
        long l10 = l8 + l7;
        if (l2 < l9 || l2 >= l10) {
            return l2;
        }
        long l11 = l2 - l9;
        if (l11 >= l7) {
            return bl2 ? l2 : l2 - l7;
        }
        return bl2 ? l2 + l7 : l2;
    }

    public abstract boolean isFixed();

    public abstract long nextTransition(long var1);

    public abstract long previousTransition(long var1);

    public TimeZone toTimeZone() {
        return TimeZone.getTimeZone(this.iID);
    }

    public abstract boolean equals(Object var1);

    public int hashCode() {
        return 57 + this.getID().hashCode();
    }

    public String toString() {
        return this.getID();
    }

    protected Object writeReplace() {
        return new UB(this.iID);
    }
}

