/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.auth;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.Request;
import com.amazonaws.SDKGlobalConfiguration;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSSessionCredentials;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.auth.BasicSessionCredentials;
import com.amazonaws.auth.Signer;
import com.amazonaws.auth.SigningAlgorithm;
import com.amazonaws.event.ProgressInputStream;
import com.amazonaws.internal.SdkDigestInputStream;
import com.amazonaws.util.Base64;
import com.amazonaws.util.HttpUtils;
import com.amazonaws.util.StringUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.net.URI;
import java.security.MessageDigest;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public abstract class AbstractAWSSigner
implements Signer {
    protected String signAndBase64Encode(String data, String key, SigningAlgorithm algorithm) {
        return this.signAndBase64Encode(data.getBytes(StringUtils.UTF8), key, algorithm);
    }

    protected String signAndBase64Encode(byte[] data, String key, SigningAlgorithm algorithm) {
        try {
            byte[] signature = this.sign(data, key.getBytes(StringUtils.UTF8), algorithm);
            return Base64.encodeAsString(signature);
        }
        catch (Exception e2) {
            throw new AmazonClientException("Unable to calculate a request signature: " + e2.getMessage(), e2);
        }
    }

    public byte[] sign(String stringData, byte[] key, SigningAlgorithm algorithm) {
        try {
            byte[] data = stringData.getBytes(StringUtils.UTF8);
            return this.sign(data, key, algorithm);
        }
        catch (Exception e2) {
            throw new AmazonClientException("Unable to calculate a request signature: " + e2.getMessage(), e2);
        }
    }

    protected byte[] sign(byte[] data, byte[] key, SigningAlgorithm algorithm) {
        try {
            Mac mac = Mac.getInstance(algorithm.toString());
            mac.init(new SecretKeySpec(key, algorithm.toString()));
            return mac.doFinal(data);
        }
        catch (Exception e2) {
            throw new AmazonClientException("Unable to calculate a request signature: " + e2.getMessage(), e2);
        }
    }

    public byte[] hash(String text) {
        try {
            MessageDigest md2 = MessageDigest.getInstance("SHA-256");
            md2.update(text.getBytes(StringUtils.UTF8));
            return md2.digest();
        }
        catch (Exception e2) {
            throw new AmazonClientException("Unable to compute hash while signing request: " + e2.getMessage(), e2);
        }
    }

    protected byte[] hash(InputStream input) {
        try {
            MessageDigest md2 = MessageDigest.getInstance("SHA-256");
            SdkDigestInputStream digestInputStream = new SdkDigestInputStream(input, md2);
            byte[] buffer = new byte[1024];
            while (digestInputStream.read(buffer) > -1) {
            }
            return digestInputStream.getMessageDigest().digest();
        }
        catch (Exception e2) {
            throw new AmazonClientException("Unable to compute hash while signing request: " + e2.getMessage(), e2);
        }
    }

    public byte[] hash(byte[] data) {
        try {
            MessageDigest md2 = MessageDigest.getInstance("SHA-256");
            md2.update(data);
            return md2.digest();
        }
        catch (Exception e2) {
            throw new AmazonClientException("Unable to compute hash while signing request: " + e2.getMessage(), e2);
        }
    }

    protected String getCanonicalizedQueryString(Map<String, String> parameters) {
        TreeMap<String, String> sorted = new TreeMap<String, String>();
        for (Map.Entry<String, String> pair : parameters.entrySet()) {
            String key = pair.getKey();
            String value = pair.getValue();
            sorted.put(HttpUtils.urlEncode(key, false), HttpUtils.urlEncode(value, false));
        }
        StringBuilder builder = new StringBuilder();
        Iterator<Map.Entry<String, String>> pairs = sorted.entrySet().iterator();
        while (pairs.hasNext()) {
            Map.Entry<String, String> pair = pairs.next();
            builder.append(pair.getKey());
            builder.append("=");
            builder.append(pair.getValue());
            if (!pairs.hasNext()) continue;
            builder.append("&");
        }
        return builder.toString();
    }

    protected String getCanonicalizedQueryString(Request<?> request) {
        if (HttpUtils.usePayloadForQueryParameters(request)) {
            return "";
        }
        return this.getCanonicalizedQueryString(request.getParameters());
    }

    protected byte[] getBinaryRequestPayload(Request<?> request) {
        if (HttpUtils.usePayloadForQueryParameters(request)) {
            String encodedParameters = HttpUtils.encodeParameters(request);
            if (encodedParameters == null) {
                return new byte[0];
            }
            return encodedParameters.getBytes(StringUtils.UTF8);
        }
        return this.getBinaryRequestPayloadWithoutQueryParams(request);
    }

    protected String getRequestPayload(Request<?> request) {
        return this.newString(this.getBinaryRequestPayload(request));
    }

    protected String getRequestPayloadWithoutQueryParams(Request<?> request) {
        return this.newString(this.getBinaryRequestPayloadWithoutQueryParams(request));
    }

    protected byte[] getBinaryRequestPayloadWithoutQueryParams(Request<?> request) {
        InputStream content = this.getBinaryRequestPayloadStreamWithoutQueryParams(request);
        try {
            int bytesRead;
            AmazonWebServiceRequest req = request.getOriginalRequest();
            content.mark(req == null ? -1 : req.getReadLimit());
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            byte[] buffer = new byte[5120];
            while ((bytesRead = content.read(buffer)) != -1) {
                byteArrayOutputStream.write(buffer, 0, bytesRead);
            }
            byteArrayOutputStream.close();
            content.reset();
            return byteArrayOutputStream.toByteArray();
        }
        catch (Exception e2) {
            throw new AmazonClientException("Unable to read request payload to sign request: " + e2.getMessage(), e2);
        }
    }

    protected InputStream getBinaryRequestPayloadStream(Request<?> request) {
        if (HttpUtils.usePayloadForQueryParameters(request)) {
            String encodedParameters = HttpUtils.encodeParameters(request);
            if (encodedParameters == null) {
                return new ByteArrayInputStream(new byte[0]);
            }
            return new ByteArrayInputStream(encodedParameters.getBytes(StringUtils.UTF8));
        }
        return this.getBinaryRequestPayloadStreamWithoutQueryParams(request);
    }

    protected InputStream getBinaryRequestPayloadStreamWithoutQueryParams(Request<?> request) {
        try {
            InputStream is2 = request.getContent();
            if (is2 == null) {
                return new ByteArrayInputStream(new byte[0]);
            }
            while (is2 instanceof ProgressInputStream) {
                ProgressInputStream pris = (ProgressInputStream)is2;
                is2 = pris.getWrappedInputStream();
            }
            if (!is2.markSupported()) {
                throw new AmazonClientException("Unable to read request payload to sign request.");
            }
            return is2;
        }
        catch (Exception e2) {
            throw new AmazonClientException("Unable to read request payload to sign request: " + e2.getMessage(), e2);
        }
    }

    protected String getCanonicalizedResourcePath(String resourcePath) {
        return this.getCanonicalizedResourcePath(resourcePath, true);
    }

    protected String getCanonicalizedResourcePath(String resourcePath, boolean urlEncode) {
        String value;
        if (resourcePath == null || resourcePath.length() == 0) {
            return "/";
        }
        String string = value = urlEncode ? HttpUtils.urlEncode(resourcePath, true) : resourcePath;
        if (value.startsWith("/")) {
            return value;
        }
        return "/".concat(value);
    }

    protected String getCanonicalizedEndpoint(URI endpoint) {
        String endpointForStringToSign = endpoint.getHost().toLowerCase();
        if (HttpUtils.isUsingNonDefaultPort(endpoint)) {
            endpointForStringToSign = endpointForStringToSign + ":" + endpoint.getPort();
        }
        return endpointForStringToSign;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected AWSCredentials sanitizeCredentials(AWSCredentials credentials) {
        String accessKeyId = null;
        String secretKey = null;
        String token = null;
        AWSCredentials aWSCredentials = credentials;
        synchronized (aWSCredentials) {
            accessKeyId = credentials.getAWSAccessKeyId();
            secretKey = credentials.getAWSSecretKey();
            if (credentials instanceof AWSSessionCredentials) {
                token = ((AWSSessionCredentials)credentials).getSessionToken();
            }
        }
        if (secretKey != null) {
            secretKey = secretKey.trim();
        }
        if (accessKeyId != null) {
            accessKeyId = accessKeyId.trim();
        }
        if (token != null) {
            token = token.trim();
        }
        if (credentials instanceof AWSSessionCredentials) {
            return new BasicSessionCredentials(accessKeyId, secretKey, token);
        }
        return new BasicAWSCredentials(accessKeyId, secretKey);
    }

    protected String newString(byte[] bytes) {
        return new String(bytes, StringUtils.UTF8);
    }

    protected Date getSignatureDate(int offsetInSeconds) {
        return new Date(System.currentTimeMillis() - (long)(offsetInSeconds * 1000));
    }

    @Deprecated
    protected int getTimeOffset(Request<?> request) {
        int globleOffset = SDKGlobalConfiguration.getGlobalTimeOffset();
        return globleOffset == 0 ? request.getTimeOffset() : globleOffset;
    }

    protected abstract void addSessionCredentials(Request<?> var1, AWSSessionCredentials var2);
}

