/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.auth.policy.internal;

import com.amazonaws.AmazonClientException;
import com.amazonaws.auth.policy.Action;
import com.amazonaws.auth.policy.Condition;
import com.amazonaws.auth.policy.Policy;
import com.amazonaws.auth.policy.Principal;
import com.amazonaws.auth.policy.Resource;
import com.amazonaws.auth.policy.Statement;
import com.amazonaws.auth.policy.internal.JsonPolicyWriter$ConditionsByKey;
import com.amazonaws.util.json.Jackson;
import com.fasterxml.jackson.core.JsonGenerator;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JsonPolicyWriter {
    private JsonGenerator generator = null;
    private Writer writer = new StringWriter();
    private static final Log log = LogFactory.getLog("com.amazonaws.auth.policy");

    public JsonPolicyWriter() {
        try {
            this.generator = Jackson.jsonGeneratorOf(this.writer);
        }
        catch (IOException ioe) {
            throw new AmazonClientException("Unable to instantiate JsonGenerator.", ioe);
        }
    }

    public String writePolicyToString(Policy policy) {
        if (!this.isNotNull(policy)) {
            throw new IllegalArgumentException("Policy cannot be null");
        }
        try {
            String string = this.jsonStringOf(policy);
            return string;
        }
        catch (Exception e2) {
            String message = "Unable to serialize policy to JSON string: " + e2.getMessage();
            throw new IllegalArgumentException(message, e2);
        }
        finally {
            try {
                this.writer.close();
            }
            catch (Exception exception) {}
        }
    }

    private String jsonStringOf(Policy policy) {
        this.generator.c();
        this.writeJsonKeyValue("Version", policy.getVersion());
        if (this.isNotNull(policy.getId())) {
            this.writeJsonKeyValue("Id", policy.getId());
        }
        this.writeJsonArrayStart("Statement");
        for (Statement statement : policy.getStatements()) {
            List<Condition> conditions;
            List<Resource> resources;
            List<Action> actions;
            this.generator.c();
            if (this.isNotNull(statement.getId())) {
                this.writeJsonKeyValue("Sid", statement.getId());
            }
            this.writeJsonKeyValue("Effect", statement.getEffect().toString());
            List<Principal> principals = statement.getPrincipals();
            if (this.isNotNull(principals) && !principals.isEmpty()) {
                this.writePrincipals(principals);
            }
            if (this.isNotNull(actions = statement.getActions()) && !actions.isEmpty()) {
                this.writeActions(actions);
            }
            if (this.isNotNull(resources = statement.getResources()) && !resources.isEmpty()) {
                this.writeResources(resources);
            }
            if (this.isNotNull(conditions = statement.getConditions()) && !conditions.isEmpty()) {
                this.writeConditions(conditions);
            }
            this.generator.d();
        }
        this.writeJsonArrayEnd();
        this.generator.d();
        this.generator.flush();
        return this.writer.toString();
    }

    private void writeConditions(List<Condition> conditions) {
        Map<String, JsonPolicyWriter$ConditionsByKey> conditionsByType = this.groupConditionsByTypeAndKey(conditions);
        this.writeJsonObjectStart("Condition");
        for (Map.Entry<String, JsonPolicyWriter$ConditionsByKey> entry : conditionsByType.entrySet()) {
            JsonPolicyWriter$ConditionsByKey conditionsByKey = conditionsByType.get(entry.getKey());
            this.writeJsonObjectStart(entry.getKey());
            for (String key : conditionsByKey.keySet()) {
                this.writeJsonArray(key, conditionsByKey.getConditionsByKey(key));
            }
            this.writeJsonObjectEnd();
        }
        this.writeJsonObjectEnd();
    }

    private void writeResources(List<Resource> resources) {
        ArrayList<String> resourceStrings = new ArrayList<String>();
        for (Resource resource : resources) {
            resourceStrings.add(resource.getId());
        }
        this.writeJsonArray("Resource", resourceStrings);
    }

    private void writeActions(List<Action> actions) {
        ArrayList<String> actionStrings = new ArrayList<String>();
        for (Action action : actions) {
            actionStrings.add(action.getActionName());
        }
        this.writeJsonArray("Action", actionStrings);
    }

    private void writePrincipals(List<Principal> principals) {
        if (principals.size() == 1 && principals.get(0).equals(Principal.All)) {
            this.writeJsonKeyValue("Principal", Principal.All.getId());
        } else {
            this.writeJsonObjectStart("Principal");
            Map<String, List<String>> principalsByScheme = this.groupPrincipalByScheme(principals);
            for (Map.Entry<String, List<String>> entry : principalsByScheme.entrySet()) {
                List<String> principalValues = principalsByScheme.get(entry.getKey());
                if (principalValues.size() == 1) {
                    this.writeJsonKeyValue(entry.getKey(), principalValues.get(0));
                    continue;
                }
                this.writeJsonArray(entry.getKey(), principalValues);
            }
            this.writeJsonObjectEnd();
        }
    }

    private Map<String, List<String>> groupPrincipalByScheme(List<Principal> principals) {
        HashMap<String, List<String>> principalsByScheme = new HashMap<String, List<String>>();
        for (Principal principal : principals) {
            String provider = principal.getProvider();
            if (!principalsByScheme.containsKey(provider)) {
                principalsByScheme.put(provider, new ArrayList());
            }
            List principalValues = (List)principalsByScheme.get(provider);
            principalValues.add(principal.getId());
        }
        return principalsByScheme;
    }

    private Map<String, JsonPolicyWriter$ConditionsByKey> groupConditionsByTypeAndKey(List<Condition> conditions) {
        HashMap<String, JsonPolicyWriter$ConditionsByKey> conditionsByType = new HashMap<String, JsonPolicyWriter$ConditionsByKey>();
        for (Condition condition : conditions) {
            String type = condition.getType();
            String key = condition.getConditionKey();
            if (!conditionsByType.containsKey(type)) {
                conditionsByType.put(type, new JsonPolicyWriter$ConditionsByKey());
            }
            JsonPolicyWriter$ConditionsByKey conditionsByKey = (JsonPolicyWriter$ConditionsByKey)conditionsByType.get(type);
            conditionsByKey.addValuesToKey(key, condition.getValues());
        }
        return conditionsByType;
    }

    private void writeJsonArray(String arrayName, List<String> values) {
        this.writeJsonArrayStart(arrayName);
        for (String value : values) {
            this.generator.b(value);
        }
        this.writeJsonArrayEnd();
    }

    private void writeJsonObjectStart(String fieldName) {
        this.generator.g(fieldName);
    }

    private void writeJsonObjectEnd() {
        this.generator.d();
    }

    private void writeJsonArrayStart(String fieldName) {
        this.generator.f(fieldName);
    }

    private void writeJsonArrayEnd() {
        this.generator.b();
    }

    private void writeJsonKeyValue(String fieldName, String value) {
        this.generator.a(fieldName, value);
    }

    private boolean isNotNull(Object object) {
        return null != object;
    }
}

