/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.auth.profile;

import com.amazonaws.AmazonClientException;
import com.amazonaws.auth.profile.internal.AbstractProfilesConfigFileScanner;
import com.amazonaws.auth.profile.internal.Profile;
import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Scanner;
import java.util.Set;

class ProfilesConfigFileWriter$ProfilesConfigFileWriterHelper
extends AbstractProfilesConfigFileScanner {
    private final Writer writer;
    private final Map<String, Profile> newProfiles = new LinkedHashMap<String, Profile>();
    private final Set<String> deletedProfiles = new HashSet<String>();
    private final StringBuilder buffer = new StringBuilder();
    private final Map<String, Set<String>> existingProfileProperties = new HashMap<String, Set<String>>();

    public ProfilesConfigFileWriter$ProfilesConfigFileWriterHelper(Writer writer, Map<String, Profile> modifications) {
        this.writer = writer;
        for (Map.Entry<String, Profile> entry : modifications.entrySet()) {
            String profileName = entry.getKey();
            Profile profile = entry.getValue();
            if (profile == null) {
                this.deletedProfiles.add(profileName);
                continue;
            }
            this.newProfiles.put(profileName, profile);
        }
    }

    public void writeWithoutExistingContent() {
        this.buffer.setLength(0);
        this.existingProfileProperties.clear();
        this.run(new Scanner(""));
    }

    public void writeWithExistingContent(Scanner existingContent) {
        this.buffer.setLength(0);
        this.existingProfileProperties.clear();
        this.run(existingContent);
    }

    @Override
    public void onEmptyOrCommentLine(String profileName, String line) {
        if (profileName == null || !this.deletedProfiles.contains(profileName)) {
            this.buffer(line);
        }
    }

    @Override
    public void onProfileStartingLine(String profileName, String line) {
        String newProfileName;
        this.existingProfileProperties.put(profileName, new HashSet());
        this.flush();
        if (this.deletedProfiles.contains(profileName)) {
            return;
        }
        if (this.newProfiles.get(profileName) != null && !(newProfileName = this.newProfiles.get(profileName).getProfileName()).equals(profileName)) {
            line = "[" + newProfileName + "]";
        }
        this.writeLine(line);
    }

    @Override
    public void onProfileEndingLine(String prevProfileName) {
        Profile modifiedProfile = this.newProfiles.get(prevProfileName);
        if (modifiedProfile != null) {
            for (Map.Entry<String, String> entry : modifiedProfile.getProperties().entrySet()) {
                String propertyKey = entry.getKey();
                String propertyValue = entry.getValue();
                if (this.existingProfileProperties.get(prevProfileName).contains(propertyKey)) continue;
                this.writeProperty(propertyKey, propertyValue);
            }
        }
        this.flush();
    }

    @Override
    public void onProfileProperty(String profileName, String propertyKey, String propertyValue, boolean isSupportedProperty, String line) {
        if (this.existingProfileProperties.get(profileName) == null) {
            this.existingProfileProperties.put(profileName, new HashSet());
        }
        this.existingProfileProperties.get(profileName).add(propertyKey);
        if (this.deletedProfiles.contains(profileName)) {
            return;
        }
        if (!isSupportedProperty) {
            this.writeLine(line);
            return;
        }
        this.flush();
        if (this.newProfiles.containsKey(profileName)) {
            String newValue = this.newProfiles.get(profileName).getPropertyValue(propertyKey);
            if (newValue != null) {
                this.writeProperty(propertyKey, newValue);
            }
        } else {
            this.writeLine(line);
        }
    }

    @Override
    public void onEndOfFile() {
        for (Map.Entry<String, Profile> entry : this.newProfiles.entrySet()) {
            String profileName = entry.getKey();
            Profile profile = entry.getValue();
            if (this.existingProfileProperties.containsKey(profileName)) continue;
            this.writeProfile(profile);
            this.writeLine("");
        }
        try {
            this.writer.flush();
        }
        catch (IOException ioe) {
            throw new AmazonClientException("Unable to write to the target file to persist the profile credentials.", ioe);
        }
    }

    private void writeProfile(Profile profile) {
        this.writeProfileName(profile.getProfileName());
        for (Map.Entry<String, String> entry : profile.getProperties().entrySet()) {
            this.writeProperty(entry.getKey(), entry.getValue());
        }
    }

    private void writeProfileName(String profileName) {
        this.writeLine(String.format("[%s]", profileName));
    }

    private void writeProperty(String propertyKey, String propertyValue) {
        this.writeLine(String.format("%s=%s", propertyKey, propertyValue));
    }

    private void writeLine(String line) {
        this.append(String.format("%s%n", line));
    }

    private void append(String str) {
        try {
            this.writer.append(str);
        }
        catch (IOException ioe) {
            throw new AmazonClientException("Unable to write to the target file to persist the profile credentials.", ioe);
        }
    }

    private void flush() {
        if (this.buffer.length() != 0) {
            this.append(this.buffer.toString());
            this.buffer.setLength(0);
        }
    }

    private void buffer(String line) {
        this.buffer.append(String.format("%s%n", line));
    }
}

