/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.event;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.event.ProgressListener;
import com.amazonaws.event.RequestProgressInputStream;
import com.amazonaws.event.ResponseProgressInputStream;
import com.amazonaws.internal.SdkFilterInputStream;
import java.io.InputStream;
import org.apache.http.annotation.NotThreadSafe;

@NotThreadSafe
public abstract class ProgressInputStream
extends SdkFilterInputStream {
    private static final int DEFAULT_NOTIFICATION_THRESHOLD = 8192;
    private final ProgressListener listener;
    private final int notifyThresHold;
    private int unnotifiedByteCount;
    private boolean hasBeenRead;
    private boolean doneEOF;
    private long notifiedByteCount;

    public static InputStream inputStreamForRequest(InputStream is2, AmazonWebServiceRequest req) {
        return req == null ? is2 : new RequestProgressInputStream(is2, req.getGeneralProgressListener());
    }

    public static InputStream inputStreamForResponse(InputStream is2, AmazonWebServiceRequest req) {
        return req == null ? is2 : new ResponseProgressInputStream(is2, req.getGeneralProgressListener());
    }

    public ProgressInputStream(InputStream is2, ProgressListener listener) {
        this(is2, listener, 8192);
    }

    public ProgressInputStream(InputStream is2, ProgressListener listener, int notifyThresHold) {
        super(is2);
        if (is2 == null || listener == null) {
            throw new IllegalArgumentException();
        }
        this.notifyThresHold = notifyThresHold;
        this.listener = listener;
    }

    protected void onFirstRead() {
    }

    protected void onEOF() {
    }

    protected void onClose() {
        this.eof();
    }

    protected void onReset() {
    }

    protected void onNotifyBytesRead() {
    }

    private void onBytesRead(int bytesRead) {
        this.unnotifiedByteCount += bytesRead;
        if (this.unnotifiedByteCount >= this.notifyThresHold) {
            this.onNotifyBytesRead();
            this.notifiedByteCount += (long)this.unnotifiedByteCount;
            this.unnotifiedByteCount = 0;
        }
    }

    @Override
    public int read() {
        int ch2;
        if (!this.hasBeenRead) {
            this.onFirstRead();
            this.hasBeenRead = true;
        }
        if ((ch2 = super.read()) == -1) {
            this.eof();
        } else {
            this.onBytesRead(1);
        }
        return ch2;
    }

    @Override
    public void reset() {
        super.reset();
        this.onReset();
        this.unnotifiedByteCount = 0;
        this.notifiedByteCount = 0L;
    }

    @Override
    public int read(byte[] b2, int off, int len) {
        int bytesRead;
        if (!this.hasBeenRead) {
            this.onFirstRead();
            this.hasBeenRead = true;
        }
        if ((bytesRead = super.read(b2, off, len)) == -1) {
            this.eof();
        } else {
            this.onBytesRead(bytesRead);
        }
        return bytesRead;
    }

    private void eof() {
        if (this.doneEOF) {
            return;
        }
        this.onEOF();
        this.unnotifiedByteCount = 0;
        this.doneEOF = true;
    }

    public final InputStream getWrappedInputStream() {
        return this.in;
    }

    protected final int getUnnotifiedByteCount() {
        return this.unnotifiedByteCount;
    }

    protected final long getNotifiedByteCount() {
        return this.notifiedByteCount;
    }

    @Override
    public void close() {
        this.onClose();
        super.close();
    }

    public final ProgressListener getListener() {
        return this.listener;
    }
}

