/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.internal;

import com.amazonaws.AbortedException;
import com.amazonaws.internal.MetricAware;
import com.amazonaws.util.SdkRuntime;
import java.io.BufferedInputStream;
import java.io.InputStream;

public class SdkBufferedInputStream
extends BufferedInputStream
implements MetricAware {
    public SdkBufferedInputStream(InputStream in2) {
        super(in2);
    }

    public SdkBufferedInputStream(InputStream in2, int size) {
        super(in2, size);
    }

    @Override
    public boolean isMetricActivated() {
        if (this.in instanceof MetricAware) {
            MetricAware metricAware = (MetricAware)((Object)this.in);
            return metricAware.isMetricActivated();
        }
        return false;
    }

    protected final void abortIfNeeded() {
        if (SdkRuntime.shouldAbort()) {
            this.abort();
            throw new AbortedException();
        }
    }

    protected void abort() {
    }

    @Override
    public int read() {
        this.abortIfNeeded();
        return super.read();
    }

    @Override
    public int read(byte[] b2, int off, int len) {
        this.abortIfNeeded();
        return super.read(b2, off, len);
    }

    @Override
    public long skip(long n2) {
        this.abortIfNeeded();
        return super.skip(n2);
    }

    @Override
    public int available() {
        this.abortIfNeeded();
        return super.available();
    }

    @Override
    public void close() {
        super.close();
        this.abortIfNeeded();
    }

    @Override
    public void mark(int readlimit) {
        this.abortIfNeeded();
        super.mark(readlimit);
    }

    @Override
    public void reset() {
        this.abortIfNeeded();
        super.reset();
    }

    @Override
    public boolean markSupported() {
        this.abortIfNeeded();
        return super.markSupported();
    }
}

