/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.internal;

import com.amazonaws.internal.MetricAware;
import com.amazonaws.internal.Releasable;
import com.amazonaws.util.IOUtils;
import java.io.InputStream;
import java.security.DigestInputStream;
import java.security.MessageDigest;

public class SdkDigestInputStream
extends DigestInputStream
implements MetricAware,
Releasable {
    private static final int SKIP_BUF_SIZE = 2048;

    public SdkDigestInputStream(InputStream stream, MessageDigest digest) {
        super(stream, digest);
    }

    @Override
    public final boolean isMetricActivated() {
        if (this.in instanceof MetricAware) {
            MetricAware metricAware = (MetricAware)((Object)this.in);
            return metricAware.isMetricActivated();
        }
        return false;
    }

    @Override
    public final long skip(long n2) {
        long m2;
        int len;
        if (n2 <= 0L) {
            return n2;
        }
        byte[] b2 = new byte[(int)Math.min(2048L, n2)];
        for (m2 = n2; m2 > 0L; m2 -= (long)len) {
            len = this.read(b2, 0, (int)Math.min(m2, (long)b2.length));
            if (len != -1) continue;
            return m2 == n2 ? -1L : n2 - m2;
        }
        assert (m2 == 0L);
        return n2;
    }

    @Override
    public final void release() {
        IOUtils.closeQuietly(this, null);
        if (this.in instanceof Releasable) {
            Releasable r2 = (Releasable)((Object)this.in);
            r2.release();
        }
    }
}

