/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.internal;

import com.amazonaws.AbortedException;
import com.amazonaws.internal.MetricAware;
import com.amazonaws.internal.Releasable;
import com.amazonaws.util.IOUtils;
import com.amazonaws.util.SdkRuntime;
import java.io.FilterInputStream;
import java.io.InputStream;

public class SdkFilterInputStream
extends FilterInputStream
implements MetricAware,
Releasable {
    protected SdkFilterInputStream(InputStream in2) {
        super(in2);
    }

    @Override
    public boolean isMetricActivated() {
        if (this.in instanceof MetricAware) {
            MetricAware metricAware = (MetricAware)((Object)this.in);
            return metricAware.isMetricActivated();
        }
        return false;
    }

    protected final void abortIfNeeded() {
        if (SdkRuntime.shouldAbort()) {
            this.abort();
            throw new AbortedException();
        }
    }

    protected void abort() {
    }

    @Override
    public int read() {
        this.abortIfNeeded();
        return this.in.read();
    }

    @Override
    public int read(byte[] b2, int off, int len) {
        this.abortIfNeeded();
        return this.in.read(b2, off, len);
    }

    @Override
    public long skip(long n2) {
        this.abortIfNeeded();
        return this.in.skip(n2);
    }

    @Override
    public int available() {
        this.abortIfNeeded();
        return this.in.available();
    }

    @Override
    public void close() {
        this.in.close();
        this.abortIfNeeded();
    }

    @Override
    public synchronized void mark(int readlimit) {
        this.abortIfNeeded();
        this.in.mark(readlimit);
    }

    @Override
    public synchronized void reset() {
        this.abortIfNeeded();
        this.in.reset();
    }

    @Override
    public boolean markSupported() {
        this.abortIfNeeded();
        return this.in.markSupported();
    }

    @Override
    public void release() {
        IOUtils.closeQuietly(this, null);
        if (this.in instanceof Releasable) {
            Releasable r2 = (Releasable)((Object)this.in);
            r2.release();
        }
    }
}

