/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.jmx;

import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import org.apache.commons.logging.LogFactory;

public enum MBeans {


    public static <T> boolean registerMBean(String objectName, T mbean) {
        MBeanServer server = MBeans.getMBeanServer();
        try {
            server.registerMBean(mbean, new ObjectName(objectName));
        }
        catch (MalformedObjectNameException e2) {
            throw new IllegalArgumentException(e2);
        }
        catch (NotCompliantMBeanException e3) {
            throw new IllegalArgumentException(e3);
        }
        catch (InstanceAlreadyExistsException e4) {
            LogFactory.getLog(MBeans.class).debug("Failed to register mbean " + objectName, e4);
            return false;
        }
        return true;
    }

    public static <T> boolean unregisterMBean(String objectName) {
        MBeanServer server = MBeans.getMBeanServer();
        try {
            server.unregisterMBean(new ObjectName(objectName));
        }
        catch (MalformedObjectNameException e2) {
            throw new IllegalArgumentException(e2);
        }
        catch (InstanceNotFoundException e3) {
            LogFactory.getLog(MBeans.class).debug("Failed to unregister mbean " + objectName, e3);
            return false;
        }
        return true;
    }

    public static boolean isRegistered(String objectName) {
        MBeanServer server = MBeans.getMBeanServer();
        try {
            return server.isRegistered(new ObjectName(objectName));
        }
        catch (MalformedObjectNameException e2) {
            throw new IllegalArgumentException(e2);
        }
    }

    public static MBeanServer getMBeanServer() {
        ArrayList<MBeanServer> servers = MBeanServerFactory.findMBeanServer(null);
        MBeanServer server = servers.size() > 0 ? (MBeanServer)servers.get(0) : ManagementFactory.getPlatformMBeanServer();
        return server;
    }
}

