/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.metrics;

import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.PropertiesCredentials;
import com.amazonaws.jmx.spi.SdkMBeanRegistry;
import com.amazonaws.jmx.spi.SdkMBeanRegistry$Factory;
import com.amazonaws.metrics.AwsSdkMetrics$1;
import com.amazonaws.metrics.AwsSdkMetrics$MetricRegistry;
import com.amazonaws.metrics.MetricCollector;
import com.amazonaws.metrics.MetricCollector$Factory;
import com.amazonaws.metrics.MetricType;
import com.amazonaws.metrics.RequestMetricCollector;
import com.amazonaws.metrics.ServiceMetricCollector;
import com.amazonaws.regions.Regions;
import java.io.File;
import java.util.Collection;
import java.util.Set;
import org.apache.commons.logging.LogFactory;

public enum AwsSdkMetrics {

    public static final String DEFAULT_METRIC_NAMESPACE = "AWSSDK/Java";
    private static final String MBEAN_OBJECT_NAME = "com.amazonaws.management:type=" + AwsSdkMetrics.class.getSimpleName();
    public static final String USE_SINGLE_METRIC_NAMESPACE = "useSingleMetricNamespace";
    public static final String EXCLUDE_MACHINE_METRICS = "excludeMachineMetrics";
    public static final String INCLUDE_PER_HOST_METRICS = "includePerHostMetrics";
    public static final String AWS_CREDENTAIL_PROPERTIES_FILE = "credentialFile";
    public static final String CLOUDWATCH_REGION = "cloudwatchRegion";
    public static final String METRIC_QUEUE_SIZE = "metricQueueSize";
    public static final String QUEUE_POLL_TIMEOUT_MILLI = "getQueuePollTimeoutMilli";
    public static final String METRIC_NAME_SPACE = "metricNameSpace";
    public static final String JVM_METRIC_NAME = "jvmMetricName";
    public static final String HOST_METRIC_NAME = "hostMetricName";
    private static final String DEFAULT_METRIC_COLLECTOR_FACTORY = "com.amazonaws.metrics.internal.cloudwatch.DefaultMetricCollectorFactory";
    private static final boolean defaultMetricsEnabled;
    private static volatile AWSCredentialsProvider credentialProvider;
    private static volatile boolean machineMetricsExcluded;
    private static volatile boolean perHostMetricsIncluded;
    private static volatile Regions region;
    private static volatile Integer metricQueueSize;
    private static volatile Long queuePollTimeoutMilli;
    private static volatile String metricNameSpace;
    private static volatile String credentialFile;
    private static volatile String jvmMetricName;
    private static volatile String hostMetricName;
    private static volatile boolean singleMetricNamespace;
    private static final AwsSdkMetrics$MetricRegistry registry;
    private static volatile MetricCollector mc;
    private static boolean dirtyEnabling;

    public static boolean isMetricAdminMBeanRegistered() {
        SdkMBeanRegistry registry = SdkMBeanRegistry$Factory.getMBeanRegistry();
        return registry.isMBeanRegistered(MBEAN_OBJECT_NAME);
    }

    public static boolean registerMetricAdminMBean() {
        SdkMBeanRegistry registry = SdkMBeanRegistry$Factory.getMBeanRegistry();
        return registry.registerMetricAdminMBean(MBEAN_OBJECT_NAME);
    }

    public static boolean unregisterMetricAdminMBean() {
        SdkMBeanRegistry registry = SdkMBeanRegistry$Factory.getMBeanRegistry();
        return registry.unregisterMBean(MBEAN_OBJECT_NAME);
    }

    public static <T extends RequestMetricCollector> T getRequestMetricCollector() {
        if (mc == null && AwsSdkMetrics.isDefaultMetricsEnabled()) {
            AwsSdkMetrics.enableDefaultMetrics();
        }
        RequestMetricCollector t2 = mc == null ? RequestMetricCollector.NONE : mc.getRequestMetricCollector();
        return (T)t2;
    }

    public static <T extends ServiceMetricCollector> T getServiceMetricCollector() {
        if (mc == null && AwsSdkMetrics.isDefaultMetricsEnabled()) {
            AwsSdkMetrics.enableDefaultMetrics();
        }
        ServiceMetricCollector t2 = mc == null ? ServiceMetricCollector.NONE : mc.getServiceMetricCollector();
        return (T)t2;
    }

    static MetricCollector getInternalMetricCollector() {
        return mc;
    }

    public static <T extends MetricCollector> T getMetricCollector() {
        if (mc == null && AwsSdkMetrics.isDefaultMetricsEnabled()) {
            AwsSdkMetrics.enableDefaultMetrics();
        }
        MetricCollector t2 = mc == null ? MetricCollector.NONE : mc;
        return (T)t2;
    }

    public static synchronized void setMetricCollector(MetricCollector mc2) {
        MetricCollector old = mc;
        mc = mc2;
        if (old != null) {
            old.stop();
        }
    }

    public static void setMachineMetricsExcluded(boolean excludeMachineMetrics) {
        machineMetricsExcluded = excludeMachineMetrics;
    }

    public static void setPerHostMetricsIncluded(boolean includePerHostMetrics) {
        perHostMetricsIncluded = includePerHostMetrics;
    }

    public static boolean isDefaultMetricsEnabled() {
        return defaultMetricsEnabled;
    }

    public static boolean isSingleMetricNamespace() {
        return singleMetricNamespace;
    }

    public static void setSingleMetricNamespace(boolean singleMetricNamespace) {
        AwsSdkMetrics.singleMetricNamespace = singleMetricNamespace;
    }

    public static boolean isMetricsEnabled() {
        MetricCollector mc2 = mc;
        return mc2 != null && mc2.isEnabled();
    }

    public static boolean isMachineMetricExcluded() {
        return machineMetricsExcluded;
    }

    public static boolean isPerHostMetricIncluded() {
        return perHostMetricsIncluded;
    }

    public static boolean isPerHostMetricEnabled() {
        if (perHostMetricsIncluded) {
            return true;
        }
        String host = hostMetricName;
        host = host == null ? "" : host.trim();
        return host.length() > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized boolean enableDefaultMetrics() {
        if (mc == null || !mc.isEnabled()) {
            if (dirtyEnabling) {
                throw new IllegalStateException("Reentrancy is not allowed");
            }
            dirtyEnabling = true;
            try {
                Class<?> c2 = Class.forName(DEFAULT_METRIC_COLLECTOR_FACTORY);
                MetricCollector$Factory f2 = (MetricCollector$Factory)c2.newInstance();
                MetricCollector instance = f2.getInstance();
                if (instance != null) {
                    AwsSdkMetrics.setMetricCollector(instance);
                    boolean bl2 = true;
                    return bl2;
                }
            }
            catch (Exception e2) {
                LogFactory.getLog(AwsSdkMetrics.class).warn("Failed to enable the default metrics", e2);
            }
            finally {
                dirtyEnabling = false;
            }
        }
        return false;
    }

    public static void disableMetrics() {
        AwsSdkMetrics.setMetricCollector(MetricCollector.NONE);
    }

    public static boolean add(MetricType type) {
        return type == null ? false : registry.addMetricType(type);
    }

    public static <T extends MetricType> boolean addAll(Collection<T> types) {
        return types == null || types.size() == 0 ? false : registry.addMetricTypes(types);
    }

    public static <T extends MetricType> void set(Collection<T> types) {
        registry.setMetricTypes(types);
    }

    public static boolean remove(MetricType type) {
        return type == null ? false : registry.removeMetricType(type);
    }

    public static Set<MetricType> getPredefinedMetrics() {
        return registry.predefinedMetrics();
    }

    public static AWSCredentialsProvider getCredentialProvider() {
        StackTraceElement[] e2 = Thread.currentThread().getStackTrace();
        for (int i2 = 0; i2 < e2.length; ++i2) {
            if (!e2[i2].getClassName().equals(DEFAULT_METRIC_COLLECTOR_FACTORY)) continue;
            return credentialProvider;
        }
        SecurityException ex2 = new SecurityException();
        LogFactory.getLog(AwsSdkMetrics.class).warn("Illegal attempt to access the credential provider", ex2);
        throw ex2;
    }

    public static synchronized void setCredentialProvider(AWSCredentialsProvider provider) {
        credentialProvider = provider;
    }

    public static Regions getRegion() {
        return region;
    }

    public static void setRegion(Regions region) {
        AwsSdkMetrics.region = region;
    }

    public static String getCredentailFile() {
        return credentialFile;
    }

    public static void setCredentialFile(String filepath) {
        AwsSdkMetrics.setCredentialFile0(filepath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void setCredentialFile0(String filepath) {
        PropertiesCredentials cred = new PropertiesCredentials(new File(filepath));
        Class<AwsSdkMetrics> clazz = AwsSdkMetrics.class;
        synchronized (AwsSdkMetrics.class) {
            credentialProvider = new AwsSdkMetrics$1(cred);
            credentialFile = filepath;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public static Integer getMetricQueueSize() {
        return metricQueueSize;
    }

    public static void setMetricQueueSize(Integer size) {
        metricQueueSize = size;
    }

    public static Long getQueuePollTimeoutMilli() {
        return queuePollTimeoutMilli;
    }

    public static void setQueuePollTimeoutMilli(Long timeoutMilli) {
        queuePollTimeoutMilli = timeoutMilli;
    }

    public static String getMetricNameSpace() {
        return metricNameSpace;
    }

    public static void setMetricNameSpace(String metricNameSpace) {
        if (metricNameSpace == null || metricNameSpace.trim().length() == 0) {
            throw new IllegalArgumentException();
        }
        AwsSdkMetrics.metricNameSpace = metricNameSpace;
    }

    public static String getJvmMetricName() {
        return jvmMetricName;
    }

    public static void setJvmMetricName(String jvmMetricName) {
        AwsSdkMetrics.jvmMetricName = jvmMetricName;
    }

    public static String getHostMetricName() {
        return hostMetricName;
    }

    public static void setHostMetricName(String hostMetricName) {
        AwsSdkMetrics.hostMetricName = hostMetricName;
    }

    static {
        metricNameSpace = DEFAULT_METRIC_NAMESPACE;
        String defaultMetrics = System.getProperty("com.amazonaws.sdk.enableDefaultMetrics");
        boolean bl2 = defaultMetricsEnabled = defaultMetrics != null;
        if (defaultMetricsEnabled) {
            String[] values = defaultMetrics.split(",");
            boolean excludeMachineMetrics = false;
            boolean includePerHostMetrics = false;
            boolean useSingleMetricNamespace = false;
            for (String s2 : values) {
                String part = s2.trim();
                if (!excludeMachineMetrics && EXCLUDE_MACHINE_METRICS.equals(part)) {
                    excludeMachineMetrics = true;
                    continue;
                }
                if (!includePerHostMetrics && INCLUDE_PER_HOST_METRICS.equals(part)) {
                    includePerHostMetrics = true;
                    continue;
                }
                if (!useSingleMetricNamespace && USE_SINGLE_METRIC_NAMESPACE.equals(part)) {
                    useSingleMetricNamespace = true;
                    continue;
                }
                String[] pair = part.split("=");
                if (pair.length != 2) continue;
                String key = pair[0].trim();
                String value = pair[1].trim();
                try {
                    Number i2;
                    if (AWS_CREDENTAIL_PROPERTIES_FILE.equals(key)) {
                        AwsSdkMetrics.setCredentialFile0(value);
                        continue;
                    }
                    if (CLOUDWATCH_REGION.equals(key)) {
                        region = Regions.fromName(value);
                        continue;
                    }
                    if (METRIC_QUEUE_SIZE.equals(key)) {
                        i2 = new Integer(value);
                        if ((Integer)i2 < 1) {
                            throw new IllegalArgumentException("metricQueueSize must be at least 1");
                        }
                        metricQueueSize = i2;
                        continue;
                    }
                    if (QUEUE_POLL_TIMEOUT_MILLI.equals(key)) {
                        i2 = new Long(value);
                        if (((Long)i2).intValue() < 1000) {
                            throw new IllegalArgumentException("getQueuePollTimeoutMilli must be at least 1000");
                        }
                        queuePollTimeoutMilli = i2;
                        continue;
                    }
                    if (METRIC_NAME_SPACE.equals(key)) {
                        metricNameSpace = value;
                        continue;
                    }
                    if (JVM_METRIC_NAME.equals(key)) {
                        jvmMetricName = value;
                        continue;
                    }
                    if (HOST_METRIC_NAME.equals(key)) {
                        hostMetricName = value;
                        continue;
                    }
                    LogFactory.getLog(AwsSdkMetrics.class).debug("Ignoring unrecognized parameter: " + part);
                }
                catch (Exception e2) {
                    LogFactory.getLog(AwsSdkMetrics.class).debug("Ignoring failure", e2);
                }
            }
            machineMetricsExcluded = excludeMachineMetrics;
            perHostMetricsIncluded = includePerHostMetrics;
            singleMetricNamespace = useSingleMetricNamespace;
        }
        registry = new AwsSdkMetrics$MetricRegistry();
        try {
            AwsSdkMetrics.registerMetricAdminMBean();
        }
        catch (Exception ex2) {
            LogFactory.getLog(AwsSdkMetrics.class).warn("", ex2);
        }
    }
}

