/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.metrics;

import com.amazonaws.internal.SdkFilterInputStream;
import com.amazonaws.metrics.ByteThroughputHelper;
import com.amazonaws.metrics.ThroughputMetricType;
import java.io.InputStream;

public class MetricFilterInputStream
extends SdkFilterInputStream {
    private final ByteThroughputHelper helper;

    public MetricFilterInputStream(ThroughputMetricType type, InputStream in2) {
        super(in2);
        this.helper = new ByteThroughputHelper(type);
    }

    @Override
    public int read(byte[] b2, int off, int len) {
        this.abortIfNeeded();
        long startNano = this.helper.startTiming();
        int bytesRead = this.in.read(b2, off, len);
        if (bytesRead > 0) {
            this.helper.increment(bytesRead, startNano);
        }
        return bytesRead;
    }

    @Override
    public void close() {
        this.helper.reportMetrics();
        this.in.close();
        this.abortIfNeeded();
    }

    @Override
    public final boolean isMetricActivated() {
        return true;
    }
}

