/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.retry;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonServiceException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.retry.RetryPolicy$RetryCondition;
import com.amazonaws.retry.RetryUtils;
import java.io.IOException;

public class PredefinedRetryPolicies$SDKDefaultRetryCondition
implements RetryPolicy$RetryCondition {
    @Override
    public boolean shouldRetry(AmazonWebServiceRequest originalRequest, AmazonClientException exception, int retriesAttempted) {
        if (exception.getCause() instanceof IOException) {
            return true;
        }
        if (exception instanceof AmazonServiceException) {
            AmazonServiceException ase = (AmazonServiceException)exception;
            if (ase.getStatusCode() == 500 || ase.getStatusCode() == 503) {
                return true;
            }
            if (RetryUtils.isThrottlingException(ase)) {
                return true;
            }
            if (RetryUtils.isClockSkewError(ase)) {
                return true;
            }
        }
        return false;
    }
}

