/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3.internal;

import com.amazonaws.internal.SdkFilterInputStream;
import java.io.InputStream;

public final class InputSubstream
extends SdkFilterInputStream {
    private long currentPosition = 0L;
    private final long requestedOffset;
    private final long requestedLength;
    private final boolean closeSourceStream;
    private long markedPosition = 0L;

    public InputSubstream(InputStream in2, long offset, long length, boolean closeSourceStream) {
        super(in2);
        this.requestedLength = length;
        this.requestedOffset = offset;
        this.closeSourceStream = closeSourceStream;
    }

    @Override
    public int read() {
        byte[] b2 = new byte[1];
        int bytesRead = this.read(b2, 0, 1);
        if (bytesRead == -1) {
            return bytesRead;
        }
        return b2[0];
    }

    @Override
    public int read(byte[] b2, int off, int len) {
        while (this.currentPosition < this.requestedOffset) {
            long skippedBytes = super.skip(this.requestedOffset - this.currentPosition);
            this.currentPosition += skippedBytes;
        }
        long bytesRemaining = this.requestedLength + this.requestedOffset - this.currentPosition;
        if (bytesRemaining <= 0L) {
            return -1;
        }
        len = (int)Math.min((long)len, bytesRemaining);
        int bytesRead = super.read(b2, off, len);
        this.currentPosition += (long)bytesRead;
        return bytesRead;
    }

    @Override
    public synchronized void mark(int readlimit) {
        this.markedPosition = this.currentPosition;
        super.mark(readlimit);
    }

    @Override
    public synchronized void reset() {
        this.currentPosition = this.markedPosition;
        super.reset();
    }

    @Override
    public void close() {
        if (this.closeSourceStream) {
            super.close();
        }
    }

    @Override
    public int available() {
        long bytesRemaining = this.currentPosition < this.requestedOffset ? this.requestedLength : this.requestedLength + this.requestedOffset - this.currentPosition;
        return (int)Math.min(bytesRemaining, (long)super.available());
    }
}

